/*
 * Decompiled with CFR 0.152.
 */
package fr.jrds.snmpcodec.parsing;

import fr.jrds.snmpcodec.parsing.OidPath;

abstract class ValueType<T> {
    final T value;

    ValueType(T value) {
        this.value = value;
    }

    public String toString() {
        return this.value.toString();
    }

    static class IntegerValue
    extends ValueType<Number> {
        IntegerValue(Number value) {
            super(value);
        }
    }

    static class StringValue
    extends ValueType<String> {
        StringValue(String value) {
            super(value);
        }

        @Override
        public String toString() {
            return "\"" + (String)this.value + "\"";
        }
    }

    static class BooleanValue
    extends ValueType<Boolean> {
        BooleanValue(Boolean value) {
            super(value);
        }
    }

    static class OidValue
    extends ValueType<OidPath> {
        OidValue(OidPath value) {
            super(value);
        }
    }
}

