/*
 * Decompiled with CFR 0.152.
 */
package fr.jrds.snmpcodec.smi;

import fr.jrds.snmpcodec.MibException;
import fr.jrds.snmpcodec.smi.Constraint;
import fr.jrds.snmpcodec.smi.Symbol;
import fr.jrds.snmpcodec.smi.Syntax;
import fr.jrds.snmpcodec.smi.SyntaxContainer;
import fr.jrds.snmpcodec.smi.TextualConvention;
import java.util.Map;
import org.snmp4j.smi.Variable;

public class AnnotedSyntax
extends Syntax
implements SyntaxContainer {
    private final Syntax syntax;

    public AnnotedSyntax(Syntax syntax, Map<Number, String> names, Constraint constraints) {
        super(names, constraints);
        this.syntax = syntax;
    }

    @Override
    public String format(Variable v) {
        if (this.isNamed()) {
            int value = v.toInt();
            return String.format("%s(%d)", this.getNameFromNumer(value), value);
        }
        return this.syntax.format(v);
    }

    @Override
    public Object convert(Variable v) {
        if (this.isNamed()) {
            return this.getNameFromNumer(v.toInt());
        }
        return this.syntax.convert(v);
    }

    @Override
    public Variable parse(String text) {
        if (this.isNamed()) {
            return this.syntax.getVariable(this.getNumberFromName(text));
        }
        return this.syntax.parse(text);
    }

    @Override
    public Variable getVariable() {
        return this.syntax.getVariable();
    }

    @Override
    public Variable getVariable(Object source) {
        return this.syntax.getVariable(source);
    }

    @Override
    public Syntax getSyntax() {
        return this.syntax;
    }

    @Override
    public String toString() {
        return super.toString() + " -> " + String.valueOf(this.syntax);
    }

    @Override
    public TextualConvention getTextualConvention(String hint, Syntax type) throws MibException {
        return this.syntax.getTextualConvention(hint, type);
    }

    @Override
    public void resolve(Map<Symbol, Syntax> types) throws MibException {
        this.syntax.resolve(types);
    }
}

