/*
 * Decompiled with CFR 0.152.
 */
package fr.jrds.snmpcodec.smi;

import fr.jrds.snmpcodec.smi.Index;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Constraint {
    private final List<ConstraintElement> ranges = new ArrayList<ConstraintElement>();
    private final boolean size;
    private boolean variableSize;

    public Constraint(boolean size) {
        this.size = size;
    }

    public void add(ConstraintElement newElement) {
        this.ranges.add(newElement);
    }

    Index.Parsed extract(int[] oidElements) {
        Index.Parsed tryExtract = new Index.Parsed();
        if (!this.size) {
            tryExtract.content = Arrays.copyOf(oidElements, 1);
            if (oidElements.length > 1) {
                tryExtract.next = Arrays.copyOfRange(oidElements, 1, oidElements.length);
            }
        } else {
            for (ConstraintElement i : this.ranges) {
                if (this.variableSize) {
                    int elementSize = oidElements[0];
                    if (elementSize == 0) {
                        tryExtract.content = new int[0];
                        tryExtract.next = oidElements;
                    }
                    if (oidElements.length < elementSize) continue;
                    tryExtract.content = Arrays.copyOfRange(oidElements, 1, elementSize + 1);
                    if (elementSize + 1 <= oidElements.length) {
                        tryExtract.next = Arrays.copyOfRange(oidElements, elementSize + 1, oidElements.length);
                        continue;
                    }
                    tryExtract.next = null;
                    continue;
                }
                if (oidElements.length == i.value.intValue()) {
                    tryExtract.content = oidElements;
                    tryExtract.next = null;
                    return tryExtract;
                }
                if (oidElements.length <= i.value.intValue()) continue;
                tryExtract.content = Arrays.copyOf(oidElements, i.value.intValue());
                if (i.value.intValue() + 1 <= oidElements.length) {
                    tryExtract.next = Arrays.copyOfRange(oidElements, i.value.intValue(), oidElements.length);
                    continue;
                }
                tryExtract.next = null;
            }
        }
        return tryExtract;
    }

    public String toString() {
        return this.ranges.toString();
    }

    public void finish() {
        this.variableSize = this.ranges.size() > 1 ? true : this.ranges.get((int)0).value == null;
    }

    public static class ConstraintElement {
        public final Number value;
        public final Number from;
        public final Number to;

        public ConstraintElement(Number value) {
            this.value = value;
            this.from = null;
            this.to = null;
        }

        public ConstraintElement(Number from, Number to) {
            this.value = null;
            this.from = from;
            this.to = to;
        }

        public String toString() {
            if (this.value != null) {
                return this.value.toString();
            }
            return this.from.toString() + ".." + this.to.toString();
        }
    }
}

