/*
 * Decompiled with CFR 0.152.
 */
package fr.jrds.snmpcodec.smi;

import fr.jrds.snmpcodec.MibStore;
import fr.jrds.snmpcodec.OidTreeNode;
import fr.jrds.snmpcodec.Utils;
import fr.jrds.snmpcodec.log.LogAdapter;
import fr.jrds.snmpcodec.smi.ObjectType;
import fr.jrds.snmpcodec.smi.Syntax;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.Variable;

public class Index {
    private static final LogAdapter logger = LogAdapter.getLogger(Index.class);
    private final List<OidTreeNode> indexes;

    public Index(List<OidTreeNode> indexes) {
        this.indexes = indexes;
    }

    public String toString() {
        return this.indexes.toString();
    }

    public Map<String, Object> resolve(int[] oid, MibStore store) {
        LinkedHashMap<String, Object> indexesValues = new LinkedHashMap<String, Object>(this.indexes.size());
        int[] oidParsed = Arrays.copyOf(oid, oid.length);
        for (OidTreeNode i : this.indexes) {
            Parsed parsed;
            ObjectType column = store.objects.get(i);
            if (column == null) {
                logger.error("index not found: %s", i);
                break;
            }
            Syntax codec = column.getSyntax();
            Variable v = codec.getVariable();
            logger.debug("given %s, found %s %s", i, codec, column);
            if (codec.getConstrains() != null) {
                parsed = codec.getConstrains().extract(oidParsed);
            } else if (v instanceof IpAddress) {
                parsed = new Parsed();
                parsed.content = Arrays.copyOf(oidParsed, 4);
                if (oidParsed.length > 1) {
                    parsed.next = Arrays.copyOfRange(oidParsed, 4, oidParsed.length);
                }
            } else {
                parsed = new Parsed();
                parsed.content = Arrays.copyOf(oidParsed, 1);
                if (oidParsed.length > 1) {
                    parsed.next = Arrays.copyOfRange(oidParsed, 1, oidParsed.length);
                }
            }
            if (parsed == null) break;
            logger.debug("parsed %s from %s with %s/%s", parsed, oidParsed, i, codec);
            if (v == null) break;
            OID subIndex = new OID(parsed.content);
            v.fromSubIndex(subIndex, true);
            Object o = codec.convert(v);
            if (codec.isNamed()) {
                o = codec.getNameFromNumer(v.toInt());
            }
            indexesValues.put(i.getSymbol(), o);
            oidParsed = parsed.next;
            if (oidParsed != null) continue;
            break;
        }
        if (oidParsed != null) {
            String traillings = Arrays.stream(oidParsed).mapToObj(Integer::toString).collect(Collectors.joining("."));
            throw new IllegalArgumentException("Trailing elements in index: " + traillings);
        }
        logger.debug("will resolve %s to %s", oid, indexesValues);
        return indexesValues;
    }

    static class Parsed {
        public int[] content = null;
        public int[] next = null;

        Parsed() {
        }

        public String toString() {
            return (this.content != null ? Utils.dottedNotation(this.content) : "_") + "/" + (this.next != null ? Utils.dottedNotation(this.next) : "_");
        }
    }
}

