/*
 * Decompiled with CFR 0.152.
 */
package fr.jrds.snmpcodec.smi;

import fr.jrds.snmpcodec.MibException;
import fr.jrds.snmpcodec.parsing.OidPath;
import fr.jrds.snmpcodec.smi.Symbol;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Oid {
    private final Symbol root;
    private final List<OidPath.OidComponent> components;
    private List<Integer> path = null;
    private final String name;
    private final boolean pathfirst;

    public Oid(Symbol root, List<OidPath.OidComponent> components, String name) throws MibException {
        if (components.isEmpty() && root == null) {
            throw new MibException("Creating empty OID " + String.valueOf(components));
        }
        this.root = root;
        this.components = components;
        this.name = name;
        this.pathfirst = false;
    }

    public Oid(List<Integer> path, String name) throws MibException {
        if (path == null || path.isEmpty()) {
            throw new MibException("Creating empty OID " + name);
        }
        this.path = path;
        this.root = null;
        this.components = null;
        this.name = name;
        this.pathfirst = true;
    }

    public int getNativeSize() {
        return this.components == null ? 0 : this.components.size();
    }

    public List<Integer> getPath(Map<Symbol, Oid> oids) throws MibException {
        if (this.path == null) {
            if (this.root != null) {
                Oid parent = oids.get(this.root);
                if (parent == null) {
                    this.failedPath();
                    throw new MibException(String.format("missing root symbol from %s", this));
                }
                List<Integer> parentpath = parent.getPath(oids);
                if (parentpath.isEmpty()) {
                    this.failedPath();
                    throw new MibException("Invalid OID path for symbol " + String.valueOf(this.root));
                }
                this.path = new ArrayList<Integer>();
                this.path.addAll(parentpath);
            }
            if (this.path == null) {
                this.path = new ArrayList<Integer>();
            }
            this.components.forEach(i -> this.path.add(i.number));
        }
        return this.path;
    }

    private void failedPath() {
        this.path = new ArrayList<Integer>(this.components.size() + 1);
        this.path.add(-1);
        this.components.stream().map(i -> i.number).forEach(i -> this.path.add((Integer)i));
    }

    public String toString() {
        if (this.path == null || this.path.isEmpty() || this.path.get(0) == -1) {
            return (String)(this.root != null ? String.valueOf(this.root) + "." : "") + this.components.stream().map(OidPath.OidComponent::toString).collect(Collectors.joining("."));
        }
        return this.path.stream().map(Object::toString).collect(Collectors.joining("."));
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        if (this.pathfirst) {
            result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        } else {
            result = 31 * result + (this.root == null ? 0 : this.root.hashCode());
            result = 31 * result + (this.components == null ? 0 : this.components.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Oid other = (Oid)obj;
        if (this.pathfirst) {
            return this.path.equals(other.path) && this.name.equals(other.name);
        }
        if (this.root == null ? other.root != null : !this.root.equals(other.root)) {
            return false;
        }
        if (this.components == null ? other.components != null : !this.components.equals(other.components)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

