/*
 * Decompiled with CFR 0.152.
 */
package fr.jrds.snmpcodec.smi;

import fr.jrds.snmpcodec.MibException;
import fr.jrds.snmpcodec.Utils;
import fr.jrds.snmpcodec.log.LogAdapter;
import fr.jrds.snmpcodec.smi.Constraint;
import fr.jrds.snmpcodec.smi.Syntax;
import fr.jrds.snmpcodec.smi.TextualConvention;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.snmp4j.asn1.BER;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.smi.AbstractVariable;
import org.snmp4j.smi.BitString;
import org.snmp4j.smi.Counter32;
import org.snmp4j.smi.Counter64;
import org.snmp4j.smi.Gauge32;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.Null;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Opaque;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.UnsignedInteger32;
import org.snmp4j.smi.Variable;

public abstract class SmiType
extends Syntax {
    public static final SmiType Opaque = new SmiType(){

        @Override
        public Variable getVariable() {
            return new Opaque();
        }

        @Override
        public Variable getVariable(Object source) {
            if (!(source instanceof byte[])) {
                throw SmiType.resolveInvalidObject(source, "byte[]");
            }
            byte[] a = (byte[])source;
            return new Opaque(a);
        }

        @Override
        public Object convert(Variable v) {
            Opaque opaqueVar = (Opaque)v;
            Object value = opaqueVar.getValue();
            try {
                byte[] bytesArray = opaqueVar.getValue();
                ByteBuffer bais = ByteBuffer.wrap(bytesArray);
                BERInputStream beris = new BERInputStream(bais);
                byte t1 = bais.get();
                byte t2 = bais.get();
                int l = BER.decodeLength((BERInputStream)beris);
                if (t1 == -97) {
                    if (t2 == 120 && l == 4) {
                        value = Float.valueOf(bais.getFloat());
                    } else if (t2 == 121 && l == 8) {
                        value = bais.getDouble();
                    }
                }
            }
            catch (IOException e) {
                logger.error(opaqueVar.toString(), new Object[0]);
            }
            return value;
        }

        @Override
        public Variable parse(String text) {
            return new Opaque(text.getBytes());
        }

        @Override
        public int getSyntaxString() {
            return 68;
        }
    };
    public static final SmiType OctetString = new SmiType(){

        @Override
        public Variable getVariable() {
            return new OctetString();
        }

        @Override
        public Variable getVariable(Object source) {
            if (!(source instanceof byte[])) {
                throw SmiType.resolveInvalidObject(source, "byte[]");
            }
            byte[] a = (byte[])source;
            return new OctetString(a);
        }

        @Override
        public Object convert(Variable v) {
            OctetString newVar;
            OctetString octetVar = (OctetString)v;
            int length = octetVar.length();
            if (length > 1 && octetVar.get(length - 1) == 0 && (newVar = octetVar.substring(0, length - 1)).isPrintable()) {
                v = newVar;
                logger.debug("Converting an octet stream from %s to %s", octetVar, v);
            }
            return v.toString();
        }

        @Override
        public Variable parse(String text) {
            return org.snmp4j.smi.OctetString.fromByteArray((byte[])text.getBytes());
        }

        @Override
        public TextualConvention getTextualConvention(String hint, Syntax type) throws MibException {
            return new TextualConvention.PatternDisplayHint(type, hint, type.getConstrains());
        }

        @Override
        public int getSyntaxString() {
            return 4;
        }
    };
    public static final SmiType Unsigned32 = new SmiType(){

        @Override
        public Variable getVariable() {
            return new UnsignedInteger32();
        }

        @Override
        public Variable getVariable(Object source) {
            if (!(source instanceof Number)) {
                throw SmiType.resolveInvalidObject(source, "Number");
            }
            Number n = (Number)source;
            return new UnsignedInteger32(n.longValue());
        }

        @Override
        public Object convert(Variable v) {
            return v.toLong();
        }

        @Override
        public TextualConvention getTextualConvention(String hint, Syntax type) throws MibException {
            return new TextualConvention.Unsigned32DisplayHint(type, hint);
        }

        @Override
        public int getSyntaxString() {
            return 66;
        }

        @Override
        public String toString() {
            return "Unsigned32";
        }
    };
    @Deprecated
    public static final SmiType BitString = new SmiType(){

        @Override
        public Variable getVariable() {
            return new BitString();
        }

        @Override
        public Variable getVariable(Object source) {
            return null;
        }

        @Override
        public Object convert(Variable v) {
            return v.toString();
        }

        @Override
        public int getSyntaxString() {
            return 3;
        }
    };
    public static final SmiType IpAddr = new SmiType(){

        @Override
        public Variable getVariable() {
            return new IpAddress();
        }

        @Override
        public Variable getVariable(Object source) {
            if (!(source instanceof InetAddress) && !(source instanceof String)) {
                throw SmiType.resolveInvalidObject(source, "InetAddress or String");
            }
            if (source instanceof InetAddress) {
                return new IpAddress((InetAddress)source);
            }
            return new IpAddress((String)source);
        }

        @Override
        public Object convert(Variable v) {
            return ((IpAddress)v).getInetAddress();
        }

        @Override
        public String format(Variable v) {
            IpAddress ip = (IpAddress)v;
            return ip.getInetAddress().getHostName();
        }

        @Override
        public Variable parse(String text) {
            return new IpAddress(text);
        }

        @Override
        public int getSyntaxString() {
            return 64;
        }
    };
    public static final SmiType ObjID = new SmiType(){

        @Override
        public Variable getVariable() {
            return new OID();
        }

        @Override
        public Variable getVariable(Object source) {
            if (source instanceof int[]) {
                int[] oid = (int[])source;
                return new OID(oid);
            }
            if (source instanceof String) {
                return new OID((String)source);
            }
            throw SmiType.resolveInvalidObject(source, "int[] or String");
        }

        @Override
        public Object convert(Variable v) {
            return v;
        }

        @Override
        public String format(Variable v) {
            return ((OID)v).format();
        }

        @Override
        public Variable parse(String text) {
            return new OID(text);
        }

        @Override
        public int getSyntaxString() {
            return 6;
        }

        @Override
        public TextualConvention getTextualConvention(String hint, Syntax type) {
            return new TextualConvention.OidTextualConvention(type);
        }
    };
    public static final SmiType INTEGER = new SmiType(){

        @Override
        public Variable getVariable() {
            return new Integer32();
        }

        @Override
        public Variable getVariable(Object source) {
            if (!(source instanceof Number)) {
                throw SmiType.resolveInvalidObject(source, "Number");
            }
            Number n = (Number)source;
            return new Integer32(n.intValue());
        }

        @Override
        public Object convert(Variable v) {
            return v.toInt();
        }

        @Override
        public String format(Variable v) {
            return String.valueOf(v.toInt());
        }

        @Override
        public Variable parse(String text) {
            return new Integer32(Integer.parseInt(text));
        }

        @Override
        public TextualConvention getTextualConvention(String hint, Syntax type) throws MibException {
            return new TextualConvention.Signed32DisplayHint(type, hint);
        }

        @Override
        public int getSyntaxString() {
            return 2;
        }

        @Override
        public String toString() {
            return "INTEGER";
        }
    };
    public static final SmiType Counter32 = new SmiType(){

        @Override
        public Variable getVariable() {
            return new Counter32();
        }

        @Override
        public Variable getVariable(Object source) {
            if (!(source instanceof Number)) {
                throw SmiType.resolveInvalidObject(source, "Number");
            }
            Number n = (Number)source;
            return new Counter32(n.longValue());
        }

        @Override
        public Object convert(Variable v) {
            return v.toLong();
        }

        @Override
        public String format(Variable v) {
            return String.valueOf(v.toLong());
        }

        @Override
        public Variable parse(String text) {
            return new Counter32(Long.parseLong(text));
        }

        @Override
        public TextualConvention getTextualConvention(String hint, Syntax type) throws MibException {
            return new TextualConvention.Unsigned32DisplayHint(type, hint);
        }

        @Override
        public int getSyntaxString() {
            return 65;
        }

        @Override
        public String toString() {
            return "Counter32";
        }
    };
    public static final SmiType Counter64 = new SmiType(){

        @Override
        public Variable getVariable() {
            return new Counter64();
        }

        @Override
        public Variable getVariable(Object source) {
            if (!(source instanceof Number)) {
                throw SmiType.resolveInvalidObject(source, "Number");
            }
            Number n = (Number)source;
            return new Counter64(n.longValue());
        }

        @Override
        public Object convert(Variable v) {
            return Utils.getUnsigned(v.toLong());
        }

        @Override
        public String format(Variable v) {
            return Long.toUnsignedString(v.toLong());
        }

        @Override
        public Variable parse(String text) {
            return new Counter64(Long.parseLong(text));
        }

        @Override
        public TextualConvention getTextualConvention(String hint, Syntax type) throws MibException {
            return new TextualConvention.Counter64DisplayHint(type, hint);
        }

        @Override
        public int getSyntaxString() {
            return 70;
        }
    };
    public static final SmiType Gauge32 = new SmiType(){

        @Override
        public Variable getVariable() {
            return new Gauge32();
        }

        @Override
        public Variable getVariable(Object source) {
            if (!(source instanceof Number)) {
                throw SmiType.resolveInvalidObject(source, "Number");
            }
            Number n = (Number)source;
            return new Gauge32(n.longValue());
        }

        @Override
        public Object convert(Variable v) {
            return v.toLong();
        }

        @Override
        public String format(Variable v) {
            return String.valueOf(v.toLong());
        }

        @Override
        public Variable parse(String text) {
            return new Gauge32(Long.parseLong(text));
        }

        @Override
        public TextualConvention getTextualConvention(String hint, Syntax type) throws MibException {
            return new TextualConvention.Unsigned32DisplayHint(type, hint);
        }

        @Override
        public int getSyntaxString() {
            return 65;
        }

        @Override
        public String toString() {
            return "Gauge32";
        }
    };
    public static final SmiType TimeTicks = new SmiType(){

        @Override
        public Variable getVariable() {
            return new TimeTicks();
        }

        @Override
        public Variable getVariable(Object source) {
            if (!(source instanceof Number)) {
                throw SmiType.resolveInvalidObject(source, "Number");
            }
            Number n = (Number)source;
            return new TimeTicks(n.longValue());
        }

        @Override
        public Object convert(Variable v) {
            return ((TimeTicks)v).toMilliseconds();
        }

        @Override
        public Variable parse(String text) {
            try {
                long duration = Long.parseLong(text);
                return new TimeTicks(duration);
            }
            catch (NumberFormatException e) {
                Matcher m = TimeTicksPattern.matcher(text);
                if (m.matches()) {
                    String days = m.group("days") != null ? m.group("days") : "0";
                    String hours = m.group("hours");
                    String minutes = m.group("minutes");
                    String seconds = m.group("seconds");
                    String fraction = m.group("fraction");
                    String formatted = String.format("P%sDT%sH%sM%s.%sS", days, hours, minutes, seconds, fraction);
                    TimeTicks tt = new TimeTicks();
                    tt.fromMilliseconds(Duration.parse(formatted).toMillis());
                    return tt;
                }
                return new Null();
            }
        }

        @Override
        public TextualConvention getTextualConvention(String hint, Syntax type) throws MibException {
            return new TextualConvention.Unsigned32DisplayHint(type, hint);
        }

        @Override
        public int getSyntaxString() {
            return 67;
        }
    };
    public static final SmiType Null = new SmiType(){

        @Override
        public Variable getVariable() {
            return new Null();
        }

        @Override
        public Variable getVariable(Object source) {
            return this.getVariable();
        }

        @Override
        public Object convert(Variable v) {
            return null;
        }

        @Override
        public String format(Variable v) {
            return "";
        }

        @Override
        public Variable parse(String text) {
            return new Null();
        }

        @Override
        public int getSyntaxString() {
            return 5;
        }
    };
    private static final Pattern TimeTicksPattern = Pattern.compile("(?:(?<days>\\d+) days?, )?(?<hours>\\d+):(?<minutes>\\d+):(?<seconds>\\d+)(?:\\.(?<fraction>\\d+))?");
    private static final LogAdapter logger = LogAdapter.getLogger(SmiType.class);
    private static final byte TAG1 = -97;
    private static final byte TAG_FLOAT = 120;
    private static final byte TAG_DOUBLE = 121;

    protected SmiType() {
        super(null, null);
    }

    @Override
    public String format(Variable v) {
        return v.toString();
    }

    @Override
    public Variable parse(String text) {
        return null;
    }

    @Override
    public abstract Object convert(Variable var1);

    public abstract int getSyntaxString();

    public Object make(int[] in) {
        Variable v = this.getVariable();
        OID oid = new OID(in);
        v.fromSubIndex(oid, true);
        return this.convert(v);
    }

    @Override
    public Constraint getConstrains() {
        return null;
    }

    @Override
    public String toString() {
        return AbstractVariable.getSyntaxString((int)this.getSyntaxString());
    }

    @Override
    public TextualConvention getTextualConvention(String hint, Syntax type) throws MibException {
        return null;
    }

    private static RuntimeException resolveInvalidObject(Object source, String expected) {
        if (source == null) {
            return new NullPointerException();
        }
        return new IllegalArgumentException("Given a variable of type " + source.getClass().getName() + " instead of " + expected);
    }
}

