/*
 * Decompiled with CFR 0.152.
 */
package fr.jrds.snmpcodec.smi;

public class Symbol {
    public final String module;
    public final String name;

    public Symbol(String module, String name) {
        if (name == null) {
            throw new IllegalArgumentException("Invalid symbol");
        }
        this.module = module.intern();
        this.name = name.intern();
    }

    public Symbol(String name) {
        int separator = name.indexOf(46);
        this.module = separator > 0 ? name.substring(0, separator).intern() : null;
        this.name = name.substring(separator + 1).intern();
    }

    public String toString() {
        return ((String)(this.module != null ? this.module + "." : "") + this.name).intern();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.module == null ? 0 : this.module.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != Symbol.class) {
            return false;
        }
        Symbol other = (Symbol)obj;
        if (this.module == null) {
            return other.module == null && this.name.equals(other.name);
        }
        return this.name.equals(other.name) && this.module.equals(other.module);
    }
}

