/*
 * Decompiled with CFR 0.152.
 */
package fr.jrds.snmpcodec.smi;

import fr.jrds.snmpcodec.MibException;
import fr.jrds.snmpcodec.smi.Constraint;
import fr.jrds.snmpcodec.smi.Symbol;
import fr.jrds.snmpcodec.smi.TextualConvention;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.snmp4j.smi.Variable;

public abstract class Syntax {
    private static final Pattern NAMEDINDEXFORMAT = Pattern.compile("(?<name>\\p{L}(?:[\\p{L}\\d])+)(?:\\s*\\((?<value>\\d+)?\\))?");
    private final Constraint constraints;
    private final Map<String, Integer> fromname;
    private final Map<Integer, String> toname;

    protected Syntax(Map<Number, String> names, Constraint constraints) {
        if (names != null) {
            this.toname = new HashMap<Integer, String>(names.size());
            this.fromname = new HashMap<String, Integer>(names.size());
            names.forEach((key, name) -> {
                Integer val = key.intValue();
                this.toname.put(val, (String)name);
                this.fromname.put((String)name, val);
            });
        } else {
            this.toname = Collections.emptyMap();
            this.fromname = Collections.emptyMap();
        }
        this.constraints = constraints;
    }

    public abstract String format(Variable var1);

    public abstract Object convert(Variable var1);

    public abstract Variable parse(String var1);

    public abstract Variable getVariable();

    public abstract Variable getVariable(Object var1);

    public Constraint getConstrains() {
        return this.constraints;
    }

    public boolean isNamed() {
        return !this.toname.isEmpty();
    }

    public String getNameFromNumer(int number) {
        return this.toname.get(number);
    }

    public Integer getNumberFromName(String name) {
        Matcher m = NAMEDINDEXFORMAT.matcher(name);
        if (!m.matches()) {
            try {
                return Integer.parseInt(name);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (m.group("value") != null) {
            return Integer.parseInt(m.group("value"));
        }
        if (m.group("name") != null) {
            return this.fromname.get(m.group("name"));
        }
        return null;
    }

    public TextualConvention getTextualConvention(String hint, Syntax type) throws MibException {
        throw new MibException("Can't provide textual convention");
    }

    public void resolve(Map<Symbol, Syntax> types) throws MibException {
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toname.forEach((i, j) -> buffer.append(String.format("%s (%d) ", j, i)));
        if (this.constraints != null) {
            buffer.append(this.constraints);
        }
        return buffer.toString();
    }
}

