/*
 * Decompiled with CFR 0.152.
 */
package fr.jrds.snmpcodec.smi;

import fr.jrds.snmpcodec.MibException;
import fr.jrds.snmpcodec.smi.AnnotedSyntax;
import fr.jrds.snmpcodec.smi.Constraint;
import fr.jrds.snmpcodec.smi.SmiType;
import fr.jrds.snmpcodec.smi.Syntax;
import fr.jrds.snmpcodec.smi.SyntaxContainer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.snmp4j.smi.AssignableFromString;
import org.snmp4j.smi.Counter64;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.UnsignedInteger32;
import org.snmp4j.smi.Variable;

public abstract class TextualConvention
extends AnnotedSyntax
implements SyntaxContainer {
    private TextualConvention(Syntax syntax, Map<Number, String> names, Constraint constraints) {
        super(syntax, names, constraints);
    }

    @Override
    public String toString() {
        return String.format("TextualConvention[%s]", this.getSyntax());
    }

    public static class Bits
    extends TextualConvention {
        Bits() {
            super(null, null, null);
        }
    }

    public static class DisplayString
    extends AbstractPatternDisplayHint<OctetString> {
        private static final Constraint Constraint255a = new Constraint(true);
        private static final AnnotedSyntax localsyntax;

        public DisplayString() {
            super(localsyntax, "255a", null, null);
        }

        @Override
        public String patternFormat(OctetString v) {
            if (v.isPrintable()) {
                return new String(v.getValue(), StandardCharsets.US_ASCII);
            }
            return v.toHexString();
        }

        @Override
        public Variable patternParse(String text) {
            return new OctetString(text.getBytes(StandardCharsets.US_ASCII));
        }

        @Override
        public Object convert(Variable v) {
            return this.patternFormat((OctetString)v);
        }

        static {
            Constraint255a.add(new Constraint.ConstraintElement(255));
            localsyntax = new AnnotedSyntax(SmiType.OctetString, null, Constraint255a);
        }
    }

    public static class PatternDisplayHint
    extends AbstractPatternDisplayHint<OctetString> {
        private static final Pattern element = Pattern.compile("(?<repeat>\\*)?(?<length>\\d*)(?<format>[xdoath])(?<separator>[^\\d\\*](?<terminator>[^\\d\\*])?)?");
        private final DisplayHintClause[] clauses;

        public PatternDisplayHint(Syntax syntax, String hint, Constraint constraint) throws MibException {
            super(syntax, hint, null, constraint);
            if (hint != null) {
                Matcher m = element.matcher(hint);
                ArrayList<DisplayHintClause> currentClauses = new ArrayList<DisplayHintClause>();
                while (m.find()) {
                    boolean repeat = m.group("repeat") != null;
                    int length = !m.group("length").isEmpty() ? Integer.parseInt(m.group("length")) : 0;
                    char format = m.group("format").charAt(0);
                    char separator = m.group("separator") != null ? m.group("separator").charAt(0) : (char)'\u0000';
                    char terminator = m.group("terminator") != null && repeat ? m.group("terminator").charAt(0) : (char)'\u0000';
                    currentClauses.add(new DisplayHintClause(repeat, length, format, separator, terminator));
                }
                if (currentClauses.isEmpty()) {
                    throw new MibException("Invalid display hint " + hint + " ");
                }
                this.clauses = currentClauses.toArray(new DisplayHintClause[0]);
            } else {
                this.clauses = new DisplayHintClause[0];
            }
        }

        @Override
        public String patternFormat(OctetString os) {
            if (this.hint == null) {
                return SmiType.OctetString.format((Variable)os);
            }
            ByteBuffer buffer = ByteBuffer.wrap(os.toByteArray());
            buffer.order(ByteOrder.BIG_ENDIAN);
            StringBuilder formatted = new StringBuilder();
            for (DisplayHintClause clause : this.clauses) {
                if (!buffer.hasRemaining()) break;
                int repeat = clause.repeat ? buffer.get() : 1;
                int length = clause.length != 0 ? clause.length : buffer.remaining();
                for (int i = 0; i < repeat; ++i) {
                    switch (clause.format) {
                        case 'd': 
                        case 'o': 
                        case 'x': {
                            formatted.append(this.resolveNumerical("%" + clause.format, buffer, length));
                            break;
                        }
                        case 'a': 
                        case 't': {
                            byte[] sub = new byte[Math.min(clause.length, buffer.remaining())];
                            buffer.get(sub);
                            formatted.append(new String(sub, clause.format == 'a' ? StandardCharsets.US_ASCII : StandardCharsets.UTF_8));
                            break;
                        }
                    }
                    if (clause.separator == '\u0000' || !buffer.hasRemaining()) continue;
                    formatted.append(clause.separator);
                }
            }
            return formatted.toString();
        }

        private String resolveNumerical(String numberFormatter, ByteBuffer buffer, int length) {
            switch (length) {
                case 1: {
                    return String.format(numberFormatter, buffer.get());
                }
                case 2: {
                    return String.format(numberFormatter, buffer.getShort());
                }
                case 4: {
                    return String.format(numberFormatter, buffer.getInt());
                }
            }
            throw new IllegalArgumentException("Invalid length " + length);
        }

        @Override
        public Variable patternParse(String text) {
            throw new UnsupportedOperationException("Not implemented yet");
        }

        @Override
        public String toString() {
            return "DisplayHint[" + this.getHint() + "]";
        }
    }

    private static class DisplayHintClause {
        private final boolean repeat;
        private final int length;
        private final char format;
        private final char separator;
        private final char terminator;

        public DisplayHintClause(boolean repeat, int length, char format, char separator, char terminator) {
            this.repeat = repeat;
            this.length = length;
            this.format = format;
            this.separator = separator;
            this.terminator = terminator;
        }

        public String toString() {
            return "DisplayHintClause{repeat=" + this.repeat + ", length=" + this.length + ", format=" + this.format + ", separator=" + this.separator + ", terminator=" + this.terminator + "}";
        }
    }

    public static class Counter64DisplayHint
    extends NumberDisplayHint<Counter64> {
        protected Counter64DisplayHint(Syntax syntax, String hint) throws MibException {
            super(syntax, hint);
        }
    }

    public static class Signed32DisplayHint<V extends Integer32>
    extends NumberDisplayHint<V> {
        protected Signed32DisplayHint(Syntax syntax, String hint) throws MibException {
            super(syntax, hint);
        }
    }

    public static class Unsigned32DisplayHint<V extends UnsignedInteger32>
    extends NumberDisplayHint<V> {
        protected Unsigned32DisplayHint(Syntax syntax, String hint) throws MibException {
            super(syntax, hint);
        }
    }

    private static abstract class NumberDisplayHint<V extends Variable>
    extends AbstractPatternDisplayHint<V> {
        private static final Pattern floatPattern = Pattern.compile("(?<length>\\d+)?(?<radix>[dxob])(?:-(?<float>\\d+))?");
        protected final int fixedfloat;
        protected final char radix;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected NumberDisplayHint(Syntax syntax, String hint) throws MibException {
            super(syntax, hint, null, null);
            if (hint != null) {
                Matcher m = floatPattern.matcher(hint);
                if (!m.matches()) throw new MibException("Invalid display hint '" + hint + "'");
                this.radix = m.group("radix").charAt(0);
                String floatSuffix = m.group("float");
                this.fixedfloat = floatSuffix == null ? 0 : Integer.parseInt(floatSuffix);
                return;
            } else {
                this.fixedfloat = -1;
                this.radix = '\u0000';
            }
        }

        @Override
        public Variable patternParse(String text) {
            Variable val = this.getSyntax().getVariable();
            ((AssignableFromString)val).setValue(text);
            return val;
        }

        @Override
        protected String patternFormat(V val) {
            long l = val.toLong();
            if (this.fixedfloat == 0) {
                switch (this.radix) {
                    case 'd': {
                        return Long.toString(l);
                    }
                    case 'x': {
                        return Long.toHexString(l);
                    }
                    case 'o': {
                        return Long.toOctalString(l);
                    }
                    case 'b': {
                        return Long.toBinaryString(l);
                    }
                }
            } else {
                char[] formatted = Long.toString(l).toCharArray();
                if (formatted.length > this.fixedfloat) {
                    char[] newformatted = new char[formatted.length + 1];
                    int limit = formatted.length - this.fixedfloat;
                    System.arraycopy(formatted, 0, newformatted, 0, limit);
                    newformatted[limit] = 46;
                    System.arraycopy(formatted, limit, newformatted, limit + 1, this.fixedfloat);
                    return new String(newformatted);
                }
                char[] newformatted = new char[this.fixedfloat + 1];
                Arrays.fill(newformatted, '0');
                newformatted[0] = 46;
                for (int i = formatted.length - 1; i >= 0; --i) {
                    newformatted[this.fixedfloat - formatted.length + i + 1] = formatted[i];
                }
                return new String(newformatted);
            }
            return null;
        }
    }

    public static class DateAndTime
    extends AbstractPatternDisplayHint<OctetString> {
        private static final Constraint Constraint8or11 = new Constraint(true);
        private static final AnnotedSyntax localsyntax;
        private static final Pattern HINTREGEX;

        public DateAndTime() {
            super(localsyntax, "2d-1d-1d,1d:1d:1d.1d,1a1d:1d", null, Constraint8or11);
        }

        @Override
        public String patternFormat(OctetString os) {
            String zoneOffset;
            ByteBuffer buffer = ByteBuffer.wrap(os.toByteArray());
            buffer.order(ByteOrder.BIG_ENDIAN);
            short year = buffer.getShort();
            byte month = buffer.get();
            byte day = buffer.get();
            byte hour = buffer.get();
            byte minutes = buffer.get();
            byte seconds = buffer.get();
            byte deciSeconds = buffer.get();
            if (buffer.hasRemaining()) {
                char directionFromUTC = Character.toChars(buffer.get())[0];
                byte hourFromUTC = buffer.get();
                byte minutesFromUTC = buffer.get();
                zoneOffset = String.format(",%c%d:%d", Character.valueOf(directionFromUTC), (int)hourFromUTC, (int)minutesFromUTC);
            } else {
                zoneOffset = "";
            }
            return String.format("%d-%d-%d,%d:%d:%d.%d%s", year, (int)month, (int)day, (int)hour, (int)minutes, (int)seconds, (int)deciSeconds, zoneOffset);
        }

        @Override
        public Variable patternParse(String text) {
            Matcher match = HINTREGEX.matcher(text);
            if (!match.find()) {
                return null;
            }
            ByteBuffer buffer = ByteBuffer.allocate(match.group(8) != null ? 11 : 8);
            buffer.order(ByteOrder.BIG_ENDIAN);
            buffer.putShort(Short.parseShort(match.group(1)));
            buffer.put(Byte.parseByte(match.group(2)));
            buffer.put(Byte.parseByte(match.group(3)));
            buffer.put(Byte.parseByte(match.group(4)));
            buffer.put(Byte.parseByte(match.group(5)));
            buffer.put(Byte.parseByte(match.group(6)));
            buffer.put(Byte.parseByte(match.group(7)));
            if (match.group(8) != null) {
                buffer.put(match.group(9).getBytes()[0]);
                buffer.put(Byte.parseByte(match.group(10)));
                buffer.put(Byte.parseByte(match.group(11)));
            }
            return OctetString.fromByteArray((byte[])buffer.array());
        }

        static {
            Constraint8or11.add(new Constraint.ConstraintElement(8));
            Constraint8or11.add(new Constraint.ConstraintElement(11));
            localsyntax = new AnnotedSyntax(SmiType.OctetString, null, Constraint8or11);
            HINTREGEX = Pattern.compile("(\\d+)-(\\d+)-(\\d+),(\\d+):(\\d+):(\\d+).(\\d+)(,([+-])(\\d+):(\\d+))?");
        }
    }

    public static abstract class AbstractPatternDisplayHint<V extends Variable>
    extends TextualConvention {
        protected final String hint;

        protected AbstractPatternDisplayHint(Syntax syntax, String hint, Map<Number, String> names, Constraint constraints) {
            super(syntax, names, constraints);
            this.hint = hint;
        }

        public String getHint() {
            return this.hint;
        }

        @Override
        public Variable parse(String text) {
            if (this.hint == null) {
                return super.parse(text);
            }
            return this.patternParse(text);
        }

        @Override
        public final String format(Variable v) {
            if (this.hint == null) {
                return super.format(v);
            }
            return this.patternFormat(v);
        }

        protected abstract String patternFormat(V var1);

        protected abstract Variable patternParse(String var1);
    }

    public static class OidTextualConvention
    extends TextualConvention {
        public OidTextualConvention(Syntax syntax) {
            super(syntax, null, null);
        }
    }
}

