/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.pnml.pthlpng.hlcorestructure.impl;

import fr.lip6.move.pnml.framework.general.PnmlExport;
import fr.lip6.move.pnml.framework.utils.IdRefLinker;
import fr.lip6.move.pnml.framework.utils.ModelRepository;
import fr.lip6.move.pnml.framework.utils.PNMLEncoding;
import fr.lip6.move.pnml.framework.utils.PrettyPrintData;
import fr.lip6.move.pnml.framework.utils.exception.InnerBuildException;
import fr.lip6.move.pnml.framework.utils.exception.InvalidIDException;
import fr.lip6.move.pnml.framework.utils.exception.VoidRepositoryException;
import fr.lip6.move.pnml.pthlpng.hlcorestructure.HlcorestructureFactory;
import fr.lip6.move.pnml.pthlpng.hlcorestructure.HlcorestructurePackage;
import fr.lip6.move.pnml.pthlpng.hlcorestructure.PetriNet;
import fr.lip6.move.pnml.pthlpng.hlcorestructure.PetriNetDoc;
import fr.lip6.move.pnml.pthlpng.hlcorestructure.util.HlcorestructureValidator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.axiom.om.OMElement;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.InternalEList;

public class PetriNetDocImpl
extends MinimalEObjectImpl
implements PetriNetDoc {
    protected EList<PetriNet> nets;
    protected static final String XMLNS_EDEFAULT = "http://www.pnml.org/version-2009/grammar/pnml";
    protected String xmlns = "http://www.pnml.org/version-2009/grammar/pnml";

    protected PetriNetDocImpl() {
    }

    protected EClass eStaticClass() {
        return HlcorestructurePackage.Literals.PETRI_NET_DOC;
    }

    @Override
    public List<PetriNet> getNets() {
        if (this.nets == null) {
            this.nets = new EObjectContainmentWithInverseEList(PetriNet.class, (InternalEObject)this, 0, 5);
        }
        return this.nets;
    }

    @Override
    public String getXmlns() {
        return this.xmlns;
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return ((InternalEList)this.getNets()).basicAdd((Object)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return ((InternalEList)this.getNets()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getNets();
            }
            case 1: {
                return this.getXmlns();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.getNets().clear();
                this.getNets().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.getNets().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.nets != null && !this.nets.isEmpty();
            }
            case 1: {
                return XMLNS_EDEFAULT == null ? this.xmlns != null : !XMLNS_EDEFAULT.equals(this.xmlns);
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (xmlns: ");
        result.append(this.xmlns);
        result.append(')');
        return result.toString();
    }

    @Override
    public String toPNML() {
        Boolean prettyPrintStatus = ModelRepository.getInstance().isPrettyPrintActive();
        String retline = "";
        String headline = "";
        PrettyPrintData prpd = null;
        if (prettyPrintStatus.booleanValue()) {
            retline = "\n";
            prpd = ModelRepository.getInstance().getPrettyPrintData();
            headline = prpd.getCurrentLineHeader();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(headline);
        sb.append("<pnml");
        if (prettyPrintStatus.booleanValue()) {
            headline = prpd.increaseLineHeaderLevel();
        }
        if (this.getXmlns() != null) {
            sb.append(" xmlns");
            sb.append("=\"");
            sb.append(this.getXmlns());
            sb.append("\"");
        }
        boolean haveSons = false;
        sb.append(">");
        sb.append(retline);
        if (this.getNets() != null) {
            List<PetriNet> items = this.getNets();
            for (PetriNet item : items) {
                sb.append(item.toPNML());
                haveSons = true;
            }
        }
        if (prettyPrintStatus.booleanValue()) {
            headline = prpd.decreaseLineHeaderLevel();
        }
        if (haveSons) {
            sb.append(headline);
            sb.append("</pnml>");
            sb.append(retline);
        } else {
            sb.delete(sb.lastIndexOf(">"), sb.length());
            sb.append("/>");
        }
        return sb.toString();
    }

    @Override
    public void fromPNML(OMElement locRoot, IdRefLinker idr) throws InnerBuildException, InvalidIDException, VoidRepositoryException {
        Iterator iterator = locRoot.getChildElements();
        while (iterator.hasNext()) {
            OMElement type = (OMElement)iterator.next();
            if (!type.getLocalName().equals("net")) continue;
            PetriNet item = HlcorestructureFactory.eINSTANCE.createPetriNet();
            item.fromPNML(type, idr);
            item.setContainerPetriNetDoc(this);
        }
    }

    @Override
    public void toPNML(FileChannel fc) {
        ByteBuffer bytebuf = ByteBuffer.allocateDirect(8192);
        String charsetEncoding = PNMLEncoding.ISO_8859_1.getName();
        Boolean prettyPrintStatus = ModelRepository.getInstance().isPrettyPrintActive();
        String retline = "";
        String headline = "";
        PrettyPrintData prpd = null;
        if (prettyPrintStatus.booleanValue()) {
            retline = "\n";
            prpd = ModelRepository.getInstance().getPrettyPrintData();
            headline = prpd.getCurrentLineHeader();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(headline);
        sb.append("<pnml");
        if (prettyPrintStatus.booleanValue()) {
            headline = prpd.increaseLineHeaderLevel();
        }
        if (this.getXmlns() != null) {
            sb.append(" xmlns");
            sb.append("=\"");
            sb.append(this.getXmlns());
            sb.append("\"");
        }
        sb.append(">");
        sb.append(retline);
        if (this.getNets() != null) {
            try {
                PetriNetDocImpl.writeIntoStream(bytebuf, fc, sb.toString().getBytes(Charset.forName(charsetEncoding)));
            }
            catch (IOException io) {
                io.printStackTrace();
                return;
            }
            sb.delete(0, sb.length());
            List<PetriNet> items = this.getNets();
            for (PetriNet item : items) {
                item.toPNML(fc);
            }
        }
        if (prettyPrintStatus.booleanValue()) {
            headline = prpd.decreaseLineHeaderLevel();
        }
        sb.append(headline);
        sb.append("</pnml>");
        sb.append(retline);
        try {
            PetriNetDocImpl.writeIntoStream(bytebuf, fc, sb.toString().getBytes(Charset.forName(charsetEncoding)));
        }
        catch (IOException io) {
            io.printStackTrace();
            return;
        }
        sb = null;
    }

    private static final void writeIntoStream(ByteBuffer bytebuf, FileChannel fc, byte[] contents) throws IOException {
        if (contents.length >= bytebuf.capacity()) {
            List chops = PnmlExport.chopBytes((byte[])contents, (int)6144);
            for (byte[] buf : chops) {
                bytebuf.put(buf);
                bytebuf.flip();
                fc.write(bytebuf);
                bytebuf.clear();
            }
        } else {
            bytebuf.put(contents);
            bytebuf.flip();
            fc.write(bytebuf);
            bytebuf.clear();
        }
    }

    @Override
    public boolean validateOCL(DiagnosticChain diagnostics) {
        HlcorestructureValidator val = new HlcorestructureValidator();
        boolean retour = true;
        if (this.getNets() != null) {
            List<PetriNet> items = this.getNets();
            for (PetriNet item : items) {
                retour &= item.validateOCL(diagnostics);
            }
        }
        return retour &= val.validate(this, diagnostics, null);
    }
}

