/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.pnml.pthlpng.terms.impl;

import fr.lip6.move.pnml.framework.general.PnmlExport;
import fr.lip6.move.pnml.framework.utils.IdRefLinker;
import fr.lip6.move.pnml.framework.utils.ModelRepository;
import fr.lip6.move.pnml.framework.utils.PNMLEncoding;
import fr.lip6.move.pnml.framework.utils.PrettyPrintData;
import fr.lip6.move.pnml.framework.utils.exception.InnerBuildException;
import fr.lip6.move.pnml.framework.utils.exception.InvalidIDException;
import fr.lip6.move.pnml.framework.utils.exception.VoidRepositoryException;
import fr.lip6.move.pnml.pthlpng.booleans.BooleansFactory;
import fr.lip6.move.pnml.pthlpng.dots.DotsFactory;
import fr.lip6.move.pnml.pthlpng.terms.NamedSort;
import fr.lip6.move.pnml.pthlpng.terms.Sort;
import fr.lip6.move.pnml.pthlpng.terms.TermsFactory;
import fr.lip6.move.pnml.pthlpng.terms.TermsPackage;
import fr.lip6.move.pnml.pthlpng.terms.impl.SortDeclImpl;
import fr.lip6.move.pnml.pthlpng.terms.util.TermsValidator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

public class NamedSortImpl
extends SortDeclImpl
implements NamedSort {
    protected Sort sortdef;

    protected NamedSortImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return TermsPackage.Literals.NAMED_SORT;
    }

    @Override
    public Sort getSortdef() {
        return this.sortdef;
    }

    public NotificationChain basicSetSortdef(Sort newSortdef, NotificationChain msgs) {
        Sort oldSortdef = this.sortdef;
        this.sortdef = newSortdef;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldSortdef, (Object)newSortdef);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setSortdef(Sort newSortdef) {
        if (newSortdef != this.sortdef) {
            NotificationChain msgs = null;
            if (this.sortdef != null) {
                msgs = ((InternalEObject)this.sortdef).eInverseRemove((InternalEObject)this, 1, Sort.class, msgs);
            }
            if (newSortdef != null) {
                msgs = ((InternalEObject)newSortdef).eInverseAdd((InternalEObject)this, 1, Sort.class, msgs);
            }
            if ((msgs = this.basicSetSortdef(newSortdef, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)newSortdef, (Object)newSortdef));
        }
    }

    @Override
    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 3: {
                if (this.sortdef != null) {
                    msgs = ((InternalEObject)this.sortdef).eInverseRemove((InternalEObject)this, -4, null, msgs);
                }
                return this.basicSetSortdef((Sort)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 3: {
                return this.basicSetSortdef(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 3: {
                return this.getSortdef();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 3: {
                this.setSortdef((Sort)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 3: {
                this.setSortdef(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 3: {
                return this.sortdef != null;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toPNML() {
        String top;
        Boolean prettyPrintStatus = ModelRepository.getInstance().isPrettyPrintActive();
        String retline = "";
        String headline = "";
        PrettyPrintData prpd = null;
        if (prettyPrintStatus.booleanValue()) {
            retline = "\n";
            prpd = ModelRepository.getInstance().getPrettyPrintData();
            headline = prpd.getCurrentLineHeader();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(headline);
        sb.append("<namedsort");
        if (prettyPrintStatus.booleanValue()) {
            headline = prpd.increaseLineHeaderLevel();
        }
        if (this.getId() != null) {
            sb.append(" id");
            sb.append("=\"");
            sb.append(this.getId());
            sb.append("\"");
        }
        if (this.getName() != null) {
            sb.append(" name");
            sb.append("=\"");
            sb.append(this.getName());
            sb.append("\"");
        }
        boolean haveSons = false;
        sb.append(">");
        sb.append(retline);
        if (this.getSortdef() != null && !(top = this.getSortdef().toPNML()).equals("")) {
            sb.append(top);
            haveSons = true;
        }
        if (prettyPrintStatus.booleanValue()) {
            headline = prpd.decreaseLineHeaderLevel();
        }
        if (haveSons) {
            sb.append(headline);
            sb.append("</namedsort>");
            sb.append(retline);
        } else {
            sb.delete(sb.lastIndexOf(">"), sb.length());
            sb.append("/>");
        }
        return sb.toString();
    }

    @Override
    public void fromPNML(OMElement locRoot, IdRefLinker idr) throws InnerBuildException, InvalidIDException, VoidRepositoryException {
        if (locRoot.getAttributeValue(new QName("id")) != null) {
            this.setId(new String(locRoot.getAttributeValue(new QName("id"))));
            ModelRepository.getInstance().getCurrentIdRepository().checkId(new String(locRoot.getAttributeValue(new QName("id"))).toString(), (Object)this);
        }
        if (locRoot.getAttributeValue(new QName("name")) != null) {
            try {
                this.setName(new String(locRoot.getAttributeValue(new QName("name"))));
            }
            catch (Exception e) {
                throw new InnerBuildException((Throwable)e);
            }
        }
        Iterator iterator = locRoot.getChildElements();
        while (iterator.hasNext()) {
            Sort item;
            OMElement type = (OMElement)iterator.next();
            if (type.getLocalName().equals("multisetsort")) {
                item = TermsFactory.eINSTANCE.createMultisetSort();
                item.fromPNML(type, idr);
                item.setContainerNamedSort(this);
                continue;
            }
            if (type.getLocalName().equals("productsort")) {
                item = TermsFactory.eINSTANCE.createProductSort();
                item.fromPNML(type, idr);
                item.setContainerNamedSort(this);
                continue;
            }
            if (type.getLocalName().equals("usersort")) {
                item = TermsFactory.eINSTANCE.createUserSort();
                item.fromPNML(type, idr);
                item.setContainerNamedSort(this);
                continue;
            }
            if (type.getLocalName().equals("null")) {
                item = BooleansFactory.eINSTANCE.createBool();
                item.fromPNML(type, idr);
                item.setContainerNamedSort(this);
                continue;
            }
            if (!type.getLocalName().equals("dot")) continue;
            item = DotsFactory.eINSTANCE.createDot();
            item.fromPNML(type, idr);
            item.setContainerNamedSort(this);
        }
    }

    @Override
    public void toPNML(FileChannel fc) {
        String top;
        ByteBuffer bytebuf = ByteBuffer.allocateDirect(8192);
        String charsetEncoding = PNMLEncoding.ISO_8859_1.getName();
        Boolean prettyPrintStatus = ModelRepository.getInstance().isPrettyPrintActive();
        String retline = "";
        String headline = "";
        PrettyPrintData prpd = null;
        if (prettyPrintStatus.booleanValue()) {
            retline = "\n";
            prpd = ModelRepository.getInstance().getPrettyPrintData();
            headline = prpd.getCurrentLineHeader();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(headline);
        sb.append("<namedsort");
        if (prettyPrintStatus.booleanValue()) {
            headline = prpd.increaseLineHeaderLevel();
        }
        if (this.getId() != null) {
            sb.append(" id");
            sb.append("=\"");
            sb.append(this.getId());
            sb.append("\"");
        }
        if (this.getName() != null) {
            sb.append(" name");
            sb.append("=\"");
            sb.append(this.getName());
            sb.append("\"");
        }
        sb.append(">");
        sb.append(retline);
        if (this.getSortdef() != null && !(top = this.getSortdef().toPNML()).equals("")) {
            sb.append(top);
        }
        if (prettyPrintStatus.booleanValue()) {
            headline = prpd.decreaseLineHeaderLevel();
        }
        sb.append(headline);
        sb.append("</namedsort>");
        sb.append(retline);
        try {
            NamedSortImpl.writeIntoStream(bytebuf, fc, sb.toString().getBytes(Charset.forName(charsetEncoding)));
        }
        catch (IOException io) {
            io.printStackTrace();
            return;
        }
        sb = null;
    }

    private static final void writeIntoStream(ByteBuffer bytebuf, FileChannel fc, byte[] contents) throws IOException {
        if (contents.length >= bytebuf.capacity()) {
            List chops = PnmlExport.chopBytes((byte[])contents, (int)6144);
            for (byte[] buf : chops) {
                bytebuf.put(buf);
                bytebuf.flip();
                fc.write(bytebuf);
                bytebuf.clear();
            }
        } else {
            bytebuf.put(contents);
            bytebuf.flip();
            fc.write(bytebuf);
            bytebuf.clear();
        }
    }

    @Override
    public boolean validateOCL(DiagnosticChain diagnostics) {
        TermsValidator val = new TermsValidator();
        boolean retour = true;
        if (this.getSortdef() != null) {
            retour &= this.getSortdef().validateOCL(diagnostics);
        }
        return retour &= val.validate(this, diagnostics, null);
    }
}

