/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.pnml.ptnet;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum CSS2FontWeight implements Enumerator
{
    NORMAL(0, "NORMAL", "normal"),
    BOLD(1, "BOLD", "bold"),
    BOLDER(2, "BOLDER", "bolder"),
    LIGHTER(3, "LIGHTER", "lighter");

    public static final int NORMAL_VALUE = 0;
    public static final int BOLD_VALUE = 1;
    public static final int BOLDER_VALUE = 2;
    public static final int LIGHTER_VALUE = 3;
    private static final CSS2FontWeight[] VALUES_ARRAY;
    public static final List<CSS2FontWeight> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new CSS2FontWeight[]{NORMAL, BOLD, BOLDER, LIGHTER};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static CSS2FontWeight get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CSS2FontWeight result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CSS2FontWeight getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CSS2FontWeight result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CSS2FontWeight get(int value) {
        switch (value) {
            case 0: {
                return NORMAL;
            }
            case 1: {
                return BOLD;
            }
            case 2: {
                return BOLDER;
            }
            case 3: {
                return LIGHTER;
            }
        }
        return null;
    }

    private CSS2FontWeight(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

