/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.pnml.ptnet.impl;

import fr.lip6.move.pnml.framework.general.PnmlExport;
import fr.lip6.move.pnml.framework.utils.IdRefLinker;
import fr.lip6.move.pnml.framework.utils.ModelRepository;
import fr.lip6.move.pnml.framework.utils.PNMLEncoding;
import fr.lip6.move.pnml.framework.utils.PrettyPrintData;
import fr.lip6.move.pnml.framework.utils.exception.InnerBuildException;
import fr.lip6.move.pnml.framework.utils.exception.InvalidIDException;
import fr.lip6.move.pnml.framework.utils.exception.VoidRepositoryException;
import fr.lip6.move.pnml.ptnet.Arc;
import fr.lip6.move.pnml.ptnet.PTArcAnnotation;
import fr.lip6.move.pnml.ptnet.PtnetFactory;
import fr.lip6.move.pnml.ptnet.PtnetPackage;
import fr.lip6.move.pnml.ptnet.ToolInfo;
import fr.lip6.move.pnml.ptnet.impl.AnnotationImpl;
import fr.lip6.move.pnml.ptnet.util.PtnetValidator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import org.apache.axiom.om.OMElement;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class PTArcAnnotationImpl
extends AnnotationImpl
implements PTArcAnnotation {
    protected static final Long TEXT_EDEFAULT = null;
    protected Long text = TEXT_EDEFAULT;

    protected PTArcAnnotationImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return PtnetPackage.Literals.PT_ARC_ANNOTATION;
    }

    @Override
    public Long getText() {
        return this.text;
    }

    @Override
    public void setText(Long newText) {
        Long oldText = this.text;
        this.text = newText;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldText, (Object)this.text));
        }
    }

    @Override
    public Arc getContainerArc() {
        if (this.eContainerFeatureID() != 3) {
            return null;
        }
        return (Arc)this.eInternalContainer();
    }

    public NotificationChain basicSetContainerArc(Arc newContainerArc, NotificationChain msgs) {
        msgs = this.eBasicSetContainer((InternalEObject)newContainerArc, 3, msgs);
        return msgs;
    }

    @Override
    public void setContainerArc(Arc newContainerArc) {
        if (newContainerArc != this.eInternalContainer() || this.eContainerFeatureID() != 3 && newContainerArc != null) {
            if (EcoreUtil.isAncestor((EObject)this, (EObject)newContainerArc)) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain msgs = null;
            if (this.eInternalContainer() != null) {
                msgs = this.eBasicRemoveFromContainer(msgs);
            }
            if (newContainerArc != null) {
                msgs = ((InternalEObject)newContainerArc).eInverseAdd((InternalEObject)this, 7, Arc.class, msgs);
            }
            if ((msgs = this.basicSetContainerArc(newContainerArc, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)newContainerArc, (Object)newContainerArc));
        }
    }

    @Override
    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 3: {
                if (this.eInternalContainer() != null) {
                    msgs = this.eBasicRemoveFromContainer(msgs);
                }
                return this.basicSetContainerArc((Arc)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 3: {
                return this.basicSetContainerArc(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
        switch (this.eContainerFeatureID()) {
            case 3: {
                return this.eInternalContainer().eInverseRemove((InternalEObject)this, 7, Arc.class, msgs);
            }
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 2: {
                return this.getText();
            }
            case 3: {
                return this.getContainerArc();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                this.setText((Long)newValue);
                return;
            }
            case 3: {
                this.setContainerArc((Arc)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 2: {
                this.setText(TEXT_EDEFAULT);
                return;
            }
            case 3: {
                this.setContainerArc(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 2: {
                return TEXT_EDEFAULT == null ? this.text != null : !TEXT_EDEFAULT.equals(this.text);
            }
            case 3: {
                return this.getContainerArc() != null;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (text: ");
        result.append(this.text);
        result.append(')');
        return result.toString();
    }

    @Override
    public String toPNML() {
        String top;
        Boolean prettyPrintStatus = ModelRepository.getInstance().isPrettyPrintActive();
        String retline = "";
        String headline = "";
        PrettyPrintData prpd = null;
        if (prettyPrintStatus.booleanValue()) {
            retline = "\n";
            prpd = ModelRepository.getInstance().getPrettyPrintData();
            headline = prpd.getCurrentLineHeader();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(headline);
        sb.append("<inscription");
        if (prettyPrintStatus.booleanValue()) {
            headline = prpd.increaseLineHeaderLevel();
        }
        boolean haveSons = false;
        sb.append(">");
        sb.append(retline);
        if (this.getToolspecifics() != null) {
            List<ToolInfo> items = this.getToolspecifics();
            for (ToolInfo item : items) {
                sb.append(item.toPNML());
                haveSons = true;
            }
        }
        if (this.getAnnotationgraphics() != null && !(top = this.getAnnotationgraphics().toPNML()).equals("")) {
            sb.append(top);
            haveSons = true;
        }
        if (this.getText() != null) {
            sb.append(headline);
            sb.append("<");
            sb.append("text");
            sb.append(">");
            sb.append(this.getText().toString());
            sb.append("</");
            sb.append("text");
            sb.append(">");
            sb.append(retline);
            haveSons = true;
        }
        if (prettyPrintStatus.booleanValue()) {
            headline = prpd.decreaseLineHeaderLevel();
        }
        if (haveSons) {
            sb.append(headline);
            sb.append("</inscription>");
            sb.append(retline);
        } else {
            sb.delete(sb.lastIndexOf(">"), sb.length());
            sb.append("/>");
        }
        return sb.toString();
    }

    @Override
    public void fromPNML(OMElement locRoot, IdRefLinker idr) throws InnerBuildException, InvalidIDException, VoidRepositoryException {
        Iterator iterator = locRoot.getChildElements();
        while (iterator.hasNext()) {
            Object item;
            OMElement type = (OMElement)iterator.next();
            if (type.getLocalName().equals("toolspecific")) {
                item = PtnetFactory.eINSTANCE.createToolInfo();
                item.fromPNML(type, idr);
                item.setContainerLabel(this);
                continue;
            }
            if (type.getLocalName().equals("graphics")) {
                item = PtnetFactory.eINSTANCE.createAnnotationGraphics();
                item.fromPNML(type, idr);
                item.setContainerAnnotation(this);
                continue;
            }
            if (!type.getLocalName().equals("text")) continue;
            this.setText(new Long(type.getText()));
        }
    }

    @Override
    public void toPNML(FileChannel fc) {
        String top;
        ByteBuffer bytebuf = ByteBuffer.allocateDirect(8192);
        String charsetEncoding = PNMLEncoding.ISO_8859_1.getName();
        Boolean prettyPrintStatus = ModelRepository.getInstance().isPrettyPrintActive();
        String retline = "";
        String headline = "";
        PrettyPrintData prpd = null;
        if (prettyPrintStatus.booleanValue()) {
            retline = "\n";
            prpd = ModelRepository.getInstance().getPrettyPrintData();
            headline = prpd.getCurrentLineHeader();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(headline);
        sb.append("<inscription");
        if (prettyPrintStatus.booleanValue()) {
            headline = prpd.increaseLineHeaderLevel();
        }
        sb.append(">");
        sb.append(retline);
        if (this.getToolspecifics() != null) {
            try {
                PTArcAnnotationImpl.writeIntoStream(bytebuf, fc, sb.toString().getBytes(Charset.forName(charsetEncoding)));
            }
            catch (IOException io) {
                io.printStackTrace();
                return;
            }
            sb.delete(0, sb.length());
            List<ToolInfo> items = this.getToolspecifics();
            for (ToolInfo item : items) {
                item.toPNML(fc);
            }
        }
        if (this.getAnnotationgraphics() != null && !(top = this.getAnnotationgraphics().toPNML()).equals("")) {
            sb.append(top);
        }
        if (this.getText() != null) {
            sb.append(headline);
            sb.append("<");
            sb.append("text");
            sb.append(">");
            sb.append(this.getText().toString());
            sb.append("</");
            sb.append("text");
            sb.append(">");
            sb.append(retline);
        }
        if (prettyPrintStatus.booleanValue()) {
            headline = prpd.decreaseLineHeaderLevel();
        }
        sb.append(headline);
        sb.append("</inscription>");
        sb.append(retline);
        try {
            PTArcAnnotationImpl.writeIntoStream(bytebuf, fc, sb.toString().getBytes(Charset.forName(charsetEncoding)));
        }
        catch (IOException io) {
            io.printStackTrace();
            return;
        }
        sb = null;
    }

    private static final void writeIntoStream(ByteBuffer bytebuf, FileChannel fc, byte[] contents) throws IOException {
        if (contents.length >= bytebuf.capacity()) {
            List chops = PnmlExport.chopBytes((byte[])contents, (int)6144);
            for (byte[] buf : chops) {
                bytebuf.put(buf);
                bytebuf.flip();
                fc.write(bytebuf);
                bytebuf.clear();
            }
        } else {
            bytebuf.put(contents);
            bytebuf.flip();
            fc.write(bytebuf);
            bytebuf.clear();
        }
    }

    @Override
    public boolean validateOCL(DiagnosticChain diagnostics) {
        PtnetValidator val = new PtnetValidator();
        boolean retour = true;
        if (this.getToolspecifics() != null) {
            List<ToolInfo> items = this.getToolspecifics();
            for (ToolInfo item : items) {
                retour &= item.validateOCL(diagnostics);
            }
        }
        if (this.getAnnotationgraphics() != null) {
            retour &= this.getAnnotationgraphics().validateOCL(diagnostics);
        }
        return retour &= val.validate(this, diagnostics, null);
    }
}

