/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.pnml.ptnet.impl;

import fr.lip6.move.pnml.framework.general.PnmlExport;
import fr.lip6.move.pnml.framework.utils.IdRefLinker;
import fr.lip6.move.pnml.framework.utils.ModelRepository;
import fr.lip6.move.pnml.framework.utils.PNMLEncoding;
import fr.lip6.move.pnml.framework.utils.PrettyPrintData;
import fr.lip6.move.pnml.framework.utils.exception.InnerBuildException;
import fr.lip6.move.pnml.framework.utils.exception.InvalidIDException;
import fr.lip6.move.pnml.framework.utils.exception.VoidRepositoryException;
import fr.lip6.move.pnml.ptnet.PtnetFactory;
import fr.lip6.move.pnml.ptnet.PtnetPackage;
import fr.lip6.move.pnml.ptnet.ToolInfo;
import fr.lip6.move.pnml.ptnet.Transition;
import fr.lip6.move.pnml.ptnet.impl.TransitionNodeImpl;
import fr.lip6.move.pnml.ptnet.util.PtnetValidator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClass;

public class TransitionImpl
extends TransitionNodeImpl
implements Transition {
    protected TransitionImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return PtnetPackage.Literals.TRANSITION;
    }

    @Override
    public String toPNML() {
        String top;
        Boolean prettyPrintStatus = ModelRepository.getInstance().isPrettyPrintActive();
        String retline = "";
        String headline = "";
        PrettyPrintData prpd = null;
        if (prettyPrintStatus.booleanValue()) {
            retline = "\n";
            prpd = ModelRepository.getInstance().getPrettyPrintData();
            headline = prpd.getCurrentLineHeader();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(headline);
        sb.append("<transition");
        if (prettyPrintStatus.booleanValue()) {
            headline = prpd.increaseLineHeaderLevel();
        }
        if (this.getId() != null) {
            sb.append(" id");
            sb.append("=\"");
            sb.append(this.getId());
            sb.append("\"");
        }
        boolean haveSons = false;
        sb.append(">");
        sb.append(retline);
        if (this.getName() != null && !(top = this.getName().toPNML()).equals("")) {
            sb.append(top);
            haveSons = true;
        }
        if (this.getToolspecifics() != null) {
            List<ToolInfo> items = this.getToolspecifics();
            for (ToolInfo item : items) {
                sb.append(item.toPNML());
                haveSons = true;
            }
        }
        if (this.getNodegraphics() != null && !(top = this.getNodegraphics().toPNML()).equals("")) {
            sb.append(top);
            haveSons = true;
        }
        if (prettyPrintStatus.booleanValue()) {
            headline = prpd.decreaseLineHeaderLevel();
        }
        if (haveSons) {
            sb.append(headline);
            sb.append("</transition>");
            sb.append(retline);
        } else {
            sb.delete(sb.lastIndexOf(">"), sb.length());
            sb.append("/>");
        }
        return sb.toString();
    }

    @Override
    public void fromPNML(OMElement locRoot, IdRefLinker idr) throws InnerBuildException, InvalidIDException, VoidRepositoryException {
        if (locRoot.getAttributeValue(new QName("id")) != null) {
            this.setId(new String(locRoot.getAttributeValue(new QName("id"))));
            ModelRepository.getInstance().getCurrentIdRepository().checkId(new String(locRoot.getAttributeValue(new QName("id"))).toString(), (Object)this);
        }
        Iterator iterator = locRoot.getChildElements();
        while (iterator.hasNext()) {
            Object item;
            OMElement type = (OMElement)iterator.next();
            if (type.getLocalName().equals("name")) {
                item = PtnetFactory.eINSTANCE.createName();
                item.fromPNML(type, idr);
                item.setContainerNamePnObject(this);
                continue;
            }
            if (type.getLocalName().equals("toolspecific")) {
                item = PtnetFactory.eINSTANCE.createToolInfo();
                item.fromPNML(type, idr);
                item.setContainerPnObject(this);
                continue;
            }
            if (!type.getLocalName().equals("graphics")) continue;
            item = PtnetFactory.eINSTANCE.createNodeGraphics();
            item.fromPNML(type, idr);
            item.setContainerNode(this);
        }
    }

    @Override
    public void toPNML(FileChannel fc) {
        String top;
        ByteBuffer bytebuf = ByteBuffer.allocateDirect(8192);
        String charsetEncoding = PNMLEncoding.ISO_8859_1.getName();
        Boolean prettyPrintStatus = ModelRepository.getInstance().isPrettyPrintActive();
        String retline = "";
        String headline = "";
        PrettyPrintData prpd = null;
        if (prettyPrintStatus.booleanValue()) {
            retline = "\n";
            prpd = ModelRepository.getInstance().getPrettyPrintData();
            headline = prpd.getCurrentLineHeader();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(headline);
        sb.append("<transition");
        if (prettyPrintStatus.booleanValue()) {
            headline = prpd.increaseLineHeaderLevel();
        }
        if (this.getId() != null) {
            sb.append(" id");
            sb.append("=\"");
            sb.append(this.getId());
            sb.append("\"");
        }
        sb.append(">");
        sb.append(retline);
        if (this.getName() != null && !(top = this.getName().toPNML()).equals("")) {
            sb.append(top);
        }
        if (this.getToolspecifics() != null) {
            try {
                TransitionImpl.writeIntoStream(bytebuf, fc, sb.toString().getBytes(Charset.forName(charsetEncoding)));
            }
            catch (IOException io) {
                io.printStackTrace();
                return;
            }
            sb.delete(0, sb.length());
            List<ToolInfo> items = this.getToolspecifics();
            for (ToolInfo item : items) {
                item.toPNML(fc);
            }
        }
        if (this.getNodegraphics() != null && !(top = this.getNodegraphics().toPNML()).equals("")) {
            sb.append(top);
        }
        if (prettyPrintStatus.booleanValue()) {
            headline = prpd.decreaseLineHeaderLevel();
        }
        sb.append(headline);
        sb.append("</transition>");
        sb.append(retline);
        try {
            TransitionImpl.writeIntoStream(bytebuf, fc, sb.toString().getBytes(Charset.forName(charsetEncoding)));
        }
        catch (IOException io) {
            io.printStackTrace();
            return;
        }
        sb = null;
    }

    private static final void writeIntoStream(ByteBuffer bytebuf, FileChannel fc, byte[] contents) throws IOException {
        if (contents.length >= bytebuf.capacity()) {
            List chops = PnmlExport.chopBytes((byte[])contents, (int)6144);
            for (byte[] buf : chops) {
                bytebuf.put(buf);
                bytebuf.flip();
                fc.write(bytebuf);
                bytebuf.clear();
            }
        } else {
            bytebuf.put(contents);
            bytebuf.flip();
            fc.write(bytebuf);
            bytebuf.clear();
        }
    }

    @Override
    public boolean validateOCL(DiagnosticChain diagnostics) {
        PtnetValidator val = new PtnetValidator();
        boolean retour = true;
        if (this.getName() != null) {
            retour &= this.getName().validateOCL(diagnostics);
        }
        if (this.getToolspecifics() != null) {
            List<ToolInfo> items = this.getToolspecifics();
            for (ToolInfo item : items) {
                retour &= item.validateOCL(diagnostics);
            }
        }
        if (this.getNodegraphics() != null) {
            retour &= this.getNodegraphics().validateOCL(diagnostics);
        }
        return retour &= val.validate(this, diagnostics, null);
    }
}

