/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.pnml.symmetricnet.hlcorestructure;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Gradient implements Enumerator
{
    HORIZONTAL(0, "HORIZONTAL", "horizontal"),
    VERTICAL(1, "VERTICAL", "vertical"),
    DIAGONAL(2, "DIAGONAL", "diagonal");

    public static final int HORIZONTAL_VALUE = 0;
    public static final int VERTICAL_VALUE = 1;
    public static final int DIAGONAL_VALUE = 2;
    private static final Gradient[] VALUES_ARRAY;
    public static final List<Gradient> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Gradient[]{HORIZONTAL, VERTICAL, DIAGONAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Gradient get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Gradient result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Gradient getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Gradient result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Gradient get(int value) {
        switch (value) {
            case 0: {
                return HORIZONTAL;
            }
            case 1: {
                return VERTICAL;
            }
            case 2: {
                return DIAGONAL;
            }
        }
        return null;
    }

    private Gradient(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

