/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.pnml.symmetricnet.terms.impl;

import fr.lip6.move.pnml.framework.general.PnmlExport;
import fr.lip6.move.pnml.framework.utils.IdRefLinker;
import fr.lip6.move.pnml.framework.utils.ModelRepository;
import fr.lip6.move.pnml.framework.utils.PNMLEncoding;
import fr.lip6.move.pnml.framework.utils.PrettyPrintData;
import fr.lip6.move.pnml.framework.utils.exception.InnerBuildException;
import fr.lip6.move.pnml.framework.utils.exception.InvalidIDException;
import fr.lip6.move.pnml.framework.utils.exception.VoidRepositoryException;
import fr.lip6.move.pnml.symmetricnet.booleans.impl.BooleansFactoryImpl;
import fr.lip6.move.pnml.symmetricnet.cyclicEnumerations.impl.CyclicEnumerationsFactoryImpl;
import fr.lip6.move.pnml.symmetricnet.dots.impl.DotsFactoryImpl;
import fr.lip6.move.pnml.symmetricnet.finiteIntRanges.impl.FiniteIntRangesFactoryImpl;
import fr.lip6.move.pnml.symmetricnet.integers.impl.IntegersFactoryImpl;
import fr.lip6.move.pnml.symmetricnet.multisets.impl.MultisetsFactoryImpl;
import fr.lip6.move.pnml.symmetricnet.partitions.impl.PartitionsFactoryImpl;
import fr.lip6.move.pnml.symmetricnet.terms.NamedOperator;
import fr.lip6.move.pnml.symmetricnet.terms.Term;
import fr.lip6.move.pnml.symmetricnet.terms.TermsPackage;
import fr.lip6.move.pnml.symmetricnet.terms.VariableDecl;
import fr.lip6.move.pnml.symmetricnet.terms.impl.OperatorDeclImpl;
import fr.lip6.move.pnml.symmetricnet.terms.impl.TermsFactoryImpl;
import fr.lip6.move.pnml.symmetricnet.terms.util.TermsValidator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.InternalEList;

public class NamedOperatorImpl
extends OperatorDeclImpl
implements NamedOperator {
    protected Term def;
    protected EList<VariableDecl> parameters;

    protected NamedOperatorImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return TermsPackage.Literals.NAMED_OPERATOR;
    }

    @Override
    public Term getDef() {
        return this.def;
    }

    public NotificationChain basicSetDef(Term newDef, NotificationChain msgs) {
        Term oldDef = this.def;
        this.def = newDef;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldDef, (Object)newDef);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setDef(Term newDef) {
        if (newDef != this.def) {
            NotificationChain msgs = null;
            if (this.def != null) {
                msgs = ((InternalEObject)this.def).eInverseRemove((InternalEObject)this, 2, Term.class, msgs);
            }
            if (newDef != null) {
                msgs = ((InternalEObject)newDef).eInverseAdd((InternalEObject)this, 2, Term.class, msgs);
            }
            if ((msgs = this.basicSetDef(newDef, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)newDef, (Object)newDef));
        }
    }

    @Override
    public List<VariableDecl> getParameters() {
        if (this.parameters == null) {
            this.parameters = new EObjectContainmentWithInverseEList(VariableDecl.class, (InternalEObject)this, 4, 4);
        }
        return this.parameters;
    }

    @Override
    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 3: {
                if (this.def != null) {
                    msgs = ((InternalEObject)this.def).eInverseRemove((InternalEObject)this, -4, null, msgs);
                }
                return this.basicSetDef((Term)otherEnd, msgs);
            }
            case 4: {
                return ((InternalEList)this.getParameters()).basicAdd((Object)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 3: {
                return this.basicSetDef(null, msgs);
            }
            case 4: {
                return ((InternalEList)this.getParameters()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 3: {
                return this.getDef();
            }
            case 4: {
                return this.getParameters();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 3: {
                this.setDef((Term)newValue);
                return;
            }
            case 4: {
                this.getParameters().clear();
                this.getParameters().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 3: {
                this.setDef(null);
                return;
            }
            case 4: {
                this.getParameters().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 3: {
                return this.def != null;
            }
            case 4: {
                return this.parameters != null && !this.parameters.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toPNML() {
        String top;
        Boolean prettyPrintStatus = ModelRepository.getInstance().isPrettyPrintActive();
        String retline = "";
        String headline = "";
        PrettyPrintData prpd = null;
        if (prettyPrintStatus.booleanValue()) {
            retline = "\n";
            prpd = ModelRepository.getInstance().getPrettyPrintData();
            headline = prpd.getCurrentLineHeader();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(headline);
        sb.append("<namedoperator");
        if (prettyPrintStatus.booleanValue()) {
            headline = prpd.increaseLineHeaderLevel();
        }
        if (this.getId() != null) {
            sb.append(" id");
            sb.append("=\"");
            sb.append(this.getId());
            sb.append("\"");
        }
        if (this.getName() != null) {
            sb.append(" name");
            sb.append("=\"");
            sb.append(this.getName());
            sb.append("\"");
        }
        boolean haveSons = false;
        sb.append(">");
        sb.append(retline);
        if (this.getDef() != null && !(top = this.getDef().toPNML()).equals("")) {
            sb.append(headline);
            sb.append("<");
            sb.append("def");
            sb.append(">");
            sb.append(top);
            sb.append("</");
            sb.append("def");
            sb.append(">");
            sb.append(retline);
            haveSons = true;
        }
        if (this.getParameters() != null) {
            List<VariableDecl> items = this.getParameters();
            for (VariableDecl item : items) {
                sb.append(headline);
                sb.append("<");
                sb.append("parameter");
                sb.append(">");
                sb.append(item.toPNML());
                sb.append(headline);
                sb.append("</");
                sb.append("parameter");
                sb.append(">");
                haveSons = true;
            }
        }
        if (prettyPrintStatus.booleanValue()) {
            headline = prpd.decreaseLineHeaderLevel();
        }
        if (haveSons) {
            sb.append(headline);
            sb.append("</namedoperator>");
            sb.append(retline);
        } else {
            sb.delete(sb.lastIndexOf(">"), sb.length());
            sb.append("/>");
        }
        return sb.toString();
    }

    @Override
    public void fromPNML(OMElement locRoot, IdRefLinker idr) throws InnerBuildException, InvalidIDException, VoidRepositoryException {
        if (locRoot.getAttributeValue(new QName("id")) != null) {
            this.setId(new String(locRoot.getAttributeValue(new QName("id"))));
            ModelRepository.getInstance().getCurrentIdRepository().checkId(new String(locRoot.getAttributeValue(new QName("id"))).toString(), (Object)this);
        }
        if (locRoot.getAttributeValue(new QName("name")) != null) {
            try {
                this.setName(new String(locRoot.getAttributeValue(new QName("name"))));
            }
            catch (Exception e) {
                throw new InnerBuildException((Throwable)e);
            }
        }
        Iterator iterator = locRoot.getChildElements();
        while (iterator.hasNext()) {
            OMElement subType;
            Iterator iterator2;
            Object item;
            OMElement type = (OMElement)iterator.next();
            if (type.getLocalName().equals("def")) {
                item = null;
                iterator2 = type.getChildElements();
                while (iterator2.hasNext()) {
                    subType = (OMElement)iterator2.next();
                    if (subType.getLocalName().equals("variable")) {
                        item = new TermsFactoryImpl().createVariable();
                        item.fromPNML(subType, idr);
                        item.setContainerNamedOperator(this);
                        continue;
                    }
                    if (subType.getLocalName().equals("tuple")) {
                        item = new TermsFactoryImpl().createTuple();
                        item.fromPNML(subType, idr);
                        item.setContainerNamedOperator(this);
                        continue;
                    }
                    if (subType.getLocalName().equals("useroperator")) {
                        item = new TermsFactoryImpl().createUserOperator();
                        item.fromPNML(subType, idr);
                        item.setContainerNamedOperator(this);
                        continue;
                    }
                    if (subType.getLocalName().equals("equality")) {
                        item = new BooleansFactoryImpl().createEquality();
                        item.fromPNML(subType, idr);
                        item.setContainerNamedOperator(this);
                        continue;
                    }
                    if (subType.getLocalName().equals("inequality")) {
                        item = new BooleansFactoryImpl().createInequality();
                        item.fromPNML(subType, idr);
                        item.setContainerNamedOperator(this);
                        continue;
                    }
                    if (subType.getLocalName().equals("booleanconstantt")) {
                        item = new BooleansFactoryImpl().createBooleanConstant();
                        item.fromPNML(subType, idr);
                        item.setContainerNamedOperator(this);
                        continue;
                    }
                    if (subType.getLocalName().equals("or")) {
                        item = new BooleansFactoryImpl().createOr();
                        item.fromPNML(subType, idr);
                        item.setContainerNamedOperator(this);
                        continue;
                    }
                    if (subType.getLocalName().equals("and")) {
                        item = new BooleansFactoryImpl().createAnd();
                        item.fromPNML(subType, idr);
                        item.setContainerNamedOperator(this);
                        continue;
                    }
                    if (subType.getLocalName().equals("imply")) {
                        item = new BooleansFactoryImpl().createImply();
                        item.fromPNML(subType, idr);
                        item.setContainerNamedOperator(this);
                        continue;
                    }
                    if (subType.getLocalName().equals("not")) {
                        item = new BooleansFactoryImpl().createNot();
                        item.fromPNML(subType, idr);
                        item.setContainerNamedOperator(this);
                        continue;
                    }
                    if (subType.getLocalName().equals("successor")) {
                        item = new CyclicEnumerationsFactoryImpl().createSuccessor();
                        item.fromPNML(subType, idr);
                        item.setContainerNamedOperator(this);
                        continue;
                    }
                    if (subType.getLocalName().equals("predecessor")) {
                        item = new CyclicEnumerationsFactoryImpl().createPredecessor();
                        item.fromPNML(subType, idr);
                        item.setContainerNamedOperator(this);
                        continue;
                    }
                    if (subType.getLocalName().equals("dotconstant")) {
                        item = new DotsFactoryImpl().createDotConstant();
                        item.fromPNML(subType, idr);
                        item.setContainerNamedOperator(this);
                        continue;
                    }
                    if (subType.getLocalName().equals("finiteintrangeconstant")) {
                        item = new FiniteIntRangesFactoryImpl().createFiniteIntRangeConstant();
                        item.fromPNML(subType, idr);
                        item.setContainerNamedOperator(this);
                        continue;
                    }
                    if (subType.getLocalName().equals("lessthan")) {
                        item = new FiniteIntRangesFactoryImpl().createLessThan();
                        item.fromPNML(subType, idr);
                        item.setContainerNamedOperator(this);
                        continue;
                    }
                    if (subType.getLocalName().equals("greaterthan")) {
                        item = new FiniteIntRangesFactoryImpl().createGreaterThan();
                        item.fromPNML(subType, idr);
                        item.setContainerNamedOperator(this);
                        continue;
                    }
                    if (subType.getLocalName().equals("lessthanorequal")) {
                        item = new FiniteIntRangesFactoryImpl().createLessThanOrEqual();
                        item.fromPNML(subType, idr);
                        item.setContainerNamedOperator(this);
                        continue;
                    }
                    if (subType.getLocalName().equals("greaterthanorequal")) {
                        item = new FiniteIntRangesFactoryImpl().createGreaterThanOrEqual();
                        item.fromPNML(subType, idr);
                        item.setContainerNamedOperator(this);
                        continue;
                    }
                    if (subType.getLocalName().equals("numberconstant")) {
                        item = new IntegersFactoryImpl().createNumberConstant();
                        item.fromPNML(subType, idr);
                        item.setContainerNamedOperator(this);
                        continue;
                    }
                    if (subType.getLocalName().equals("addition")) {
                        item = new IntegersFactoryImpl().createAddition();
                        item.fromPNML(subType, idr);
                        item.setContainerNamedOperator(this);
                        continue;
                    }
                    if (subType.getLocalName().equals("subtraction")) {
                        item = new IntegersFactoryImpl().createSubtraction();
                        item.fromPNML(subType, idr);
                        item.setContainerNamedOperator(this);
                        continue;
                    }
                    if (subType.getLocalName().equals("mult")) {
                        item = new IntegersFactoryImpl().createMultiplication();
                        item.fromPNML(subType, idr);
                        item.setContainerNamedOperator(this);
                        continue;
                    }
                    if (subType.getLocalName().equals("div")) {
                        item = new IntegersFactoryImpl().createDivision();
                        item.fromPNML(subType, idr);
                        item.setContainerNamedOperator(this);
                        continue;
                    }
                    if (subType.getLocalName().equals("mod")) {
                        item = new IntegersFactoryImpl().createModulo();
                        item.fromPNML(subType, idr);
                        item.setContainerNamedOperator(this);
                        continue;
                    }
                    if (subType.getLocalName().equals("gt")) {
                        item = new IntegersFactoryImpl().createGreaterThan();
                        item.fromPNML(subType, idr);
                        item.setContainerNamedOperator(this);
                        continue;
                    }
                    if (subType.getLocalName().equals("geq")) {
                        item = new IntegersFactoryImpl().createGreaterThanOrEqual();
                        item.fromPNML(subType, idr);
                        item.setContainerNamedOperator(this);
                        continue;
                    }
                    if (subType.getLocalName().equals("lt")) {
                        item = new IntegersFactoryImpl().createLessThan();
                        item.fromPNML(subType, idr);
                        item.setContainerNamedOperator(this);
                        continue;
                    }
                    if (subType.getLocalName().equals("leq")) {
                        item = new IntegersFactoryImpl().createLessThanOrEqual();
                        item.fromPNML(subType, idr);
                        item.setContainerNamedOperator(this);
                        continue;
                    }
                    if (subType.getLocalName().equals("cardinality")) {
                        item = new MultisetsFactoryImpl().createCardinality();
                        item.fromPNML(subType, idr);
                        item.setContainerNamedOperator(this);
                        continue;
                    }
                    if (subType.getLocalName().equals("contains")) {
                        item = new MultisetsFactoryImpl().createContains();
                        item.fromPNML(subType, idr);
                        item.setContainerNamedOperator(this);
                        continue;
                    }
                    if (subType.getLocalName().equals("cardinalityof")) {
                        item = new MultisetsFactoryImpl().createCardinalityOf();
                        item.fromPNML(subType, idr);
                        item.setContainerNamedOperator(this);
                        continue;
                    }
                    if (subType.getLocalName().equals("add")) {
                        item = new MultisetsFactoryImpl().createAdd();
                        item.fromPNML(subType, idr);
                        item.setContainerNamedOperator(this);
                        continue;
                    }
                    if (subType.getLocalName().equals("all")) {
                        item = new MultisetsFactoryImpl().createAll();
                        item.fromPNML(subType, idr);
                        item.setContainerNamedOperator(this);
                        continue;
                    }
                    if (subType.getLocalName().equals("empty")) {
                        item = new MultisetsFactoryImpl().createEmpty();
                        item.fromPNML(subType, idr);
                        item.setContainerNamedOperator(this);
                        continue;
                    }
                    if (subType.getLocalName().equals("numberof")) {
                        item = new MultisetsFactoryImpl().createNumberOf();
                        item.fromPNML(subType, idr);
                        item.setContainerNamedOperator(this);
                        continue;
                    }
                    if (subType.getLocalName().equals("subtract")) {
                        item = new MultisetsFactoryImpl().createSubtract();
                        item.fromPNML(subType, idr);
                        item.setContainerNamedOperator(this);
                        continue;
                    }
                    if (subType.getLocalName().equals("scalarproduct")) {
                        item = new MultisetsFactoryImpl().createScalarProduct();
                        item.fromPNML(subType, idr);
                        item.setContainerNamedOperator(this);
                        continue;
                    }
                    if (subType.getLocalName().equals("gtp")) {
                        item = new PartitionsFactoryImpl().createGreaterThan();
                        item.fromPNML(subType, idr);
                        item.setContainerNamedOperator(this);
                        continue;
                    }
                    if (subType.getLocalName().equals("partitionelementof")) {
                        item = new PartitionsFactoryImpl().createPartitionElementOf();
                        item.fromPNML(subType, idr);
                        item.setContainerNamedOperator(this);
                        continue;
                    }
                    if (!subType.getLocalName().equals("ltp")) continue;
                    item = new PartitionsFactoryImpl().createLessThan();
                    item.fromPNML(subType, idr);
                    item.setContainerNamedOperator(this);
                }
            }
            if (!type.getLocalName().equals("parameter")) continue;
            item = null;
            iterator2 = type.getChildElements();
            while (iterator2.hasNext()) {
                subType = (OMElement)iterator2.next();
                if (!subType.getLocalName().equals("variabledecl")) continue;
                item = new TermsFactoryImpl().createVariableDecl();
                item.fromPNML(subType, idr);
                item.setContainerNamedOperator(this);
            }
        }
    }

    @Override
    public void toPNML(FileChannel fc) {
        String top;
        ByteBuffer bytebuf = ByteBuffer.allocateDirect(8192);
        String charsetEncoding = PNMLEncoding.ISO_8859_1.getName();
        Boolean prettyPrintStatus = ModelRepository.getInstance().isPrettyPrintActive();
        String retline = "";
        String headline = "";
        PrettyPrintData prpd = null;
        if (prettyPrintStatus.booleanValue()) {
            retline = "\n";
            prpd = ModelRepository.getInstance().getPrettyPrintData();
            headline = prpd.getCurrentLineHeader();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(headline);
        sb.append("<namedoperator");
        if (prettyPrintStatus.booleanValue()) {
            headline = prpd.increaseLineHeaderLevel();
        }
        if (this.getId() != null) {
            sb.append(" id");
            sb.append("=\"");
            sb.append(this.getId());
            sb.append("\"");
        }
        if (this.getName() != null) {
            sb.append(" name");
            sb.append("=\"");
            sb.append(this.getName());
            sb.append("\"");
        }
        sb.append(">");
        sb.append(retline);
        if (this.getDef() != null && !(top = this.getDef().toPNML()).equals("")) {
            sb.append(headline);
            sb.append("<");
            sb.append("def");
            sb.append(">");
            sb.append(top);
            sb.append("</");
            sb.append("def");
            sb.append(">");
            sb.append(retline);
        }
        if (this.getParameters() != null) {
            try {
                NamedOperatorImpl.writeIntoStream(bytebuf, fc, sb.toString().getBytes(Charset.forName(charsetEncoding)));
            }
            catch (IOException io) {
                io.printStackTrace();
                return;
            }
            sb.delete(0, sb.length());
            List<VariableDecl> items = this.getParameters();
            for (VariableDecl item : items) {
                sb.append(headline);
                sb.append("<");
                sb.append("parameter");
                sb.append(">");
                try {
                    NamedOperatorImpl.writeIntoStream(bytebuf, fc, sb.toString().getBytes(Charset.forName(charsetEncoding)));
                }
                catch (IOException io) {
                    io.printStackTrace();
                    return;
                }
                sb.delete(0, sb.length());
                item.toPNML(fc);
                sb.append(headline);
                sb.append("</");
                sb.append("parameter");
                sb.append(">");
            }
        }
        if (prettyPrintStatus.booleanValue()) {
            headline = prpd.decreaseLineHeaderLevel();
        }
        sb.append(headline);
        sb.append("</namedoperator>");
        sb.append(retline);
        try {
            NamedOperatorImpl.writeIntoStream(bytebuf, fc, sb.toString().getBytes(Charset.forName(charsetEncoding)));
        }
        catch (IOException io) {
            io.printStackTrace();
            return;
        }
        sb = null;
    }

    private static final void writeIntoStream(ByteBuffer bytebuf, FileChannel fc, byte[] contents) throws IOException {
        if (contents.length >= bytebuf.capacity()) {
            List chops = PnmlExport.chopBytes((byte[])contents, (int)6144);
            for (byte[] buf : chops) {
                bytebuf.put(buf);
                bytebuf.flip();
                fc.write(bytebuf);
                bytebuf.clear();
            }
        } else {
            bytebuf.put(contents);
            bytebuf.flip();
            fc.write(bytebuf);
            bytebuf.clear();
        }
    }

    @Override
    public boolean validateOCL(DiagnosticChain diagnostics) {
        TermsValidator val = new TermsValidator();
        boolean retour = true;
        if (this.getDef() != null) {
            retour &= this.getDef().validateOCL(diagnostics);
        }
        if (this.getParameters() != null) {
            List<VariableDecl> items = this.getParameters();
            for (VariableDecl item : items) {
                retour &= item.validateOCL(diagnostics);
            }
        }
        return retour &= val.validate(this, diagnostics, null);
    }
}

