/*
 * Decompiled with CFR 0.152.
 */
package fr.maif.json;

import io.vavr.API;
import io.vavr.Tuple;
import io.vavr.collection.List;
import io.vavr.collection.Seq;
import io.vavr.control.Either;
import io.vavr.control.Option;
import java.util.Arrays;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.function.Supplier;

public interface JsResult<T> {
    public static <R, _1 extends R> API.Match.Pattern1<JsSuccess<R>, _1> $JsSuccess(API.Match.Pattern<_1, ?> pattern) {
        return API.Match.Pattern1.of(JsSuccess.class, pattern, jsSuccess -> Tuple.of((Object)((JsSuccess)jsSuccess).value));
    }

    public static <R> API.Match.Pattern1<JsError<R>, Seq<Error>> $JsError(API.Match.Pattern<Seq<Error>, ?> pattern) {
        return API.Match.Pattern1.of(JsError.class, pattern, jsError -> Tuple.of((Object)((JsError)jsError).errors));
    }

    public static <T> JsResult<T> success(T t) {
        return new JsSuccess<T>(t);
    }

    public static <T> JsResult<T> error(Seq<Error> seq) {
        return new JsError(seq);
    }

    public static <T> JsResult<T> error(Error ... errorArray) {
        return new JsError((Seq<Error>)List.of((Object[])errorArray));
    }

    public Boolean isError();

    default public Boolean isSuccess() {
        return this.isError() == false;
    }

    public <A> JsResult<A> map(Function<T, A> var1);

    public JsResult<T> mapError(Function<Seq<Error>, Seq<Error>> var1);

    public <A> JsResult<A> flatMap(Function<T, JsResult<A>> var1);

    public Seq<Error> getErrors();

    public Either<Seq<Error>, T> toEither();

    default public <R> R fold(Function<Seq<Error>, R> function, Function<T, R> function2) {
        return (R)this.toEither().fold(function, function2);
    }

    public T get();

    default public T getOrElse(Supplier<T> supplier) {
        return (T)this.fold(seq -> supplier.get(), Function.identity());
    }

    default public JsResult<Seq<T>> combineMany(JsResult<Seq<T>> jsResult) {
        if (this.isSuccess().booleanValue() && jsResult.isSuccess().booleanValue()) {
            JsSuccess jsSuccess = (JsSuccess)this;
            JsSuccess jsSuccess2 = (JsSuccess)jsResult;
            return new JsSuccess<Seq<T>>(((Seq)jsSuccess2.value).append(jsSuccess.value));
        }
        if (this.isError().booleanValue() && jsResult.isError().booleanValue()) {
            JsError jsError = (JsError)this;
            JsError jsError2 = (JsError)jsResult;
            return new JsError<Seq<T>>((Seq<Error>)jsError.errors.appendAll((Iterable)jsError2.errors));
        }
        if (this.isError().booleanValue() && jsResult.isSuccess().booleanValue()) {
            JsError jsError = (JsError)this;
            return new JsError<Seq<T>>((Seq<Error>)jsError.errors);
        }
        JsError jsError = (JsError)jsResult;
        return new JsError<Seq<T>>((Seq<Error>)jsError.errors);
    }

    public static class Error {
        public final Option<String> path;
        public final String[] args;
        public final String message;

        public Error(Option<String> option, String string, String[] stringArray) {
            this.path = option;
            this.args = stringArray;
            this.message = string;
        }

        public static Error error(String string, String string2, Object ... objectArray) {
            return new Error((Option<String>)Option.of((Object)string), string2, (String[])List.of((Object[])objectArray).map(Object::toString).toJavaArray(String[]::new));
        }

        public static Error error(String string, Object ... objectArray) {
            return new Error((Option<String>)Option.none(), string, (String[])List.of((Object[])objectArray).map(Object::toString).toJavaArray(String[]::new));
        }

        public Error repath(String string) {
            return new Error((Option<String>)this.path.map(string2 -> string + "." + string2).orElse(Option.of((Object)string)), this.message, this.args);
        }

        public String toString() {
            return new StringJoiner(", ", Error.class.getSimpleName() + "[", "]").add("path=" + this.path).add("args=" + Arrays.toString(this.args)).add("message='" + this.message + "'").toString();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Error error = (Error)object;
            return Objects.equals(this.path, error.path) && Arrays.equals(this.args, error.args) && Objects.equals(this.message, error.message);
        }

        public int hashCode() {
            int n = Objects.hash(this.path, this.message);
            n = 31 * n + Arrays.hashCode(this.args);
            return n;
        }
    }

    public static class JsError<T>
    implements JsResult<T> {
        private final Seq<Error> errors;

        public JsError(Seq<Error> seq) {
            this.errors = seq;
        }

        @Override
        public Boolean isError() {
            return true;
        }

        @Override
        public <A> JsResult<A> map(Function<T, A> function) {
            return new JsError<T>(this.errors);
        }

        @Override
        public <A> JsResult<A> flatMap(Function<T, JsResult<A>> function) {
            return new JsError<T>(this.errors);
        }

        @Override
        public JsResult<T> mapError(Function<Seq<Error>, Seq<Error>> function) {
            return new JsError<T>(function.apply(this.errors));
        }

        @Override
        public Either<Seq<Error>, T> toEither() {
            return Either.left(this.errors);
        }

        @Override
        public Seq<Error> getErrors() {
            return this.errors;
        }

        @Override
        public T get() {
            throw new IllegalStateException("JsError, no value present: " + this.errors);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            JsError jsError = (JsError)object;
            return Objects.equals(this.errors, jsError.errors);
        }

        public int hashCode() {
            return Objects.hash(this.errors);
        }

        public String toString() {
            return new StringJoiner(", ", JsError.class.getSimpleName() + "[", "]").add("errors=" + this.errors).toString();
        }
    }

    public static class JsSuccess<T>
    implements JsResult<T> {
        private final T value;

        public JsSuccess(T t) {
            this.value = t;
        }

        @Override
        public Boolean isError() {
            return false;
        }

        @Override
        public <A> JsResult<A> map(Function<T, A> function) {
            return new JsSuccess<A>(function.apply(this.value));
        }

        @Override
        public <A> JsResult<A> flatMap(Function<T, JsResult<A>> function) {
            return function.apply(this.value);
        }

        @Override
        public JsResult<T> mapError(Function<Seq<Error>, Seq<Error>> function) {
            return this;
        }

        @Override
        public Either<Seq<Error>, T> toEither() {
            return Either.right(this.value);
        }

        @Override
        public Seq<Error> getErrors() {
            return List.empty();
        }

        @Override
        public T get() {
            return this.value;
        }

        public String toString() {
            return new StringJoiner(", ", JsSuccess.class.getSimpleName() + "[", "]").add("value=" + this.value).toString();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            JsSuccess jsSuccess = (JsSuccess)object;
            return Objects.equals(this.value, jsSuccess.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }
    }
}

