/*
 * Decompiled with CFR 0.152.
 */
package fr.maif.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.FormatFeature;
import com.fasterxml.jackson.core.json.JsonWriteFeature;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import fr.maif.json.JsResult;
import fr.maif.json.JsonRead;
import fr.maif.json.JsonWrite;
import io.vavr.collection.List;
import io.vavr.collection.Traversable;
import io.vavr.control.Option;
import io.vavr.jackson.datatype.VavrModule;
import java.io.IOException;
import java.util.Objects;
import java.util.StringJoiner;

public class Json {
    private static ObjectMapper defaultObjectMapper = Json.newDefaultMapper();

    public static ObjectMapper newDefaultMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new VavrModule());
        objectMapper.registerModule((Module)new Jdk8Module());
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_ABSENT);
        return objectMapper;
    }

    public static void setMapper(ObjectMapper objectMapper) {
        defaultObjectMapper = objectMapper;
    }

    public static ObjectMapper mapper() {
        return defaultObjectMapper;
    }

    private static String generateJson(Object object, boolean bl, boolean bl2) {
        try {
            ObjectWriter objectWriter = Json.mapper().writer();
            if (bl) {
                objectWriter = objectWriter.with(SerializationFeature.INDENT_OUTPUT);
            }
            if (bl2) {
                objectWriter = objectWriter.with((FormatFeature)JsonWriteFeature.ESCAPE_NON_ASCII);
            }
            return objectWriter.writeValueAsString(object);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static <T> JsonNode toJson(T t, JsonWrite<T> jsonWrite) {
        return jsonWrite.write(t);
    }

    public static <A> JsResult<A> fromJson(JsonNode jsonNode, JsonRead<A> jsonRead) {
        return jsonRead.read(jsonNode);
    }

    public static <A> JsResult<A> fromJson(JsonNode jsonNode, Class<A> clazz) {
        return Json.fromJson(jsonNode, JsonRead._fromClass(clazz));
    }

    public static <A> JsResult<A> fromJson(JsonNode jsonNode, TypeReference<A> typeReference) {
        return Json.fromJson(jsonNode, JsonRead._fromClass(typeReference));
    }

    public static ObjectNode newObject() {
        return Json.mapper().createObjectNode();
    }

    public static ArrayNode newArray() {
        return Json.mapper().createArrayNode();
    }

    public static String stringify(JsonNode jsonNode) {
        return Json.generateJson(jsonNode, false, false);
    }

    public static String prettyPrint(JsonNode jsonNode) {
        return Json.generateJson(jsonNode, true, false);
    }

    public static JsonNode parse(String string) {
        try {
            return Json.mapper().readTree(string);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static ObjectNode obj(JsPair ... jsPairArray) {
        return Json.obj(Json.newObject(), jsPairArray);
    }

    public static ObjectNode obj(ObjectNode objectNode, JsPair ... jsPairArray) {
        List.of((Object[])jsPairArray).filter(jsPair -> jsPair.value.isDefined()).forEach(jsPair -> objectNode.set(jsPair.field, (JsonNode)jsPair.value.get()));
        return objectNode;
    }

    public static ObjectNode merge(ObjectNode objectNode, ObjectNode objectNode2) {
        objectNode.fields().forEachRemaining(entry -> objectNode2.set((String)entry.getKey(), (JsonNode)entry.getValue()));
        return objectNode2;
    }

    public static ArrayNode arr(JsonNode ... jsonNodeArray) {
        return Json.arr((Traversable<JsonNode>)List.of((Object[])jsonNodeArray));
    }

    public static ArrayNode arr(Traversable<JsonNode> traversable) {
        ArrayNode arrayNode = Json.newArray();
        traversable.forEach(arg_0 -> ((ArrayNode)arrayNode).add(arg_0));
        return arrayNode;
    }

    public static ArrayNode arr(String ... stringArray) {
        ArrayNode arrayNode = Json.newArray();
        List.of((Object[])stringArray).map(TextNode::new).forEach(arg_0 -> ((ArrayNode)arrayNode).add(arg_0));
        return arrayNode;
    }

    public static JsPair $(String string, Integer n) {
        return new JsPair(string, (Option<JsonNode>)Option.of((Object)n).map(IntNode::new));
    }

    public static JsPair $$(String string, Integer n) {
        return Json.$(string, n);
    }

    public static JsPair $(String string, Long l) {
        return new JsPair(string, (Option<JsonNode>)Option.of((Object)l).map(LongNode::new));
    }

    public static JsPair $$(String string, Long l) {
        return Json.$(string, l);
    }

    public static JsPair $(String string, Option<String> option) {
        return new JsPair(string, (Option<JsonNode>)option.map(TextNode::new));
    }

    public static JsPair $$(String string, Option<String> option) {
        return Json.$(string, option);
    }

    public static JsPair $(String string, Enum<?> enum_) {
        return Json.$(string, (Option<String>)Option.of(enum_).map(Enum::name));
    }

    public static JsPair $$(String string, Enum<?> enum_) {
        return Json.$(string, enum_);
    }

    public static JsPair $(String string, String string2) {
        return Json.$(string, (Option<String>)Option.of((Object)string2));
    }

    public static JsPair $$(String string, String string2) {
        return Json.$(string, string2);
    }

    public static JsPair $(String string, Boolean bl) {
        return new JsPair(string, (Option<JsonNode>)Option.of((Object)bl).map(BooleanNode::valueOf));
    }

    public static JsPair $$(String string, Boolean bl) {
        return Json.$(string, bl);
    }

    public static JsPair $(String string, JsonNode jsonNode) {
        return new JsPair(string, (Option<JsonNode>)Option.of((Object)jsonNode));
    }

    public static JsPair $$(String string, JsonNode jsonNode) {
        return Json.$(string, jsonNode);
    }

    public static <T> JsPair $(String string, T t, JsonWrite<T> jsonWrite) {
        return new JsPair(string, (Option<JsonNode>)Option.of(t).map(jsonWrite::write));
    }

    public static <T> JsPair $$(String string, T t, JsonWrite<T> jsonWrite) {
        return Json.$(string, t, jsonWrite);
    }

    public static <T> JsPair $(String string, Option<T> option, JsonWrite<T> jsonWrite) {
        return new JsPair(string, (Option<JsonNode>)(Objects.isNull(option) ? Option.none() : option.map(jsonWrite::write)));
    }

    public static <T> JsPair $$(String string, Option<T> option, JsonWrite<T> jsonWrite) {
        return Json.$(string, option, jsonWrite);
    }

    public static <T> JsPair $(String string, Traversable<T> traversable2, JsonWrite<T> jsonWrite) {
        return new JsPair(string, (Option<JsonNode>)Option.of(traversable2).map(traversable -> Json.arr((JsonNode[])traversable.map(jsonWrite::write).toJavaArray(JsonNode[]::new))));
    }

    public static <T> JsPair $$(String string, Traversable<T> traversable, JsonWrite<T> jsonWrite) {
        return Json.$(string, traversable, jsonWrite);
    }

    public static class JsPair {
        final String field;
        final Option<JsonNode> value;

        public JsPair(String string, Option<JsonNode> option) {
            this.field = string;
            this.value = option;
        }

        public String toString() {
            return new StringJoiner(", ", JsPair.class.getSimpleName() + "[", "]").add("field='" + this.field + "'").add("value=" + this.value).toString();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            JsPair jsPair = (JsPair)object;
            return Objects.equals(this.field, jsPair.field) && Objects.equals(this.value, jsPair.value);
        }

        public int hashCode() {
            return Objects.hash(this.field, this.value);
        }
    }
}

