/*
 * Decompiled with CFR 0.152.
 */
package fr.maif.json;

import com.fasterxml.jackson.databind.JsonNode;
import fr.maif.json.JsResult;
import fr.maif.json.JsonRead;
import fr.maif.json.JsonSchema;
import fr.maif.json.JsonWrite;

public interface JsonFormat<T>
extends JsonRead<T>,
JsonWrite<T> {
    public JsonRead<T> jsonRead();

    public JsonWrite<T> jsonWrite();

    public static <T> JsonFormat<T> of(final JsonRead<T> jsonRead, final JsonWrite<T> jsonWrite) {
        return new JsonFormat<T>(){

            @Override
            public JsonRead<T> jsonRead() {
                return jsonRead;
            }

            @Override
            public JsonWrite<T> jsonWrite() {
                return jsonWrite;
            }

            @Override
            public JsResult<T> read(JsonNode jsonNode) {
                return jsonRead.read(jsonNode);
            }

            @Override
            public JsonSchema jsonSchema() {
                return jsonRead.jsonSchema();
            }

            @Override
            public JsonNode write(T t) {
                return jsonWrite.write(t);
            }
        };
    }
}

