/*
 * Decompiled with CFR 0.152.
 */
package fr.maif.json;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.maif.json.JsResult;
import fr.maif.json.Json;
import fr.maif.json.JsonSchema;
import io.vavr.API;
import io.vavr.CheckedFunction0;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.Value;
import io.vavr.collection.HashSet;
import io.vavr.collection.List;
import io.vavr.collection.Seq;
import io.vavr.collection.Set;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;

@FunctionalInterface
public interface JsonRead<T> {
    public JsResult<T> read(JsonNode var1);

    default public JsonSchema jsonSchema() {
        return JsonSchema.emptySchema();
    }

    public static <T> JsonRead<T> of(final Function<JsonNode, JsResult<T>> function, final JsonSchema jsonSchema) {
        return new JsonRead<T>(){

            @Override
            public JsResult<T> read(JsonNode jsonNode) {
                return (JsResult)function.apply(jsonNode);
            }

            @Override
            public JsonSchema jsonSchema() {
                return jsonSchema;
            }
        };
    }

    public static <T> JsonRead<T> ofRead(final JsonRead<T> jsonRead, final JsonSchema jsonSchema) {
        return new JsonRead<T>(){

            @Override
            public JsResult<T> read(JsonNode jsonNode) {
                return jsonRead.read(jsonNode);
            }

            @Override
            public JsonSchema jsonSchema() {
                return jsonSchema;
            }
        };
    }

    default public <T2, R> JsonRead<R> and(JsonRead<T2> jsonRead, BiFunction<T, T2, R> biFunction) {
        return JsonRead.of(jsonNode -> {
            JsResult<T> jsResult = this.read((JsonNode)jsonNode);
            JsResult<T> jsResult2 = jsonRead.read((JsonNode)jsonNode);
            if (jsResult.isSuccess().booleanValue() && jsResult2.isSuccess().booleanValue()) {
                return JsResult.success(biFunction.apply(jsResult.get(), jsResult2.get()));
            }
            if (jsResult.isError().booleanValue() && jsResult2.isError().booleanValue()) {
                return JsResult.error((Seq<JsResult.Error>)jsResult.getErrors().appendAll(jsResult2.getErrors()));
            }
            if (jsResult.isError().booleanValue() && jsResult2.isSuccess().booleanValue()) {
                return JsResult.error(jsResult.getErrors());
            }
            return JsResult.error(jsResult2.getErrors());
        }, this.jsonSchema().and(jsonRead.jsonSchema()));
    }

    default public JsonRead<T> orElse(JsonRead<T> jsonRead) {
        return JsonRead.ofRead(jsonNode -> {
            JsResult<T> jsResult = this.read(jsonNode);
            if (jsResult.isError().booleanValue()) {
                return jsonRead.read(jsonNode);
            }
            return jsResult;
        }, JsonSchema.oneOf(this.jsonSchema().computeSchema(), jsonRead.jsonSchema().computeSchema()));
    }

    default public JsonRead<T> mapSchema(Function<JsonSchema, JsonSchema> function) {
        return JsonRead.ofRead(this, function.apply(this.jsonSchema()));
    }

    default public JsonRead<T> id(String string) {
        return this.mapSchema(jsonSchema -> jsonSchema.id(string));
    }

    default public JsonRead<T> schema(String string) {
        return this.mapSchema(jsonSchema -> jsonSchema.schema(string));
    }

    default public JsonRead<T> title(String string) {
        return this.mapSchema(jsonSchema -> jsonSchema.title(string));
    }

    default public JsonRead<T> description(String string) {
        return this.mapSchema(jsonSchema -> jsonSchema.description(string));
    }

    default public JsonRead<T> exemples(List<JsonNode> list) {
        return this.mapSchema(jsonSchema -> jsonSchema.exemples(list));
    }

    public static <T> JsonRead<T> _fromClass(Class<? extends T> clazz) {
        return JsonRead.ofRead(jsonNode -> (JsResult)Try.of((CheckedFunction0 & Serializable)() -> Json.mapper().treeToValue((TreeNode)jsonNode, clazz)).fold(throwable -> JsResult.error(JsResult.Error.error(throwable.getMessage(), new Object[0])), JsResult::success), JsonSchema.emptySchema());
    }

    public static <T> JsonRead<T> _fromClass(TypeReference<T> typeReference) {
        return JsonRead.ofRead(jsonNode -> (JsResult)Try.of((CheckedFunction0 & Serializable)() -> Json.mapper().convertValue((Object)jsonNode, typeReference)).fold(throwable -> JsResult.error(JsResult.Error.error(throwable.getMessage(), new Object[0])), JsResult::success), JsonSchema.emptySchema());
    }

    public static JsonRead<ObjectNode> _jsonObject() {
        return JsonRead.of(jsonNode -> {
            if (!Objects.isNull(jsonNode) && jsonNode.isObject()) {
                return JsResult.success((ObjectNode)jsonNode);
            }
            return JsResult.error(JsResult.Error.error("jsonobject.expected", new Object[0]));
        }, JsonSchema.objectSchema());
    }

    public static JsonRead<ArrayNode> _jsonArray() {
        return JsonRead.of(jsonNode -> {
            if (!Objects.isNull(jsonNode) && jsonNode.isArray()) {
                return JsResult.success((ArrayNode)jsonNode);
            }
            return JsResult.error(JsResult.Error.error("jsonarray.expected", new Object[0]));
        }, JsonSchema.arraySchema());
    }

    public static JsonRead<JsonNode> _json() {
        return JsResult::success;
    }

    public static <T> JsonRead<T> __(String string, JsonRead<T> jsonRead) {
        return JsonRead.of(jsonNode -> {
            if (Objects.isNull(jsonNode)) {
                return JsResult.error(JsResult.Error.error(string, "path.not.found", new Object[0]));
            }
            JsonNode jsonNode2 = jsonNode.get(string);
            if (jsonNode.has(string) && !jsonNode2.isNull()) {
                return (JsResult)Try.of((CheckedFunction0 & Serializable)() -> jsonRead.read(jsonNode2)).map(jsResult -> jsResult.mapError(seq -> seq.map(error -> error.repath(string)))).getOrElseGet(throwable -> JsResult.error(JsResult.Error.error(string, "error", new Object[0])));
            }
            return JsResult.error(JsResult.Error.error(string, "path.not.found", new Object[0]));
        }, JsonSchema.propertySchema(string, jsonRead.jsonSchema()));
    }

    public static <T, R> JsonRead<R> __(String string, JsonRead<T> jsonRead, Function<T, R> function) {
        return JsonRead.__(string, jsonRead).map(function);
    }

    public static <T> JsonRead<Option<T>> _opt(String string, JsonRead<? extends T> jsonRead) {
        return JsonRead.of(jsonNode -> {
            if (Objects.isNull(jsonNode) || !jsonNode.has(string) || jsonNode.get(string).isNull()) {
                return JsResult.success(Option.none());
            }
            return jsonRead.read(jsonNode.get(string)).mapError(seq -> seq.map(error -> error.repath(string))).map(Option::of);
        }, string == null ? jsonRead.jsonSchema() : JsonSchema.propertySchema(string, jsonRead.jsonSchema()).notRequired());
    }

    public static <T, R> JsonRead<R> _opt(String string, JsonRead<T> jsonRead, Function<Option<T>, R> function) {
        return JsonRead._opt(string, jsonRead).map(function);
    }

    public static <T, R> JsonRead<R> _nullable(String string, JsonRead<T> jsonRead, Function<T, R> function) {
        return JsonRead.ofRead(JsonRead._opt(string, jsonRead).map(option -> function.apply(option.getOrNull())), JsonSchema.propertySchema(string, jsonRead.jsonSchema()).withRequired(false));
    }

    public static <T> JsonRead<T> _nullable(String string, JsonRead<T> jsonRead) {
        return JsonRead._opt(string, jsonRead).map(Value::getOrNull);
    }

    public static <T> JsonRead<List<T>> _list(JsonRead<? extends T> jsonRead) {
        return JsonRead._list(null, jsonRead);
    }

    public static <T> JsonRead<List<T>> _list(String string, JsonRead<? extends T> jsonRead) {
        return JsonRead.of(jsonNode -> {
            Option option = Option.of((Object)jsonNode);
            return (JsResult)option.map(jsonNode2 -> {
                JsonNode jsonNode3 = (JsonNode)Option.of((Object)string).map(arg_0 -> ((JsonNode)jsonNode2).get(arg_0)).getOrElse(jsonNode2);
                if (jsonNode3 == null || jsonNode3.isNull()) {
                    return JsResult.success(List.empty());
                }
                if (jsonNode3.isArray()) {
                    List list = List.ofAll((Iterable)jsonNode3).filter(jsonNode -> jsonNode != null && !NullNode.getInstance().equals(jsonNode)).zipWithIndex().map(tuple2 -> jsonRead.read((JsonNode)tuple2._1).mapError(seq -> seq.map(error -> error.repath((String)Option.of((Object)string).getOrElse((Object)"") + "[" + tuple2._2 + "]"))));
                    JsResult jsResult3 = (JsResult)list.map(jsResult -> jsResult).foldLeft(JsResult.success(List.empty()), (jsResult, jsResult2) -> jsResult2.combineMany(jsResult));
                    return jsResult3.map(Value::toList);
                }
                return JsResult.error(JsResult.Error.error("array.expected", new Object[0]));
            }).getOrElse(JsResult.success(List.empty()));
        }, string == null ? JsonSchema.arraySchema(jsonRead.jsonSchema()) : JsonSchema.propertySchema(string, JsonSchema.arraySchema(jsonRead.jsonSchema().computeSchema())));
    }

    public static <T, R> JsonRead<R> _list(String string, JsonRead<? extends T> jsonRead, Function<List<T>, R> function) {
        return JsonRead._list(string, jsonRead).map(list -> function.apply((List)list));
    }

    public static <T, R> JsonRead<R> _set(String string, JsonRead<? extends T> jsonRead, Function<Set<T>, R> function) {
        return JsonRead._list(string, jsonRead).map(HashSet::ofAll).map(hashSet -> function.apply((Set)hashSet));
    }

    public static <T> JsonRead<Set<T>> _set(String string, JsonRead<? extends T> jsonRead) {
        return JsonRead._list(string, jsonRead).map(HashSet::ofAll);
    }

    public static <A, T> JsonRead<T> oneOf(JsonRead<A> jsonRead, List<ReadCase<? extends A, ? extends T>> list) {
        return JsonRead.oneOf(jsonRead, (Option<String>)API.None(), list);
    }

    @SafeVarargs
    public static <A, T> JsonRead<T> oneOf(JsonRead<A> jsonRead, ReadCase<? extends A, ? extends T> ... readCaseArray) {
        return JsonRead.oneOf(jsonRead, (Option<String>)API.None(), List.of((Object[])readCaseArray));
    }

    public static <A, T> JsonRead<T> oneOf(JsonRead<A> jsonRead, String string, List<ReadCase<? extends A, ? extends T>> list) {
        return JsonRead.oneOf(jsonRead, (Option<String>)API.Some((Object)string), list);
    }

    @SafeVarargs
    public static <A, T> JsonRead<T> oneOf(JsonRead<A> jsonRead, String string, ReadCase<? extends A, ? extends T> ... readCaseArray) {
        return JsonRead.oneOf(jsonRead, (Option<String>)API.Some((Object)string), List.of((Object[])readCaseArray));
    }

    public static <A, T> JsonRead<T> oneOf(JsonRead<A> jsonRead, Option<String> option, List<ReadCase<? extends A, ? extends T>> list) {
        JsonSchema.OneOfSchema oneOfSchema = JsonSchema.oneOf((List<JsonSchema>)list.map(ReadCase::jsonSchema));
        return JsonRead.ofRead(jsonRead.flatMap(object -> (JsonRead)list.map(readCase -> readCase).flatMap(readCase -> (Option)option.map(string -> readCase.jsonRead(object).map(jsonRead -> JsonRead.__(string, jsonRead))).getOrElse(readCase.jsonRead(object))).headOption().getOrElse(() -> {
            JsonRead jsonRead = jsonNode -> JsResult.error(JsResult.Error.error("Not reader found for value", object));
            return jsonRead;
        })), (JsonSchema)option.map(string -> JsonSchema.propertySchema(string, oneOfSchema)).getOrElse((Object)oneOfSchema));
    }

    public static <A, B, T> JsonRead<T> oneOf(JsonRead<A> jsonRead, JsonRead<B> jsonRead2, List<ReadCase<? extends Tuple2<A, B>, ? extends T>> list) {
        JsonRead<Tuple2> jsonRead3 = jsonRead.and(jsonRead2, Tuple::of);
        return JsonRead.oneOf(jsonRead3, (Option<String>)API.None(), list);
    }

    public static <A, B, T> JsonRead<T> oneOf(JsonRead<A> jsonRead, JsonRead<B> jsonRead2, String string, List<ReadCase<? extends Tuple2<A, B>, ? extends T>> list) {
        JsonRead<Tuple2> jsonRead3 = jsonRead.and(jsonRead2, Tuple::of);
        return JsonRead.oneOf(jsonRead3, (Option<String>)Option.of((Object)string), list);
    }

    public static <A, T> ReadCase<A, T> caseOf(Predicate<A> predicate, JsonRead<T> jsonRead) {
        return new ReadCase1<A, T>(predicate, jsonRead);
    }

    public static <A, T> ReadCase<A, T> caseOf(API.Match.Pattern0<? super A> pattern0, JsonRead<T> jsonRead) {
        return new ReadCase1<Object, T>(arg_0 -> pattern0.isDefinedAt(arg_0), jsonRead);
    }

    public static <A, A1, T> ReadCase<A, T> caseOf(API.Match.Pattern1<A, A1> pattern1, JsonRead<T> jsonRead) {
        return new ReadCase1<Object, T>(arg_0 -> pattern1.isDefinedAt(arg_0), jsonRead);
    }

    public static <A, B, T> ReadCase<Tuple2<A, B>, T> caseOf(BiPredicate<A, B> biPredicate, JsonRead<T> jsonRead) {
        return new ReadCase2<A, B, T>(biPredicate, jsonRead);
    }

    public static <A, A1, A2, B, T> ReadCase<Tuple2<A, B>, T> caseOf(API.Match.Pattern2<Tuple2<A, B>, A1, A2> pattern2, JsonRead<T> jsonRead) {
        return new ReadCase2<Object, Object, T>((object, object2) -> pattern2.isDefinedAt((Object)API.Tuple((Object)object, (Object)object2)), jsonRead);
    }

    default public <R> JsonRead<R> map(Function<T, R> function) {
        return JsonRead.of(jsonNode -> this.read((JsonNode)jsonNode).map(function), this.jsonSchema());
    }

    @Deprecated
    default public <R> JsonRead<R> flatMap(Function<T, JsonRead<R>> function) {
        return jsonNode -> this.read(jsonNode).flatMap((T object) -> ((JsonRead)function.apply(object)).read(jsonNode));
    }

    default public <R> JsonRead<R> flatMapResult(Function<T, JsResult<R>> function) {
        return jsonNode -> this.read(jsonNode).flatMap(function);
    }

    public static JsonRead<String> _string() {
        return JsonRead.of(jsonNode -> {
            if (!Objects.isNull(jsonNode) && jsonNode.isTextual()) {
                return JsResult.success(jsonNode.asText());
            }
            return JsResult.error((Seq<JsResult.Error>)List.of((Object)JsResult.Error.error("string.expected", new Object[0])));
        }, JsonSchema.stringSchema());
    }

    public static JsonRead<String> _string(String string) {
        return JsonRead.__(string, JsonRead._string());
    }

    public static <R> JsonRead<R> _string(String string, Function<String, R> function) {
        return JsonRead.__(string, JsonRead._string()).map(function);
    }

    public static <R> JsonRead<R> _string(Function<String, R> function) {
        return JsonRead._string().map(function);
    }

    public static JsonRead<Long> _long() {
        return JsonRead.of(jsonNode -> JsResult.success(jsonNode.asLong()), JsonSchema.numberSchema());
    }

    public static JsonRead<Integer> _int() {
        return JsonRead.of(jsonNode -> {
            if (!Objects.isNull(jsonNode) && jsonNode.isNumber()) {
                return JsResult.success(jsonNode.asInt());
            }
            return JsResult.error(JsResult.Error.error("number.expected", new Object[0]));
        }, JsonSchema.integerSchema());
    }

    public static JsonRead<Integer> _int(String string) {
        return JsonRead.__(string, JsonRead._int());
    }

    public static <R> JsonRead<R> _int(String string, Function<Integer, R> function) {
        return JsonRead._int(string).map(function);
    }

    public static JsonRead<BigDecimal> _bigDecimal() {
        return JsonRead.of(jsonNode -> {
            if (!Objects.isNull(jsonNode) && jsonNode.isTextual()) {
                return (JsResult)Try.of((CheckedFunction0 & Serializable)() -> JsResult.success(new BigDecimal(jsonNode.asText()).setScale(2, RoundingMode.HALF_UP))).getOrElseGet(throwable -> JsResult.error(JsResult.Error.error("pattern.invalid", new Object[0])));
            }
            return JsResult.error(JsResult.Error.error("string.expected", new Object[0]));
        }, JsonSchema.numberSchema());
    }

    public static JsonRead<Option<String>> _optString(String string) {
        return JsonRead._opt(string, JsonRead._string());
    }

    public static JsonRead<LocalDate> _localDate(DateTimeFormatter dateTimeFormatter) {
        return JsonRead.ofRead(JsonRead._string().flatMapResult(string -> (JsResult)Try.of((CheckedFunction0 & Serializable)() -> LocalDate.parse(string, dateTimeFormatter)).map(JsResult::success).getOrElseGet(throwable -> JsResult.error(JsResult.Error.error("pattern.invalid", new Object[0])))), JsonSchema.dateSchema());
    }

    public static JsonRead<LocalDate> _isoLocalDate() {
        return JsonRead._localDate(DateTimeFormatter.ISO_LOCAL_DATE);
    }

    public static JsonRead<LocalDateTime> _localDateTime(DateTimeFormatter dateTimeFormatter) {
        return JsonRead.ofRead(JsonRead._string().flatMapResult(string -> (JsResult)Try.of((CheckedFunction0 & Serializable)() -> LocalDateTime.parse(string, dateTimeFormatter)).map(JsResult::success).getOrElseGet(throwable -> JsResult.error(JsResult.Error.error("pattern.invalid", new Object[0])))), JsonSchema.dateTimeSchema());
    }

    public static JsonRead<LocalDateTime> _isoLocalDateTime() {
        return JsonRead._localDateTime(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
    }

    public static JsonRead<Boolean> _boolean() {
        return JsonRead.of(jsonNode -> {
            if (!Objects.isNull(jsonNode) && jsonNode.isBoolean()) {
                return JsResult.success(jsonNode.asBoolean());
            }
            return JsResult.error(JsResult.Error.error("boolean.expected", new Object[0]));
        }, JsonSchema.booleanSchema());
    }

    public static JsonRead<Boolean> _boolean(String string) {
        return JsonRead.__(string, JsonRead._boolean());
    }

    public static <E extends Enum<E>> JsonRead<E> _enum(Class<E> clazz) {
        return JsonRead.ofRead(JsonRead._string().flatMapResult(string -> (JsResult)Try.of((CheckedFunction0 & Serializable)() -> Enum.valueOf(clazz, string)).map(JsResult::success).getOrElseGet(throwable -> JsResult.error(JsResult.Error.error("invalid.enum.value", clazz.getEnumConstants())))), JsonSchema.enumSchema(clazz));
    }

    public static <E extends Enum<E>> JsonRead<E> _enum(String string, Class<E> clazz) {
        JsonRead<E> jsonRead = JsonRead._enum(clazz);
        return JsonRead.ofRead(JsonRead.__(string, jsonRead), JsonSchema.propertySchema(string, jsonRead.jsonSchema()));
    }

    public static class ReadCase2<A, B, T>
    implements ReadCase<Tuple2<A, B>, T> {
        private final JsonRead<T> read;
        private final BiPredicate<A, B> match;

        public ReadCase2(BiPredicate<A, B> biPredicate, JsonRead<T> jsonRead) {
            this.read = jsonRead;
            this.match = biPredicate;
        }

        @Override
        public <T1> ReadCase<Tuple2<A, B>, T1> map(Function<JsonRead<T>, JsonRead<T1>> function) {
            return new ReadCase2<A, B, T1>(this.match, function.apply(this.read));
        }

        @Override
        public Option<JsonRead<T>> jsonRead(Tuple2<A, B> tuple2) {
            if (this.match.test(tuple2._1, tuple2._2)) {
                return API.Some(this.read);
            }
            return API.None();
        }

        @Override
        public JsonSchema jsonSchema() {
            return this.read.jsonSchema();
        }
    }

    public static class ReadCase1<A, T>
    implements ReadCase<A, T> {
        private final JsonRead<T> read;
        private final Predicate<A> match;

        public ReadCase1(Predicate<A> predicate, JsonRead<T> jsonRead) {
            this.read = jsonRead;
            this.match = predicate;
        }

        @Override
        public <T1> ReadCase<A, T1> map(Function<JsonRead<T>, JsonRead<T1>> function) {
            return new ReadCase1<A, T1>(this.match, function.apply(this.read));
        }

        @Override
        public Option<JsonRead<T>> jsonRead(A a) {
            if (this.match.test(a)) {
                return API.Some(this.read);
            }
            return API.None();
        }

        @Override
        public JsonSchema jsonSchema() {
            return this.read.jsonSchema();
        }
    }

    public static interface ReadCase<A, T> {
        public Option<JsonRead<T>> jsonRead(A var1);

        public JsonSchema jsonSchema();

        public <T1> ReadCase<A, T1> map(Function<JsonRead<T>, JsonRead<T1>> var1);
    }
}

