/*
 * Decompiled with CFR 0.152.
 */
package fr.maif.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import fr.maif.json.Json;
import fr.maif.json.JsonWrite;
import io.vavr.API;
import io.vavr.Predicates;
import io.vavr.collection.List;
import io.vavr.collection.Traversable;
import io.vavr.control.Option;
import java.util.function.Function;
import java.util.function.Predicate;

public interface JsonSchema {
    public static final EmptySchema EMPTY_SCHEMA = new EmptySchema();
    public static final StringSchema STRING_SCHEMA = new StringSchema();
    public static final IntegerSchema INTEGER_SCHEMA = new IntegerSchema();
    public static final NumberSchema NUMBER_SCHEMA = new NumberSchema();
    public static final DateTimeSchema DATE_TIME_SCHEMA = new DateTimeSchema();
    public static final DateSchema DATE_SCHEMA = new DateSchema();
    public static final BooleanSchema BOOLEAN_SCHEMA = new BooleanSchema();

    public ObjectNode toJson();

    default public RootSchema toRoot() {
        if (this instanceof RootSchema) {
            return (RootSchema)this;
        }
        return RootSchema.empty(this);
    }

    public static EmptySchema emptySchema() {
        return EMPTY_SCHEMA;
    }

    public static StringSchema stringSchema() {
        return STRING_SCHEMA;
    }

    public static <E extends Enum<E>> EnumSchema<E> enumSchema(Class<E> clazz) {
        return new EnumSchema<E>(clazz);
    }

    public static EnumSchemaFromStrings enumSchema(List<String> list) {
        return new EnumSchemaFromStrings(list);
    }

    public static DateTimeSchema dateTimeSchema() {
        return DATE_TIME_SCHEMA;
    }

    public static JsonSchema dateSchema() {
        return DATE_SCHEMA;
    }

    public static BooleanSchema booleanSchema() {
        return BOOLEAN_SCHEMA;
    }

    public static JsonSchema numberSchema() {
        return NUMBER_SCHEMA;
    }

    public static JsonSchema integerSchema() {
        return INTEGER_SCHEMA;
    }

    public static ArraySchema arraySchema() {
        return new ArraySchema(null);
    }

    public static ArraySchema arraySchema(JsonSchema jsonSchema) {
        return new ArraySchema(jsonSchema);
    }

    public static ObjectSchema objectSchema() {
        return new ObjectSchema((List<Property>)List.empty());
    }

    public static ObjectSchema objectSchema(List<Property> list) {
        return new ObjectSchema(list);
    }

    public static ObjectSchema objectSchema(Property ... propertyArray) {
        return new ObjectSchema((List<Property>)API.List((Object[])propertyArray));
    }

    public static ObjectSchema objectSchema(String string, JsonSchema jsonSchema) {
        return new ObjectSchema((List<Property>)API.List((Object)JsonSchema.propertySchema(string, jsonSchema)));
    }

    default public JsonSchema computeSchema() {
        if (this instanceof Property) {
            return new ObjectSchema((List<Property>)API.List((Object)((Property)this)));
        }
        return this;
    }

    public static ObjectSchema objectSchema(String string, JsonSchema jsonSchema, Boolean bl) {
        return new ObjectSchema((List<Property>)API.List((Object)JsonSchema.propertySchema(string, jsonSchema).withRequired(bl)));
    }

    public static DefinitionsSchema definitionsSchema(List<Property> list) {
        return new DefinitionsSchema(list);
    }

    public static RefSchema refSchema(String string) {
        return new RefSchema(string);
    }

    public static Property propertySchema(String string, JsonSchema ... jsonSchemaArray) {
        return new Property(string, (List<JsonSchema>)Option.of((Object)jsonSchemaArray).map(List::of).toList().flatMap(Function.identity()), true);
    }

    public static Property propertySchema(String string, List<JsonSchema> list) {
        return new Property(string, list, true);
    }

    public static OneOfSchema oneOf(List<JsonSchema> list) {
        return new OneOfSchema(list);
    }

    public static OneOfSchema oneOf(JsonSchema ... jsonSchemaArray) {
        return new OneOfSchema((List<JsonSchema>)API.List((Object[])jsonSchemaArray));
    }

    public static AnyOfSchema anyOf(List<JsonSchema> list) {
        return new AnyOfSchema(list);
    }

    public static AllOfSchema allOf(List<JsonSchema> list) {
        return new AllOfSchema(list);
    }

    default public JsonSchema and(JsonSchema jsonSchema2) {
        return (JsonSchema)API.Match((Object)this).of(new API.Match.Case[]{API.Case((API.Match.Pattern0)API.$((Predicate)Predicates.instanceOf(EmptySchema.class)), emptySchema -> jsonSchema2), API.Case((API.Match.Pattern0)API.$((Predicate)Predicates.instanceOf(ObjectSchema.class)), objectSchema -> objectSchema.and(jsonSchema2)), API.Case((API.Match.Pattern0)API.$((Predicate)Predicates.instanceOf(Property.class)), property -> new ObjectSchema((List<Property>)List.of((Object)property)).and(jsonSchema2)), API.Case((API.Match.Pattern0)API.$(), jsonSchema -> this)});
    }

    default public JsonSchema id(String string) {
        return this.toRoot().withId(string);
    }

    default public JsonSchema title(String string) {
        return this.toRoot().withTitle(string);
    }

    default public JsonSchema description(String string) {
        return this.toRoot().withDescription(string);
    }

    default public JsonSchema schema(String string) {
        return this.toRoot().withSchema(string);
    }

    default public JsonSchema exemples(List<JsonNode> list) {
        return this.toRoot().withExemples(list);
    }

    public static class Property
    implements JsonSchema {
        private final String name;
        private final List<JsonSchema> schema;
        private final Boolean required;

        public Property(String string, List<JsonSchema> list, Boolean bl) {
            this.name = string;
            this.schema = list;
            this.required = bl;
        }

        public Property withRequired(Boolean bl) {
            return new Property(this.name, this.schema, bl);
        }

        public Property notRequired() {
            return new Property(this.name, this.schema, false);
        }

        @Override
        public Property id(String string) {
            return new Property(this.name, (List<JsonSchema>)this.schema.map(jsonSchema -> jsonSchema.id(string)), this.required);
        }

        @Override
        public Property title(String string) {
            return new Property(this.name, (List<JsonSchema>)this.schema.map(jsonSchema -> jsonSchema.title(string)), this.required);
        }

        @Override
        public Property description(String string) {
            return new Property(this.name, (List<JsonSchema>)this.schema.map(jsonSchema -> jsonSchema.description(string)), this.required);
        }

        @Override
        public Property schema(String string) {
            return new Property(this.name, (List<JsonSchema>)this.schema.map(jsonSchema -> jsonSchema.schema(string)), this.required);
        }

        @Override
        public Property exemples(List<JsonNode> list) {
            return new Property(this.name, (List<JsonSchema>)this.schema.map(jsonSchema -> jsonSchema.exemples(list)), this.required);
        }

        @Override
        public ObjectNode toJson() {
            if (this.schema.length() == 1) {
                return Json.obj(Json.$$(this.name, (JsonNode)((JsonSchema)this.schema.head()).toJson()));
            }
            return Json.obj(Json.$$(this.name, (JsonNode)Json.arr((JsonNode[])this.schema.map(JsonSchema::toJson).toJavaArray(ObjectNode[]::new))));
        }

        public String toString() {
            return "JsonSchema.Property(name=" + this.name + ", schema=" + this.schema + ", required=" + this.required + ")";
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Property)) {
                return false;
            }
            Property property = (Property)object;
            if (!property.canEqual(this)) {
                return false;
            }
            String string = this.name;
            String string2 = property.name;
            if (string == null ? string2 != null : !string.equals(string2)) {
                return false;
            }
            List<JsonSchema> list = this.schema;
            List<JsonSchema> list2 = property.schema;
            if (list == null ? list2 != null : !list.equals(list2)) {
                return false;
            }
            Boolean bl = this.required;
            Boolean bl2 = property.required;
            return !(bl == null ? bl2 != null : !((Object)bl).equals(bl2));
        }

        protected boolean canEqual(Object object) {
            return object instanceof Property;
        }

        public int hashCode() {
            int n = 1;
            String string = this.name;
            n = n * 59 + (string == null ? 43 : string.hashCode());
            List<JsonSchema> list = this.schema;
            n = n * 59 + (list == null ? 43 : list.hashCode());
            Boolean bl = this.required;
            n = n * 59 + (bl == null ? 43 : ((Object)bl).hashCode());
            return n;
        }
    }

    public static class RefSchema
    implements JsonSchema {
        private final String ref;

        public RefSchema(String string) {
            this.ref = string;
        }

        @Override
        public ObjectNode toJson() {
            return Json.obj(Json.$$("$ref", this.ref));
        }

        public String toString() {
            return "JsonSchema.RefSchema(ref=" + this.ref + ")";
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof RefSchema)) {
                return false;
            }
            RefSchema refSchema = (RefSchema)object;
            if (!refSchema.canEqual(this)) {
                return false;
            }
            String string = this.ref;
            String string2 = refSchema.ref;
            return !(string == null ? string2 != null : !string.equals(string2));
        }

        protected boolean canEqual(Object object) {
            return object instanceof RefSchema;
        }

        public int hashCode() {
            int n = 1;
            String string = this.ref;
            n = n * 59 + (string == null ? 43 : string.hashCode());
            return n;
        }
    }

    public static class DefinitionsSchema
    implements JsonSchema {
        private final List<Property> properties;

        public DefinitionsSchema(List<Property> list) {
            this.properties = list;
        }

        @Override
        public ObjectNode toJson() {
            if (this.properties.isEmpty()) {
                return Json.obj(Json.$$("definitions", (JsonNode)Json.obj(new Json.JsPair[0])));
            }
            return Json.obj(Json.$$("definitions", (JsonNode)this.properties.map(Property::toJson).fold((Object)Json.obj(new Json.JsPair[0]), Json::merge)));
        }

        public String toString() {
            return "JsonSchema.DefinitionsSchema(properties=" + this.properties + ")";
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof DefinitionsSchema)) {
                return false;
            }
            DefinitionsSchema definitionsSchema = (DefinitionsSchema)object;
            if (!definitionsSchema.canEqual(this)) {
                return false;
            }
            List<Property> list = this.properties;
            List<Property> list2 = definitionsSchema.properties;
            return !(list == null ? list2 != null : !list.equals(list2));
        }

        protected boolean canEqual(Object object) {
            return object instanceof DefinitionsSchema;
        }

        public int hashCode() {
            int n = 1;
            List<Property> list = this.properties;
            n = n * 59 + (list == null ? 43 : list.hashCode());
            return n;
        }
    }

    public static class ObjectSchema
    implements JsonSchema {
        private final List<Property> properties;

        public ObjectSchema(List<Property> list) {
            this.properties = list;
        }

        @Override
        public ObjectSchema and(JsonSchema jsonSchema2) {
            return (ObjectSchema)API.Match((Object)jsonSchema2).of(new API.Match.Case[]{API.Case((API.Match.Pattern0)API.$((Predicate)Predicates.instanceOf(ObjectSchema.class)), objectSchema -> new ObjectSchema((List<Property>)this.properties.appendAll(objectSchema.properties))), API.Case((API.Match.Pattern0)API.$((Predicate)Predicates.instanceOf(Property.class)), property -> new ObjectSchema((List<Property>)this.properties.append(property))), API.Case((API.Match.Pattern0)API.$(), jsonSchema -> this)});
        }

        @Override
        public ObjectNode toJson() {
            if (this.properties.isEmpty()) {
                return Json.obj(Json.$$("type", "object"));
            }
            List list = this.properties.filter(property -> ((Property)property).required).map(property -> ((Property)property).name);
            return Json.obj(Json.$$("type", "object"), Json.$$("required", (JsonNode)Json.arr((String[])list.sorted().toJavaArray(String[]::new))), Json.$$("properties", (JsonNode)this.properties.map(Property::toJson).fold((Object)Json.obj(new Json.JsPair[0]), Json::merge)));
        }

        public String toString() {
            return "JsonSchema.ObjectSchema(properties=" + this.properties + ")";
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof ObjectSchema)) {
                return false;
            }
            ObjectSchema objectSchema = (ObjectSchema)object;
            if (!objectSchema.canEqual(this)) {
                return false;
            }
            List<Property> list = this.properties;
            List<Property> list2 = objectSchema.properties;
            return !(list == null ? list2 != null : !list.equals(list2));
        }

        protected boolean canEqual(Object object) {
            return object instanceof ObjectSchema;
        }

        public int hashCode() {
            int n = 1;
            List<Property> list = this.properties;
            n = n * 59 + (list == null ? 43 : list.hashCode());
            return n;
        }
    }

    public static class ArraySchema
    implements JsonSchema {
        private final JsonSchema items;

        public ArraySchema(JsonSchema jsonSchema) {
            this.items = jsonSchema;
        }

        @Override
        public ObjectNode toJson() {
            if (this.items == null) {
                return Json.obj(Json.$$("type", "array"));
            }
            return Json.obj(Json.$$("type", "array"), Json.$$("items", (JsonNode)this.items.toJson()));
        }

        public String toString() {
            return "JsonSchema.ArraySchema(items=" + this.items + ")";
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof ArraySchema)) {
                return false;
            }
            ArraySchema arraySchema = (ArraySchema)object;
            if (!arraySchema.canEqual(this)) {
                return false;
            }
            JsonSchema jsonSchema = this.items;
            JsonSchema jsonSchema2 = arraySchema.items;
            return !(jsonSchema == null ? jsonSchema2 != null : !jsonSchema.equals(jsonSchema2));
        }

        protected boolean canEqual(Object object) {
            return object instanceof ArraySchema;
        }

        public int hashCode() {
            int n = 1;
            JsonSchema jsonSchema = this.items;
            n = n * 59 + (jsonSchema == null ? 43 : jsonSchema.hashCode());
            return n;
        }
    }

    public static class NumberSchema
    implements JsonSchema {
        @Override
        public ObjectNode toJson() {
            return Json.obj(Json.$$("type", "number"));
        }

        public String toString() {
            return "JsonSchema.NumberSchema()";
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof NumberSchema)) {
                return false;
            }
            NumberSchema numberSchema = (NumberSchema)object;
            return numberSchema.canEqual(this);
        }

        protected boolean canEqual(Object object) {
            return object instanceof NumberSchema;
        }

        public int hashCode() {
            int n = 1;
            return n;
        }
    }

    public static class IntegerSchema
    implements JsonSchema {
        @Override
        public ObjectNode toJson() {
            return Json.obj(Json.$$("type", "integer"));
        }

        public String toString() {
            return "JsonSchema.IntegerSchema()";
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof IntegerSchema)) {
                return false;
            }
            IntegerSchema integerSchema = (IntegerSchema)object;
            return integerSchema.canEqual(this);
        }

        protected boolean canEqual(Object object) {
            return object instanceof IntegerSchema;
        }

        public int hashCode() {
            int n = 1;
            return n;
        }
    }

    public static class BooleanSchema
    implements JsonSchema {
        @Override
        public ObjectNode toJson() {
            return Json.obj(Json.$$("type", "boolean"));
        }

        public String toString() {
            return "JsonSchema.BooleanSchema()";
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof BooleanSchema)) {
                return false;
            }
            BooleanSchema booleanSchema = (BooleanSchema)object;
            return booleanSchema.canEqual(this);
        }

        protected boolean canEqual(Object object) {
            return object instanceof BooleanSchema;
        }

        public int hashCode() {
            int n = 1;
            return n;
        }
    }

    public static class DateTimeSchema
    implements JsonSchema {
        @Override
        public ObjectNode toJson() {
            return Json.obj(Json.$$("type", "string"), Json.$$("format", "date-time"));
        }

        public String toString() {
            return "JsonSchema.DateTimeSchema()";
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof DateTimeSchema)) {
                return false;
            }
            DateTimeSchema dateTimeSchema = (DateTimeSchema)object;
            return dateTimeSchema.canEqual(this);
        }

        protected boolean canEqual(Object object) {
            return object instanceof DateTimeSchema;
        }

        public int hashCode() {
            int n = 1;
            return n;
        }
    }

    public static class DateSchema
    implements JsonSchema {
        @Override
        public ObjectNode toJson() {
            return Json.obj(Json.$$("type", "string"), Json.$$("format", "date"));
        }

        public String toString() {
            return "JsonSchema.DateSchema()";
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof DateSchema)) {
                return false;
            }
            DateSchema dateSchema = (DateSchema)object;
            return dateSchema.canEqual(this);
        }

        protected boolean canEqual(Object object) {
            return object instanceof DateSchema;
        }

        public int hashCode() {
            int n = 1;
            return n;
        }
    }

    public static class EnumSchemaFromStrings
    implements JsonSchema {
        private final List<String> values;

        public EnumSchemaFromStrings(List<String> list) {
            this.values = list;
        }

        @Override
        public ObjectNode toJson() {
            return Json.obj(Json.$$("type", "string"), Json.$$("enum", this.values, JsonWrite.$list(JsonWrite.$string())));
        }

        public String toString() {
            return "JsonSchema.EnumSchemaFromStrings(values=" + this.values + ")";
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof EnumSchemaFromStrings)) {
                return false;
            }
            EnumSchemaFromStrings enumSchemaFromStrings = (EnumSchemaFromStrings)object;
            if (!enumSchemaFromStrings.canEqual(this)) {
                return false;
            }
            List<String> list = this.values;
            List<String> list2 = enumSchemaFromStrings.values;
            return !(list == null ? list2 != null : !list.equals(list2));
        }

        protected boolean canEqual(Object object) {
            return object instanceof EnumSchemaFromStrings;
        }

        public int hashCode() {
            int n = 1;
            List<String> list = this.values;
            n = n * 59 + (list == null ? 43 : list.hashCode());
            return n;
        }
    }

    public static class EnumSchema<E extends Enum<E>>
    implements JsonSchema {
        private final Class<E> enumClass;

        public EnumSchema(Class<E> clazz) {
            this.enumClass = clazz;
        }

        @Override
        public ObjectNode toJson() {
            return Json.obj(Json.$$("type", "string"), Json.$$("enum", (JsonNode)Json.arr((Traversable<JsonNode>)List.of((Object[])this.enumClass.getEnumConstants()).map(Enum::name).map(TextNode::new))));
        }

        public String toString() {
            return "JsonSchema.EnumSchema(enumClass=" + this.enumClass + ")";
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof EnumSchema)) {
                return false;
            }
            EnumSchema enumSchema = (EnumSchema)object;
            if (!enumSchema.canEqual(this)) {
                return false;
            }
            Class<E> clazz = this.enumClass;
            Class<E> clazz2 = enumSchema.enumClass;
            return !(clazz == null ? clazz2 != null : !clazz.equals(clazz2));
        }

        protected boolean canEqual(Object object) {
            return object instanceof EnumSchema;
        }

        public int hashCode() {
            int n = 1;
            Class<E> clazz = this.enumClass;
            n = n * 59 + (clazz == null ? 43 : clazz.hashCode());
            return n;
        }
    }

    public static class AllOfSchema
    implements JsonSchema {
        private final List<JsonSchema> schemas;

        public AllOfSchema(List<JsonSchema> list) {
            this.schemas = list;
        }

        @Override
        public ObjectNode toJson() {
            return Json.obj(Json.$$("allOf", (JsonNode)Json.arr((Traversable<JsonNode>)this.schemas.map(JsonSchema::toJson))));
        }

        public String toString() {
            return "JsonSchema.AllOfSchema(schemas=" + this.schemas + ")";
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof AllOfSchema)) {
                return false;
            }
            AllOfSchema allOfSchema = (AllOfSchema)object;
            if (!allOfSchema.canEqual(this)) {
                return false;
            }
            List<JsonSchema> list = this.schemas;
            List<JsonSchema> list2 = allOfSchema.schemas;
            return !(list == null ? list2 != null : !list.equals(list2));
        }

        protected boolean canEqual(Object object) {
            return object instanceof AllOfSchema;
        }

        public int hashCode() {
            int n = 1;
            List<JsonSchema> list = this.schemas;
            n = n * 59 + (list == null ? 43 : list.hashCode());
            return n;
        }
    }

    public static class AnyOfSchema
    implements JsonSchema {
        private final List<JsonSchema> schemas;

        public AnyOfSchema(List<JsonSchema> list) {
            this.schemas = list;
        }

        @Override
        public ObjectNode toJson() {
            return Json.obj(Json.$$("anyOf", (JsonNode)Json.arr((Traversable<JsonNode>)this.schemas.map(JsonSchema::toJson))));
        }

        public String toString() {
            return "JsonSchema.AnyOfSchema(schemas=" + this.schemas + ")";
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof AnyOfSchema)) {
                return false;
            }
            AnyOfSchema anyOfSchema = (AnyOfSchema)object;
            if (!anyOfSchema.canEqual(this)) {
                return false;
            }
            List<JsonSchema> list = this.schemas;
            List<JsonSchema> list2 = anyOfSchema.schemas;
            return !(list == null ? list2 != null : !list.equals(list2));
        }

        protected boolean canEqual(Object object) {
            return object instanceof AnyOfSchema;
        }

        public int hashCode() {
            int n = 1;
            List<JsonSchema> list = this.schemas;
            n = n * 59 + (list == null ? 43 : list.hashCode());
            return n;
        }
    }

    public static class OneOfSchema
    implements JsonSchema {
        private final List<JsonSchema> schemas;

        public OneOfSchema(List<JsonSchema> list) {
            this.schemas = list.distinct();
        }

        @Override
        public ObjectNode toJson() {
            return Json.obj(Json.$$("oneOf", (JsonNode)Json.arr((Traversable<JsonNode>)this.schemas.map(JsonSchema::toJson))));
        }

        public String toString() {
            return "JsonSchema.OneOfSchema(schemas=" + this.schemas + ")";
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof OneOfSchema)) {
                return false;
            }
            OneOfSchema oneOfSchema = (OneOfSchema)object;
            if (!oneOfSchema.canEqual(this)) {
                return false;
            }
            List<JsonSchema> list = this.schemas;
            List<JsonSchema> list2 = oneOfSchema.schemas;
            return !(list == null ? list2 != null : !list.equals(list2));
        }

        protected boolean canEqual(Object object) {
            return object instanceof OneOfSchema;
        }

        public int hashCode() {
            int n = 1;
            List<JsonSchema> list = this.schemas;
            n = n * 59 + (list == null ? 43 : list.hashCode());
            return n;
        }
    }

    public static class StringSchema
    implements JsonSchema {
        @Override
        public ObjectNode toJson() {
            return Json.obj(Json.$$("type", "string"));
        }

        public String toString() {
            return "JsonSchema.StringSchema()";
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof StringSchema)) {
                return false;
            }
            StringSchema stringSchema = (StringSchema)object;
            return stringSchema.canEqual(this);
        }

        protected boolean canEqual(Object object) {
            return object instanceof StringSchema;
        }

        public int hashCode() {
            int n = 1;
            return n;
        }
    }

    public static class EmptySchema
    implements JsonSchema {
        @Override
        public ObjectNode toJson() {
            return Json.obj(new Json.JsPair[0]);
        }

        public String toString() {
            return "JsonSchema.EmptySchema()";
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof EmptySchema)) {
                return false;
            }
            EmptySchema emptySchema = (EmptySchema)object;
            return emptySchema.canEqual(this);
        }

        protected boolean canEqual(Object object) {
            return object instanceof EmptySchema;
        }

        public int hashCode() {
            int n = 1;
            return n;
        }
    }

    public static class RootSchema
    implements JsonSchema {
        private final Option<String> schema;
        private final Option<String> id;
        private final Option<String> title;
        private final Option<String> description;
        private final List<JsonNode> exemples;
        private final JsonSchema embeddedSchema;

        public RootSchema(Option<String> option, Option<String> option2, Option<String> option3, Option<String> option4, List<JsonNode> list, JsonSchema jsonSchema) {
            this.schema = option == null ? Option.none() : option;
            this.id = option2 == null ? Option.none() : option2;
            this.title = option3 == null ? Option.none() : option3;
            this.description = option4 == null ? Option.none() : option4;
            this.exemples = list == null ? List.empty() : list;
            this.embeddedSchema = jsonSchema;
        }

        public static RootSchema empty(JsonSchema jsonSchema) {
            return new RootSchema((Option<String>)Option.none(), (Option<String>)Option.none(), (Option<String>)Option.none(), (Option<String>)Option.none(), (List<JsonNode>)List.empty(), jsonSchema);
        }

        public RootSchema withSchema(String string) {
            if (this.embeddedSchema instanceof RootSchema) {
                return ((RootSchema)this.embeddedSchema).withSchema(string);
            }
            return new RootSchema((Option<String>)Option.of((Object)string), this.id, this.title, this.description, this.exemples, this.embeddedSchema);
        }

        public RootSchema withId(String string) {
            if (this.embeddedSchema instanceof RootSchema) {
                return ((RootSchema)this.embeddedSchema).withId(string);
            }
            return new RootSchema(this.schema, (Option<String>)Option.of((Object)string), this.title, this.description, this.exemples, this.embeddedSchema);
        }

        public RootSchema withTitle(String string) {
            if (this.embeddedSchema instanceof RootSchema) {
                return ((RootSchema)this.embeddedSchema).withTitle(string);
            }
            return new RootSchema(this.schema, this.id, (Option<String>)Option.of((Object)string), this.description, this.exemples, this.embeddedSchema);
        }

        public RootSchema withDescription(String string) {
            if (this.embeddedSchema instanceof RootSchema) {
                return ((RootSchema)this.embeddedSchema).withDescription(string);
            }
            return new RootSchema(this.schema, this.id, this.title, (Option<String>)Option.of((Object)string), this.exemples, this.embeddedSchema);
        }

        public RootSchema withExemples(List<JsonNode> list) {
            if (this.embeddedSchema instanceof RootSchema) {
                return ((RootSchema)this.embeddedSchema).withExemples(list);
            }
            return new RootSchema(this.schema, this.id, this.title, this.description, (List<JsonNode>)Option.of(list).toList().flatMap(Function.identity()), this.embeddedSchema);
        }

        @Override
        public ObjectNode toJson() {
            ObjectNode objectNode = this.embeddedSchema.toJson();
            return Json.obj(objectNode, Json.$$("$schema", this.schema), Json.$$("$id", this.id), Json.$$("title", this.title), Json.$$("description", this.description), Json.$$("exemples", (JsonNode)Json.arr((JsonNode[])this.exemples.toJavaArray(JsonNode[]::new))));
        }

        public String toString() {
            return "JsonSchema.RootSchema(schema=" + this.schema + ", id=" + this.id + ", title=" + this.title + ", description=" + this.description + ", exemples=" + this.exemples + ", embeddedSchema=" + this.embeddedSchema + ")";
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof RootSchema)) {
                return false;
            }
            RootSchema rootSchema = (RootSchema)object;
            if (!rootSchema.canEqual(this)) {
                return false;
            }
            Option<String> option = this.schema;
            Option<String> option2 = rootSchema.schema;
            if (option == null ? option2 != null : !option.equals(option2)) {
                return false;
            }
            Option<String> option3 = this.id;
            Option<String> option4 = rootSchema.id;
            if (option3 == null ? option4 != null : !option3.equals(option4)) {
                return false;
            }
            Option<String> option5 = this.title;
            Option<String> option6 = rootSchema.title;
            if (option5 == null ? option6 != null : !option5.equals(option6)) {
                return false;
            }
            Option<String> option7 = this.description;
            Option<String> option8 = rootSchema.description;
            if (option7 == null ? option8 != null : !option7.equals(option8)) {
                return false;
            }
            List<JsonNode> list = this.exemples;
            List<JsonNode> list2 = rootSchema.exemples;
            if (list == null ? list2 != null : !list.equals(list2)) {
                return false;
            }
            JsonSchema jsonSchema = this.embeddedSchema;
            JsonSchema jsonSchema2 = rootSchema.embeddedSchema;
            return !(jsonSchema == null ? jsonSchema2 != null : !jsonSchema.equals(jsonSchema2));
        }

        protected boolean canEqual(Object object) {
            return object instanceof RootSchema;
        }

        public int hashCode() {
            int n = 1;
            Option<String> option = this.schema;
            n = n * 59 + (option == null ? 43 : option.hashCode());
            Option<String> option2 = this.id;
            n = n * 59 + (option2 == null ? 43 : option2.hashCode());
            Option<String> option3 = this.title;
            n = n * 59 + (option3 == null ? 43 : option3.hashCode());
            Option<String> option4 = this.description;
            n = n * 59 + (option4 == null ? 43 : option4.hashCode());
            List<JsonNode> list = this.exemples;
            n = n * 59 + (list == null ? 43 : list.hashCode());
            JsonSchema jsonSchema = this.embeddedSchema;
            n = n * 59 + (jsonSchema == null ? 43 : jsonSchema.hashCode());
            return n;
        }
    }
}

