/*
 * Decompiled with CFR 0.152.
 */
package fr.maif.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import fr.maif.json.Json;
import io.vavr.collection.Traversable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;

@FunctionalInterface
public interface JsonWrite<T> {
    public JsonNode write(T var1);

    public static <T> JsonWrite<T> auto() {
        return object -> Json.mapper().valueToTree(object);
    }

    public static JsonWrite<LocalDate> $localdate(DateTimeFormatter dateTimeFormatter) {
        return localDate -> new TextNode(dateTimeFormatter.format((TemporalAccessor)localDate));
    }

    public static JsonWrite<LocalDateTime> $localdatetime(DateTimeFormatter dateTimeFormatter) {
        return localDateTime -> new TextNode(dateTimeFormatter.format((TemporalAccessor)localDateTime));
    }

    public static JsonWrite<LocalDate> $localdate() {
        return JsonWrite.$localdate(DateTimeFormatter.ISO_LOCAL_DATE);
    }

    public static JsonWrite<LocalDateTime> $localdatetime() {
        return JsonWrite.$localdatetime(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
    }

    public static JsonWrite<String> $string() {
        return TextNode::new;
    }

    public static JsonWrite<Boolean> $boolean() {
        return BooleanNode::valueOf;
    }

    public static JsonWrite<Integer> $int() {
        return IntNode::new;
    }

    public static JsonWrite<BigDecimal> $bigdecimal() {
        return bigDecimal -> new TextNode(bigDecimal.setScale(2, RoundingMode.HALF_UP).toString());
    }

    public static JsonWrite<ObjectNode> $jsonObject() {
        return objectNode -> objectNode;
    }

    public static JsonWrite<ArrayNode> $jsonArray() {
        return arrayNode -> arrayNode;
    }

    public static <T extends Enum<T>> JsonWrite<T> $enum() {
        return enum_ -> new TextNode(enum_.name());
    }

    public static <T> JsonWrite<Traversable<T>> $list(JsonWrite<T> jsonWrite) {
        return traversable -> {
            if (traversable == null) {
                return Json.newArray();
            }
            return Json.arr((JsonNode[])traversable.map(jsonWrite::write).toJavaArray(JsonNode[]::new));
        };
    }
}

