/*
 * Decompiled with CFR 0.152.
 */
package org.extism.sdk;

import com.sun.jna.Pointer;
import org.extism.sdk.HostFunction;
import org.extism.sdk.LibExtism;
import org.extism.sdk.LinearMemory;
import org.extism.sdk.Plugin;
import org.extism.sdk.manifest.Manifest;

public class Context
implements AutoCloseable {
    private final Pointer contextPointer = LibExtism.INSTANCE.extism_context_new();

    public Plugin newPlugin(Manifest manifest, boolean withWASI, HostFunction[] functions, LinearMemory[] memories) {
        return new Plugin(this, manifest, withWASI, functions, memories);
    }

    public Plugin newPlugin(Manifest manifest, boolean withWASI, HostFunction[] functions) {
        return new Plugin(this, manifest, withWASI, functions, new LinearMemory[0]);
    }

    public void free() {
        LibExtism.INSTANCE.extism_context_free(this.contextPointer);
    }

    public void reset() {
        LibExtism.INSTANCE.extism_context_reset(this.contextPointer);
    }

    public String getVersion() {
        return LibExtism.INSTANCE.extism_version();
    }

    protected String error(Plugin plugin) {
        return LibExtism.INSTANCE.extism_error(this.contextPointer, plugin == null ? -1 : plugin.getIndex());
    }

    public Pointer getPointer() {
        return this.contextPointer;
    }

    @Override
    public void close() {
        this.free();
    }
}

