/*
 * Decompiled with CFR 0.152.
 */
package org.extism.sdk;

import java.nio.file.Path;
import java.util.Objects;
import org.extism.sdk.Context;
import org.extism.sdk.ExtismException;
import org.extism.sdk.LibExtism;
import org.extism.sdk.Plugin;
import org.extism.sdk.manifest.Manifest;

public class Extism {
    @Deprecated(forRemoval=true)
    public static void setLogFile(Path path, LogLevel level) {
        Objects.requireNonNull(path, "path");
        Objects.requireNonNull(level, "level");
        boolean result = LibExtism.INSTANCE.extism_log_file(path.toString(), level.getLevel());
        if (!result) {
            String error = String.format("Could not set extism logger to %s with level %s", new Object[]{path, level});
            throw new ExtismException(error);
        }
    }

    public static String invokeFunction(Manifest manifest, String function, String input) throws ExtismException {
        try (Context ctx = new Context();){
            Plugin plugin = ctx.newPlugin(manifest, false, null);
            try {
                String string = plugin.call(function, input);
                if (plugin != null) {
                    plugin.close();
                }
                return string;
            }
            catch (Throwable throwable) {
                if (plugin != null) {
                    try {
                        plugin.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    }

    public static enum LogLevel {
        INFO("info"),
        DEBUG("debug"),
        WARN("warn"),
        TRACE("trace");

        private final String level;

        private LogLevel(String level) {
            this.level = level;
        }

        public String getLevel() {
            return this.level;
        }
    }
}

