/*
 * Decompiled with CFR 0.152.
 */
package org.extism.sdk;

import com.sun.jna.Pointer;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.extism.sdk.CancelHandle;
import org.extism.sdk.Context;
import org.extism.sdk.ExtismException;
import org.extism.sdk.HostFunction;
import org.extism.sdk.LibExtism;
import org.extism.sdk.LinearMemory;
import org.extism.sdk.Parameters;
import org.extism.sdk.Results;
import org.extism.sdk.manifest.Manifest;
import org.extism.sdk.support.JsonSerde;

public class Plugin
implements AutoCloseable {
    private final Context context;
    private final int index;

    public Plugin(Context context, byte[] manifestBytes, boolean withWASI, HostFunction[] functions, LinearMemory[] memories) {
        Objects.requireNonNull(context, "context");
        Objects.requireNonNull(manifestBytes, "manifestBytes");
        Pointer[] functionsPtr = HostFunction.arrayToPointer(functions);
        Pointer[] memoriesPtr = LinearMemory.arrayToPointer(memories);
        Pointer contextPointer = context.getPointer();
        int index = LibExtism.INSTANCE.extism_plugin_new(contextPointer, manifestBytes, manifestBytes.length, functionsPtr, functions == null ? 0 : functions.length, withWASI, memoriesPtr, memories == null ? 0 : memories.length);
        if (index == -1) {
            String error = context.error(this);
            throw new ExtismException(error);
        }
        this.index = index;
        this.context = context;
    }

    public Plugin(Context context, Manifest manifest, boolean withWASI, HostFunction[] functions, LinearMemory[] memories) {
        this(context, Plugin.serialize(manifest), withWASI, functions, memories);
    }

    private static byte[] serialize(Manifest manifest) {
        Objects.requireNonNull(manifest, "manifest");
        return JsonSerde.toJson(manifest).getBytes(StandardCharsets.UTF_8);
    }

    public int getIndex() {
        return this.index;
    }

    public byte[] call(String functionName, byte[] inputData) {
        Objects.requireNonNull(functionName, "functionName");
        Pointer contextPointer = this.context.getPointer();
        int inputDataLength = inputData == null ? 0 : inputData.length;
        int exitCode = LibExtism.INSTANCE.extism_plugin_call(contextPointer, this.index, functionName, inputData, inputDataLength);
        if (exitCode == -1) {
            String error = this.context.error(this);
            throw new ExtismException(error);
        }
        int length = LibExtism.INSTANCE.extism_plugin_output_length(contextPointer, this.index);
        Pointer output = LibExtism.INSTANCE.extism_plugin_output_data(contextPointer, this.index);
        return output.getByteArray(0L, length);
    }

    public String call(String functionName, String input) {
        Objects.requireNonNull(functionName, "functionName");
        byte[] inputBytes = input == null ? null : input.getBytes(StandardCharsets.UTF_8);
        byte[] outputBytes = this.call(functionName, inputBytes);
        return new String(outputBytes, StandardCharsets.UTF_8);
    }

    public Results call(String functionName, Parameters params, int resultsLength) {
        return this.call(functionName, params, resultsLength, new byte[0]);
    }

    public Results call(String functionName, Parameters params, int resultsLength, byte[] input) {
        Pointer contextPointer = this.context.getPointer();
        params.getPtr().write();
        LibExtism.ExtismVal.ByReference results = LibExtism.INSTANCE.wasm_plugin_call(contextPointer, this.index, functionName, params.getPtr(), params.getLength(), input, input.length);
        if (results == null && resultsLength > 0) {
            String error = this.context.error(this);
            throw new ExtismException(error);
        }
        if (results == null) {
            if (resultsLength > 0) {
                String error = this.context.error(this);
                throw new ExtismException(error);
            }
            return new Results(0);
        }
        return new Results(results, resultsLength);
    }

    public Context getContext() {
        return this.context;
    }

    public boolean update(Manifest manifest, boolean withWASI, HostFunction[] functions, LinearMemory[] memories) {
        return this.update(Plugin.serialize(manifest), withWASI, functions, memories);
    }

    public boolean update(byte[] manifestBytes, boolean withWASI, HostFunction[] functions, LinearMemory[] memories) {
        Objects.requireNonNull(manifestBytes, "manifestBytes");
        Pointer[] ptrArr = HostFunction.arrayToPointer(functions);
        Pointer[] ptrMem = LinearMemory.arrayToPointer(memories);
        return LibExtism.INSTANCE.extism_plugin_update(this.context.getPointer(), this.index, manifestBytes, manifestBytes.length, ptrArr, functions == null ? 0 : functions.length, withWASI, ptrMem, memories == null ? 0 : memories.length);
    }

    public void free() {
        LibExtism.INSTANCE.extism_plugin_free(this.context.getPointer(), this.index);
    }

    public boolean updateConfig(String json) {
        Objects.requireNonNull(json, "json");
        return this.updateConfig(json.getBytes(StandardCharsets.UTF_8));
    }

    public boolean updateConfig(byte[] jsonBytes) {
        Objects.requireNonNull(jsonBytes, "jsonBytes");
        return LibExtism.INSTANCE.extism_plugin_config(this.context.getPointer(), this.index, jsonBytes, jsonBytes.length);
    }

    @Override
    public void close() {
        this.free();
    }

    public Pointer getPointer() {
        return this.context.getPointer();
    }

    public CancelHandle cancelHandle() {
        if (this.context.getPointer() == null) {
            throw new ExtismException("No Context set");
        }
        Pointer handle = LibExtism.INSTANCE.extism_plugin_cancel_handle(this.context.getPointer(), this.index);
        return new CancelHandle(handle);
    }

    public void reset() {
        LibExtism.INSTANCE.extism_reset(this.context.getPointer(), this.index);
    }

    public Pointer callWithoutParams(String functionName, int resultsLength) {
        Pointer results = LibExtism.INSTANCE.wasm_plugin_call_without_params(this.context.getPointer(), this.index, functionName, new byte[0], 0);
        if (results == null) {
            if (resultsLength > 0) {
                String error = this.context.error(this);
                throw new ExtismException(error);
            }
            return null;
        }
        return results;
    }

    public void callWithoutResults(String functionName, Parameters params) {
        Pointer contextPointer = this.context.getPointer();
        params.getPtr().write();
        LibExtism.INSTANCE.wasm_plugin_call_without_results(contextPointer, this.index, functionName, params.getPtr(), params.getLength(), new byte[0], 0);
    }
}

