/*
 * Decompiled with CFR 0.152.
 */
package org.extism.sdk.manifest;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.extism.sdk.manifest.MemoryOptions;
import org.extism.sdk.wasm.WasmSource;

public class Manifest {
    @SerializedName(value="wasm")
    private final List<WasmSource> sources;
    @SerializedName(value="memory")
    private final MemoryOptions memoryOptions;
    @SerializedName(value="allowed_hosts")
    private final List<String> allowedHosts;
    @SerializedName(value="allowed_paths")
    private final Map<String, String> allowedPaths;
    @SerializedName(value="config")
    private final Map<String, String> config;

    public Manifest() {
        this(new ArrayList<WasmSource>(), null, null, null, null);
    }

    public Manifest(WasmSource source) {
        this(List.of(source));
    }

    public Manifest(List<WasmSource> sources) {
        this(sources, null, null, null, null);
    }

    public Manifest(List<WasmSource> sources, MemoryOptions memoryOptions) {
        this(sources, memoryOptions, null, null, null);
    }

    public Manifest(List<WasmSource> sources, MemoryOptions memoryOptions, Map<String, String> config) {
        this(sources, memoryOptions, config, null, null);
    }

    public Manifest(List<WasmSource> sources, MemoryOptions memoryOptions, Map<String, String> config, List<String> allowedHosts) {
        this(sources, memoryOptions, config, allowedHosts, null);
    }

    public Manifest(List<WasmSource> sources, MemoryOptions memoryOptions, Map<String, String> config, List<String> allowedHosts, Map<String, String> allowedPaths) {
        this.sources = sources;
        this.memoryOptions = memoryOptions;
        this.config = config;
        this.allowedHosts = allowedHosts;
        this.allowedPaths = allowedPaths;
    }

    public void addSource(WasmSource source) {
        this.sources.add(source);
    }

    public List<WasmSource> getSources() {
        return Collections.unmodifiableList(this.sources);
    }

    public MemoryOptions getMemoryOptions() {
        return this.memoryOptions;
    }

    public Map<String, String> getConfig() {
        if (this.config == null || this.config.isEmpty()) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.config);
    }

    public List<String> getAllowedHosts() {
        if (this.allowedHosts == null || this.allowedHosts.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.allowedHosts);
    }

    public Map<String, String> getAllowedPaths() {
        if (this.allowedPaths == null || this.allowedPaths.isEmpty()) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.allowedPaths);
    }
}

