/*
 * Decompiled with CFR 0.152.
 */
package org.extism.sdk.support;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Base64;
import org.extism.sdk.manifest.Manifest;

public class JsonSerde {
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().registerTypeHierarchyAdapter(byte[].class, (Object)new ByteArrayAdapter()).setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting().create();

    public static String toJson(Manifest manifest) {
        return GSON.toJson((Object)manifest);
    }

    private static class ByteArrayAdapter
    extends TypeAdapter<byte[]> {
        private ByteArrayAdapter() {
        }

        public void write(JsonWriter out, byte[] byteValue) throws IOException {
            out.value(new String(Base64.getEncoder().encode(byteValue)));
        }

        public byte[] read(JsonReader in) {
            try {
                if (in.peek() == JsonToken.NULL) {
                    in.nextNull();
                    return new byte[0];
                }
                String byteValue = in.nextString();
                if (byteValue != null) {
                    return Base64.getDecoder().decode(byteValue);
                }
                return new byte[0];
            }
            catch (Exception e) {
                throw new JsonParseException((Throwable)e);
            }
        }
    }
}

