/*
 * Decompiled with CFR 0.152.
 */
package org.extism.sdk.wasm;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Objects;
import org.extism.sdk.ExtismException;
import org.extism.sdk.support.Hashing;
import org.extism.sdk.wasm.ByteArrayWasmSource;
import org.extism.sdk.wasm.PathWasmSource;

public class WasmSourceResolver {
    public PathWasmSource resolve(Path path) {
        return this.resolve(null, path);
    }

    public PathWasmSource resolve(String name, Path path) {
        Objects.requireNonNull(path, "path");
        File wasmFile = path.toFile();
        String hash = this.hash(path);
        String wasmName = name == null ? wasmFile.getName() : name;
        return new PathWasmSource(wasmName, wasmFile.getAbsolutePath(), hash);
    }

    public ByteArrayWasmSource resolve(String name, byte[] bytes) {
        return new ByteArrayWasmSource(name, bytes, this.hash(bytes));
    }

    protected String hash(Path wasmFile) {
        try {
            return this.hash(Files.readAllBytes(wasmFile));
        }
        catch (IOException ioe) {
            throw new ExtismException("Could not compute hash from path: " + wasmFile, ioe);
        }
    }

    protected String hash(byte[] bytes) {
        return Hashing.sha256HexDigest(bytes);
    }
}

