/*
 * Decompiled with CFR 0.152.
 */
package org.extism.sdk.wasmotoroshi;

import org.extism.sdk.wasmotoroshi.WasmBridge;

public class WasmOtoroshiParameters
implements AutoCloseable {
    protected WasmBridge.ExtismVal.ByReference ptr;
    protected WasmBridge.ExtismVal[] values;
    private final int length;
    private int next = 0;

    public WasmOtoroshiParameters(int length) {
        this.ptr = new WasmBridge.ExtismVal.ByReference();
        if (length > 0) {
            this.values = (WasmBridge.ExtismVal[])this.ptr.toArray(length);
        }
        this.next = 0;
        this.length = length;
    }

    public WasmOtoroshiParameters(WasmBridge.ExtismVal.ByReference ptr, int length) {
        this.ptr = ptr;
        this.length = length;
        if (length > 0) {
            this.values = (WasmBridge.ExtismVal[])this.ptr.toArray(length);
        }
    }

    public WasmOtoroshiParameters pushInt(int value) {
        int length = this.getNext();
        this.values[length].t = 0;
        this.values[length].v.setType(Integer.TYPE);
        this.values[length].v.i32 = value;
        return this;
    }

    public WasmOtoroshiParameters pushInts(int ... values) {
        for (int value : values) {
            int length = this.getNext();
            this.values[length].t = 0;
            this.values[length].v.setType(Integer.TYPE);
            this.values[length].v.i32 = value;
        }
        return this;
    }

    public WasmOtoroshiParameters pushLong(long value) {
        int length = this.getNext();
        this.values[length].t = 0;
        this.values[length].v.setType(Long.TYPE);
        this.values[length].v.i64 = value;
        return this;
    }

    public WasmOtoroshiParameters pushLongs(long ... values) {
        for (long value : values) {
            int length = this.getNext();
            this.values[length].t = 0;
            this.values[length].v.setType(Long.TYPE);
            this.values[length].v.i64 = value;
        }
        return this;
    }

    public WasmOtoroshiParameters pushFloat(float value) {
        int length = this.getNext();
        this.values[length].t = 0;
        this.values[length].v.setType(Float.TYPE);
        this.values[length].v.f32 = value;
        return this;
    }

    public WasmOtoroshiParameters pushFloats(float ... values) {
        for (float value : values) {
            int length = this.getNext();
            this.values[length].t = 0;
            this.values[length].v.setType(Float.TYPE);
            this.values[length].v.f32 = value;
        }
        return this;
    }

    public WasmOtoroshiParameters pushDouble(double value) {
        int length = this.getNext();
        this.values[length].t = 0;
        this.values[length].v.setType(Double.TYPE);
        this.values[length].v.f64 = value;
        return this;
    }

    public WasmOtoroshiParameters pushDouble(double ... values) {
        for (double value : values) {
            int length = this.getNext();
            this.values[length].t = 0;
            this.values[length].v.setType(Double.TYPE);
            this.values[length].v.f64 = value;
        }
        return this;
    }

    private int getNext() {
        int result = this.next++;
        return result;
    }

    public WasmBridge.ExtismVal[] getValues() {
        return this.values;
    }

    public WasmBridge.ExtismVal getValue(int pos) {
        return this.values[pos];
    }

    public WasmBridge.ExtismVal.ByReference getPtr() {
        return this.ptr;
    }

    public int getLength() {
        return this.length;
    }

    public void set(AddFunction function, int i) {
        this.values[i] = function.invoke(this.values[i]);
    }

    @Override
    public void close() {
        WasmBridge.INSTANCE.wasm_otoroshi_deallocate_results(this.ptr, this.length);
    }

    static interface AddFunction {
        public WasmBridge.ExtismVal invoke(WasmBridge.ExtismVal var1);
    }
}

