/*
 * Decompiled with CFR 0.152.
 */
package fr.marcwrobel.jbanking.bic;

import fr.marcwrobel.jbanking.IsoCountry;
import fr.marcwrobel.jbanking.bic.BicFormatException;
import java.io.Serializable;
import java.util.regex.Pattern;

public final class Bic
implements Serializable {
    private static final long serialVersionUID = 0L;
    public static final String BIC_REGEX = "[A-Za-z]{4}[A-Za-z]{2}[A-Za-z0-9]{2}([A-Za-z0-9]{3})?";
    public static final Pattern BIC_PATTERN = Pattern.compile("[A-Za-z]{4}[A-Za-z]{2}[A-Za-z0-9]{2}([A-Za-z0-9]{3})?");
    public static final String PRIMARY_OFFICE_BRANCH_CODE = "XXX";
    public static final char TEST_BIC_INDICATOR = '0';
    private static final int BIC8_LENGTH = 8;
    private static final int INSTITUTION_CODE_INDEX = 0;
    private static final int INSTITUTION_CODE_LENGTH = 4;
    private static final int COUNTRY_CODE_INDEX = 4;
    private static final int COUNTRY_CODE_LENGTH = 2;
    private static final int LOCATION_CODE_INDEX = 6;
    private static final int LOCATION_CODE_LENGTH = 2;
    private static final int BRANCH_CODE_INDEX = 8;
    private static final int BRANCH_CODE_LENGTH = 3;
    private final String normalizedBic;

    public Bic(String bic8Or11) {
        if (bic8Or11 == null) {
            throw new IllegalArgumentException("the bic8Or11 argument cannot be null");
        }
        if (!Bic.isWellFormatted(bic8Or11)) {
            throw BicFormatException.forNotProperlyFormattedInput(bic8Or11);
        }
        if (!Bic.hasKnownCountryCode(bic8Or11)) {
            throw BicFormatException.forUnknownCountryCode(bic8Or11);
        }
        String cleanedBic = bic8Or11.toUpperCase();
        if (cleanedBic.length() == 8) {
            cleanedBic = cleanedBic + PRIMARY_OFFICE_BRANCH_CODE;
        }
        this.normalizedBic = cleanedBic;
    }

    public static boolean isValid(String bic) {
        return bic != null && Bic.isWellFormatted(bic) && Bic.hasKnownCountryCode(bic);
    }

    private static boolean isWellFormatted(String s) {
        return BIC_PATTERN.matcher(s).matches();
    }

    private static boolean hasKnownCountryCode(String s) {
        return IsoCountry.fromAlpha2Code(s.substring(4, 6)).isPresent();
    }

    public String getInstitutionCode() {
        return this.normalizedBic.substring(0, 4);
    }

    public String getCountryCode() {
        return this.normalizedBic.substring(4, 6);
    }

    public String getLocationCode() {
        return this.normalizedBic.substring(6, 8);
    }

    public String getBranchCode() {
        return this.normalizedBic.substring(8, 11);
    }

    public boolean isTestBic() {
        return this.normalizedBic.charAt(7) == '0';
    }

    public boolean isLiveBic() {
        return !this.isTestBic();
    }

    public Bic asTestBic() {
        if (this.isTestBic()) {
            return this;
        }
        StringBuilder testBicBuilder = new StringBuilder(this.normalizedBic);
        testBicBuilder.setCharAt(7, '0');
        return new Bic(testBicBuilder.toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.normalizedBic.equals(((Bic)o).normalizedBic);
    }

    public int hashCode() {
        return 31 * this.normalizedBic.hashCode();
    }

    public String toString() {
        return this.normalizedBic;
    }
}

