/*
 * Decompiled with CFR 0.152.
 */
package fr.marcwrobel.jbanking.calendar;

import fr.marcwrobel.jbanking.calendar.Holiday;
import fr.marcwrobel.jbanking.calendar.ShiftingStrategy;
import java.time.LocalDate;
import java.util.Objects;

public final class ShiftedHoliday
implements Holiday {
    private final Holiday base;
    private final ShiftingStrategy strategy;

    public ShiftedHoliday(Holiday base, ShiftingStrategy strategy) {
        this.base = Objects.requireNonNull(base);
        this.strategy = Objects.requireNonNull(strategy);
    }

    @Override
    public boolean check(LocalDate date) {
        for (LocalDate candidate : this.strategy.unshift(date)) {
            if (!this.base.check(candidate)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShiftedHoliday that = (ShiftedHoliday)o;
        return this.base.equals(that.base) && this.strategy == that.strategy;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.base, this.strategy});
    }

    public String toString() {
        return "ShiftedHoliday{base=" + this.base + ", strategy=" + (Object)((Object)this.strategy) + '}';
    }
}

