/*
 * Decompiled with CFR 0.152.
 */
package fr.marcwrobel.jbanking.creditor;

import fr.marcwrobel.jbanking.IsoCountry;
import fr.marcwrobel.jbanking.creditor.CreditorIdentifierFormatException;
import fr.marcwrobel.jbanking.iban.IbanCheckDigit;
import java.io.Serializable;
import java.util.Optional;
import java.util.regex.Pattern;

public class CreditorIdentifier
implements Serializable {
    private static final long serialVersionUID = 0L;
    private static final String BASIC_REGEX = "[A-Za-z]{2}[0-9]{2}[A-Za-z0-9]{3}[A-Za-z0-9]+";
    private static final Pattern BASIC_PATTERN = Pattern.compile("[A-Za-z]{2}[0-9]{2}[A-Za-z0-9]{3}[A-Za-z0-9]+");
    private static final int COUNTRY_CODE_INDEX = 0;
    private static final int COUNTRY_CODE_LENGTH = 2;
    private static final int CHECK_DIGITS_INDEX = 2;
    private static final int CHECK_DIGITS_LENGTH = 2;
    private static final int CREDITOR_BUSINESS_CODE_INDEX = 4;
    private static final int CREDITOR_BUSINESS_CODE_LENGTH = 3;
    private static final int CREDITOR_NATIONAL_ID_INDEX = 7;
    private final String creditorId;

    public CreditorIdentifier(IsoCountry country, String businessCode, String creditorNationalId) {
        if (country == null) {
            throw new IllegalArgumentException("the country argument cannot be null");
        }
        if (businessCode == null) {
            throw new IllegalArgumentException("the business code argument cannot be null");
        }
        if (creditorNationalId == null) {
            throw new IllegalArgumentException("the creditorNationalId argument cannot be null");
        }
        String normalizedNationalId = CreditorIdentifier.normalize(creditorNationalId);
        String normalizedCreditorId = country.getAlpha2Code() + "00" + normalizedNationalId;
        if (CreditorIdentifier.isNotWellFormatted(normalizedCreditorId)) {
            throw CreditorIdentifierFormatException.forNotProperlyFormattedInput(creditorNationalId);
        }
        String checkDigits = IbanCheckDigit.INSTANCE.calculate(normalizedCreditorId);
        this.creditorId = country.getAlpha2Code() + checkDigits + businessCode + normalizedNationalId;
    }

    public CreditorIdentifier(String creditorId) {
        if (creditorId == null) {
            throw new IllegalArgumentException("the creditor identifier argument cannot be null");
        }
        String normalizedCreditorId = CreditorIdentifier.normalize(creditorId);
        if (CreditorIdentifier.isNotWellFormatted(normalizedCreditorId)) {
            throw CreditorIdentifierFormatException.forNotProperlyFormattedInput(normalizedCreditorId);
        }
        Optional<IsoCountry> country = CreditorIdentifier.findCountryFor(normalizedCreditorId);
        if (!country.isPresent()) {
            throw CreditorIdentifierFormatException.forUnknownCountry(creditorId);
        }
        String normalizedCreditorIdWithoutBusinessCode = CreditorIdentifier.removeBusinessCode(normalizedCreditorId);
        if (!IbanCheckDigit.INSTANCE.validate(normalizedCreditorIdWithoutBusinessCode)) {
            throw CreditorIdentifierFormatException.forIncorrectCheckDigits(creditorId);
        }
        this.creditorId = normalizedCreditorId;
    }

    private static String normalize(String creditorIdentifier) {
        return creditorIdentifier.replaceAll("\\s+", "").toUpperCase();
    }

    private static boolean isNotWellFormatted(String creditorIdentifier) {
        return !BASIC_PATTERN.matcher(creditorIdentifier).matches();
    }

    private static Optional<IsoCountry> findCountryFor(String creditorIdentifier) {
        return IsoCountry.fromAlpha2Code(creditorIdentifier.substring(0, 2));
    }

    private static String removeBusinessCode(String creditorIdentifier) {
        return creditorIdentifier.substring(0, 4) + creditorIdentifier.substring(7);
    }

    public static boolean isValid(String creditorIdentifier) {
        if (creditorIdentifier == null) {
            return false;
        }
        String normalizedCreditorId = CreditorIdentifier.normalize(creditorIdentifier);
        if (CreditorIdentifier.isNotWellFormatted(normalizedCreditorId)) {
            return false;
        }
        Optional<IsoCountry> country = CreditorIdentifier.findCountryFor(normalizedCreditorId);
        if (!country.isPresent()) {
            return false;
        }
        String normalizedCreditorIdWithoutBusinessCode = CreditorIdentifier.removeBusinessCode(normalizedCreditorId);
        return IbanCheckDigit.INSTANCE.validate(normalizedCreditorIdWithoutBusinessCode);
    }

    public String getCountryCode() {
        return this.creditorId.substring(0, 2);
    }

    public String getCheckDigit() {
        return this.creditorId.substring(2, 4);
    }

    public String getBusinessCode() {
        return this.creditorId.substring(4, 7);
    }

    public String getNationalIdentifier() {
        return this.creditorId.substring(7);
    }

    public String toString() {
        return this.creditorId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreditorIdentifier other = (CreditorIdentifier)o;
        return this.creditorId.equals(other.creditorId);
    }

    public int hashCode() {
        return this.creditorId.hashCode();
    }
}

