/*
 * Decompiled with CFR 0.152.
 */
package fr.marcwrobel.jbanking.iban;

import fr.marcwrobel.jbanking.IsoCountry;
import fr.marcwrobel.jbanking.iban.BbanStructure;
import fr.marcwrobel.jbanking.iban.IbanCheckDigit;
import fr.marcwrobel.jbanking.iban.IbanFormatException;
import java.io.Serializable;
import java.util.Optional;
import java.util.regex.Pattern;

public final class Iban
implements Serializable {
    private static final long serialVersionUID = 0L;
    private static final String BASIC_REGEX = "[A-Za-z]{2}[0-9]{2}[A-Za-z0-9]+";
    private static final Pattern BASIC_PATTERN = Pattern.compile("[A-Za-z]{2}[0-9]{2}[A-Za-z0-9]+");
    private static final int COUNTRY_CODE_INDEX = 0;
    private static final int COUNTRY_CODE_LENGTH = 2;
    private static final int CHECK_DIGITS_INDEX = 2;
    private static final int CHECK_DIGITS_LENGTH = 2;
    private static final int BBAN_INDEX = 4;
    private static final int GROUP_SIZE_FOR_PRINTABLE_IBAN = 4;
    private final String normalizedIban;

    public Iban(IsoCountry country, String bban) {
        if (country == null) {
            throw new IllegalArgumentException("the country argument cannot be null");
        }
        if (bban == null) {
            throw new IllegalArgumentException("the bban argument cannot be null");
        }
        String normalizedBban = Iban.normalize(bban);
        String normalized = country.getAlpha2Code() + "00" + normalizedBban;
        Optional<BbanStructure> oBbanStructure = BbanStructure.forCountry(country);
        if (!oBbanStructure.isPresent()) {
            throw IbanFormatException.forNotSupportedCountry(bban, country);
        }
        BbanStructure bbanStructure = oBbanStructure.get();
        if (!bbanStructure.isBbanValid(normalizedBban)) {
            throw IbanFormatException.forInvalidBbanStructure(bban, bbanStructure);
        }
        String checkDigits = IbanCheckDigit.INSTANCE.calculate(normalized);
        this.normalizedIban = country.getAlpha2Code() + checkDigits + normalizedBban;
    }

    public Iban(String iban) {
        if (iban == null) {
            throw new IllegalArgumentException("the iban argument cannot be null");
        }
        String normalized = Iban.normalize(iban);
        if (Iban.isNotWellFormatted(normalized)) {
            throw IbanFormatException.forNotProperlyFormattedInput(normalized);
        }
        Optional<IsoCountry> country = Iban.findCountryFor(normalized);
        if (!country.isPresent()) {
            throw IbanFormatException.forUnknownCountry(iban);
        }
        Optional<BbanStructure> oBbanStructure = BbanStructure.forCountry(country.get());
        if (!oBbanStructure.isPresent()) {
            throw IbanFormatException.forNotSupportedCountry(iban, country.get());
        }
        BbanStructure bbanStructure = oBbanStructure.get();
        if (!bbanStructure.isBbanValid(normalized.substring(4))) {
            throw IbanFormatException.forInvalidBbanStructure(iban, bbanStructure);
        }
        if (!IbanCheckDigit.INSTANCE.validate(normalized)) {
            throw IbanFormatException.forIncorrectCheckDigits(iban);
        }
        this.normalizedIban = normalized;
    }

    public static boolean isValid(String iban) {
        if (iban == null) {
            return false;
        }
        String normalized = Iban.normalize(iban);
        if (Iban.isNotWellFormatted(normalized)) {
            return false;
        }
        Optional<IsoCountry> country = Iban.findCountryFor(normalized);
        if (!country.isPresent()) {
            return false;
        }
        Optional<BbanStructure> oBbanStructure = BbanStructure.forCountry(country.get());
        if (!oBbanStructure.isPresent()) {
            return false;
        }
        BbanStructure bbanStructure = oBbanStructure.get();
        if (!bbanStructure.isBbanValid(normalized.substring(4))) {
            return false;
        }
        return IbanCheckDigit.INSTANCE.validate(normalized);
    }

    private static String normalize(String iban) {
        return iban.replaceAll("\\s+", "").toUpperCase();
    }

    private static boolean isNotWellFormatted(String s) {
        return !BASIC_PATTERN.matcher(s).matches();
    }

    private static Optional<IsoCountry> findCountryFor(String s) {
        return IsoCountry.fromAlpha2Code(s.substring(0, 2));
    }

    public String getCountryCode() {
        return this.normalizedIban.substring(0, 2);
    }

    public String getCheckDigit() {
        return this.normalizedIban.substring(2, 4);
    }

    public String getBban() {
        return this.normalizedIban.substring(4);
    }

    public String toPrintableString() {
        StringBuilder printableIban = new StringBuilder(this.normalizedIban);
        int length = this.normalizedIban.length();
        for (int i = 0; i < length / 4; ++i) {
            printableIban.insert((i + 1) * 4 + i, ' ');
        }
        return printableIban.toString();
    }

    public String toString() {
        return this.normalizedIban;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Iban other = (Iban)o;
        return this.normalizedIban.equals(other.normalizedIban);
    }

    public int hashCode() {
        return 29 * this.normalizedIban.hashCode();
    }
}

