/*
 * Decompiled with CFR 0.152.
 */
package fr.marcwrobel.jbanking.swift;

import fr.marcwrobel.jbanking.swift.SwiftPatternSyntaxException;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SwiftPattern
implements Serializable {
    private static final long serialVersionUID = 0L;
    static final char DIGITS_CHARACTER = 'n';
    static final char UPPER_CASE_LETTERS_CHARACTER = 'a';
    static final char UPPER_AND_LOWER_CASE_ALPHANUMERICS_CHARACTER = 'c';
    static final char SPACES_CHARACTER = 'e';
    private static final String DIGITS_CLASS = "[0-9]";
    private static final String UPPER_CASE_LETTERS_CLASS = "[A-Z]";
    private static final String UPPER_AND_LOWER_CASE_ALPHANUMERICS_CLASS = "[A-Za-z0-9]";
    private static final String SPACES_CLASS = "[ ]";
    private static final String GROUP_REGEX = "[0-9]{1,3}!?[ance]";
    private static final Pattern SWIFT_FORMAT_PATTERN = Pattern.compile("^([0-9]{1,3}!?[ance]){1,1000}$");
    private static final Pattern SWIFT_FORMAT_GROUPS_PATTERN = Pattern.compile("[0-9]{1,3}!?[ance]");
    private final String expression;
    private final Pattern equivalentJavaPattern;

    private SwiftPattern(String expression, Pattern equivalentJavaPattern) {
        this.expression = expression;
        this.equivalentJavaPattern = equivalentJavaPattern;
    }

    public static SwiftPattern compile(String expression) {
        if (expression == null) {
            throw new IllegalArgumentException("the given parameter expression cannot be null");
        }
        if (!SWIFT_FORMAT_PATTERN.matcher(expression).matches()) {
            throw new SwiftPatternSyntaxException(expression);
        }
        return new SwiftPattern(expression, Pattern.compile(SwiftPattern.toRegex(expression)));
    }

    private static String toRegex(String expression) {
        Matcher matcher = SWIFT_FORMAT_GROUPS_PATTERN.matcher(expression);
        StringBuilder regex = new StringBuilder("^");
        while (matcher.find()) {
            regex.append(SwiftPattern.transform(matcher.group()));
        }
        regex.append("$");
        return regex.toString();
    }

    private static String transform(String simpleExpression) {
        String charactersRegex;
        int length = simpleExpression.length();
        char qualifier = simpleExpression.charAt(length - 1);
        switch (qualifier) {
            case 'n': {
                charactersRegex = DIGITS_CLASS;
                break;
            }
            case 'a': {
                charactersRegex = UPPER_CASE_LETTERS_CLASS;
                break;
            }
            case 'c': {
                charactersRegex = UPPER_AND_LOWER_CASE_ALPHANUMERICS_CLASS;
                break;
            }
            case 'e': {
                charactersRegex = SPACES_CLASS;
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal qualifier '" + qualifier + "' in expression '" + simpleExpression + "'");
            }
        }
        boolean strict = simpleExpression.charAt(simpleExpression.length() - 2) == '!';
        String maxOccurrences = simpleExpression.substring(0, length - (strict ? 2 : 1));
        return charactersRegex + "{" + (strict ? "" : "1,") + maxOccurrences + "}";
    }

    public Matcher matcher(CharSequence input) {
        return this.equivalentJavaPattern.matcher(input);
    }

    public String getExpression() {
        return this.expression;
    }

    public Pattern getEquivalentJavaPattern() {
        return this.equivalentJavaPattern;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SwiftPattern that = (SwiftPattern)o;
        return this.expression.equals(that.expression);
    }

    public int hashCode() {
        return 13 + this.expression.hashCode();
    }

    public String toString() {
        return this.expression + "{regex=" + this.equivalentJavaPattern + "}";
    }
}

