/*
 * Decompiled with CFR 0.152.
 */
package fr.marcwrobel.jbanking.calendar;

import fr.marcwrobel.jbanking.calendar.BridgedHoliday;
import fr.marcwrobel.jbanking.calendar.Calendar;
import fr.marcwrobel.jbanking.calendar.ConfigurableCalendar;
import fr.marcwrobel.jbanking.calendar.DayOfWeekHoliday;
import fr.marcwrobel.jbanking.calendar.DayOfWeekInMonthHoliday;
import fr.marcwrobel.jbanking.calendar.FixedHoliday;
import fr.marcwrobel.jbanking.calendar.Holiday;
import fr.marcwrobel.jbanking.calendar.Holidays;
import fr.marcwrobel.jbanking.calendar.MonthDayHoliday;
import fr.marcwrobel.jbanking.calendar.MovedHoliday;
import fr.marcwrobel.jbanking.calendar.ShiftedHoliday;
import fr.marcwrobel.jbanking.calendar.ShiftingStrategy;
import fr.marcwrobel.jbanking.calendar.SuppressedHoliday;
import fr.marcwrobel.jbanking.calendar.YearRangeHoliday;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.Month;
import java.time.MonthDay;
import java.time.temporal.ValueRange;
import java.util.List;
import java.util.Set;

public enum FinancialCalendars implements Calendar
{
    NO_HOLIDAYS(new ConfigurableCalendar(new Holiday[0])),
    SATURDAY_SUNDAY(new ConfigurableCalendar(DayOfWeekHoliday.SATURDAY, DayOfWeekHoliday.SUNDAY)),
    FRIDAY_SATURDAY(new ConfigurableCalendar(DayOfWeekHoliday.FRIDAY, DayOfWeekHoliday.SATURDAY)),
    FRANKFURT(new ConfigurableCalendar(DayOfWeekHoliday.SATURDAY, DayOfWeekHoliday.SUNDAY, Holidays.NEW_YEAR_DAY, Holidays.GOOD_FRIDAY, Holidays.EASTER_MONDAY, Holidays.INTERNATIONAL_WORKERS_DAY, Holidays.ASCENSION_DAY, Holidays.PENTECOST_MONDAY, Holidays.FEAST_OF_CORPUS_CHRISTI, new MonthDayHoliday(Month.OCTOBER, 3), new YearRangeHoliday(new MonthDayHoliday(Month.OCTOBER, 31), 2017L, 2017L), Holidays.CHRISTMAS_EVE, Holidays.CHRISTMAS_DAY, Holidays.SAINT_STEPHENS_DAY, Holidays.NEW_YEAR_EVE)),
    LONDON(new ConfigurableCalendar(DayOfWeekHoliday.SATURDAY, DayOfWeekHoliday.SUNDAY, new ShiftedHoliday(Holidays.NEW_YEAR_DAY, ShiftingStrategy.WEEKEND_TO_MONDAY), Holidays.GOOD_FRIDAY, Holidays.EASTER_MONDAY, new MovedHoliday(Holidays.MAY_DAY, FinancialCalendars.d(2020, 5, 4), FinancialCalendars.d(2020, 5, 8)), new SuppressedHoliday((Holiday)new DayOfWeekInMonthHoliday(-1, DayOfWeek.MONDAY, Month.MAY), 2002, 2012, 2022), new DayOfWeekInMonthHoliday(-1, DayOfWeek.MONDAY, Month.AUGUST), new ShiftedHoliday(Holidays.CHRISTMAS_DAY, ShiftingStrategy.PLUS_TWO_DAYS), new ShiftedHoliday(Holidays.BOXING_DAY, ShiftingStrategy.PLUS_TWO_DAYS), new FixedHoliday(FinancialCalendars.d(2002, 6, 3), FinancialCalendars.d(2002, 6, 4)), new FixedHoliday(FinancialCalendars.d(2011, 4, 29)), new FixedHoliday(FinancialCalendars.d(2012, 6, 4), FinancialCalendars.d(2012, 6, 5)), new FixedHoliday(FinancialCalendars.d(2022, 6, 2), FinancialCalendars.d(2022, 6, 3)))),
    NEW_YORK_FED(new ConfigurableCalendar(DayOfWeekHoliday.SATURDAY, DayOfWeekHoliday.SUNDAY, new ShiftedHoliday(Holidays.NEW_YEAR_DAY, ShiftingStrategy.SUNDAY_TO_MONDAY), new DayOfWeekInMonthHoliday(3, DayOfWeek.MONDAY, Month.JANUARY), new DayOfWeekInMonthHoliday(3, DayOfWeek.MONDAY, Month.FEBRUARY), new DayOfWeekInMonthHoliday(-1, DayOfWeek.MONDAY, Month.MAY), new ShiftedHoliday(new MonthDayHoliday(Month.JULY, 4), ShiftingStrategy.SUNDAY_TO_MONDAY), new DayOfWeekInMonthHoliday(1, DayOfWeek.MONDAY, Month.SEPTEMBER), new DayOfWeekInMonthHoliday(2, DayOfWeek.MONDAY, Month.OCTOBER), new ShiftedHoliday(Holidays.ARMISTICE_DAY, ShiftingStrategy.SUNDAY_TO_MONDAY), new DayOfWeekInMonthHoliday(4, DayOfWeek.THURSDAY, Month.NOVEMBER), new ShiftedHoliday(Holidays.CHRISTMAS_DAY, ShiftingStrategy.SUNDAY_TO_MONDAY))),
    NEW_YORK_SOCK_EXCHANGE(new ConfigurableCalendar(DayOfWeekHoliday.SATURDAY, DayOfWeekHoliday.SUNDAY, new ShiftedHoliday(Holidays.NEW_YEAR_DAY, ShiftingStrategy.SUNDAY_TO_MONDAY), new DayOfWeekInMonthHoliday(3, DayOfWeek.MONDAY, Month.JANUARY), new DayOfWeekInMonthHoliday(3, DayOfWeek.MONDAY, Month.FEBRUARY), Holidays.GOOD_FRIDAY, new DayOfWeekInMonthHoliday(-1, DayOfWeek.MONDAY, Month.MAY), new ShiftedHoliday(new MonthDayHoliday(Month.JULY, 4), ShiftingStrategy.CLOSEST_WEEKDAY), new DayOfWeekInMonthHoliday(1, DayOfWeek.MONDAY, Month.SEPTEMBER), new DayOfWeekInMonthHoliday(4, DayOfWeek.THURSDAY, Month.NOVEMBER), new ShiftedHoliday(Holidays.CHRISTMAS_DAY, ShiftingStrategy.CLOSEST_WEEKDAY), new FixedHoliday(FinancialCalendars.d(2001, 9, 11), FinancialCalendars.d(2001, 9, 12), FinancialCalendars.d(2001, 9, 13), FinancialCalendars.d(2001, 9, 14)), new FixedHoliday(FinancialCalendars.d(2004, 6, 11)), new FixedHoliday(FinancialCalendars.d(2007, 1, 2)), new FixedHoliday(FinancialCalendars.d(2012, 10, 30)), new FixedHoliday(FinancialCalendars.d(2018, 12, 5)))),
    PARIS(new ConfigurableCalendar(DayOfWeekHoliday.SATURDAY, DayOfWeekHoliday.SUNDAY, Holidays.NEW_YEAR_DAY, Holidays.EASTER_MONDAY, Holidays.GOOD_FRIDAY, Holidays.INTERNATIONAL_WORKERS_DAY, Holidays.VICTORY_IN_EUROPE_DAY, Holidays.ASCENSION_DAY, new SuppressedHoliday((Holiday)Holidays.PENTECOST_MONDAY, 2005, 2006, 2007), new MonthDayHoliday(Month.JULY, 14), Holidays.ASSUMPTION_OF_MARY, Holidays.ALL_SAINTS_DAY, Holidays.ARMISTICE_DAY, Holidays.CHRISTMAS_DAY, Holidays.SAINT_STEPHENS_DAY)),
    SYDNEY(new ConfigurableCalendar(DayOfWeekHoliday.SATURDAY, DayOfWeekHoliday.SUNDAY, new ShiftedHoliday(Holidays.NEW_YEAR_DAY, ShiftingStrategy.WEEKEND_TO_MONDAY), new ShiftedHoliday(new MonthDayHoliday(Month.JANUARY, 26), ShiftingStrategy.WEEKEND_TO_MONDAY), Holidays.GOOD_FRIDAY, Holidays.EASTER_MONDAY, new MonthDayHoliday(Month.APRIL, 25), new DayOfWeekInMonthHoliday(2, DayOfWeek.MONDAY, Month.JUNE), new DayOfWeekInMonthHoliday(1, DayOfWeek.MONDAY, Month.AUGUST), new DayOfWeekInMonthHoliday(1, DayOfWeek.MONDAY, Month.OCTOBER), new ShiftedHoliday(Holidays.CHRISTMAS_DAY, ShiftingStrategy.PLUS_TWO_DAYS), new ShiftedHoliday(Holidays.BOXING_DAY, ShiftingStrategy.PLUS_TWO_DAYS))),
    TARGET(new ConfigurableCalendar(DayOfWeekHoliday.SATURDAY, DayOfWeekHoliday.SUNDAY, Holidays.NEW_YEAR_DAY, Holidays.GOOD_FRIDAY, Holidays.EASTER_MONDAY, Holidays.INTERNATIONAL_WORKERS_DAY, Holidays.CHRISTMAS_DAY, Holidays.SAINT_STEPHENS_DAY, new FixedHoliday(FinancialCalendars.d(2001, 12, 31)))),
    TOKYO(new ConfigurableCalendar(DayOfWeekHoliday.SATURDAY, DayOfWeekHoliday.SUNDAY, new ShiftedHoliday(Holidays.NEW_YEAR_DAY, ShiftingStrategy.SUNDAY_TO_MONDAY), new MonthDayHoliday(Month.JANUARY, 2), new MonthDayHoliday(Month.JANUARY, 3), new DayOfWeekInMonthHoliday(2, DayOfWeek.MONDAY, Month.JANUARY), new ShiftedHoliday(new MonthDayHoliday(Month.FEBRUARY, 11), ShiftingStrategy.SUNDAY_TO_MONDAY), new ShiftedHoliday(new MovedHoliday(MonthDay.of(Month.MARCH, 21), MonthDay.of(Month.MARCH, 20), 2000, 2001, 2004, 2005, 2008, 2009, 2012, 2013, 2016, 2017, 2020, 2021, 2024, 2025, 2026, 2028, 2029, 2030), ShiftingStrategy.SUNDAY_TO_MONDAY), new ShiftedHoliday(new MonthDayHoliday(Month.APRIL, 29), ShiftingStrategy.SUNDAY_TO_MONDAY), new YearRangeHoliday(new ShiftedHoliday(new MonthDayHoliday(Month.MAY, 3), ShiftingStrategy.SUNDAY_TO_MONDAY), 1950L, 2006L), new YearRangeHoliday(new ShiftedHoliday(new MonthDayHoliday(Month.MAY, 3), ShiftingStrategy.SUNDAY_TO_WEDNESDAY), 2007L, 2999L), new YearRangeHoliday(new ShiftedHoliday(new MonthDayHoliday(Month.MAY, 4), ShiftingStrategy.SUNDAY_TO_MONDAY), 1950L, 2006L), new YearRangeHoliday(new ShiftedHoliday(new MonthDayHoliday(Month.MAY, 4), ShiftingStrategy.SUNDAY_TO_TUESDAY), 2007L, 2999L), new ShiftedHoliday(new MonthDayHoliday(Month.MAY, 5), ShiftingStrategy.SUNDAY_TO_MONDAY), new YearRangeHoliday(new ShiftedHoliday(new MonthDayHoliday(Month.JULY, 20), ShiftingStrategy.SUNDAY_TO_MONDAY), 1950L, 2003L), new YearRangeHoliday(new MovedHoliday(new DayOfWeekInMonthHoliday(3, DayOfWeek.MONDAY, Month.JULY), FinancialCalendars.d(2020, 7, 20), FinancialCalendars.d(2020, 7, 23), FinancialCalendars.d(2021, 7, 19), FinancialCalendars.d(2021, 7, 22)), 2003L, 2999L), new YearRangeHoliday(new MovedHoliday(new ShiftedHoliday(new MonthDayHoliday(Month.AUGUST, 11), ShiftingStrategy.SUNDAY_TO_MONDAY), FinancialCalendars.d(2020, 8, 11), FinancialCalendars.d(2020, 8, 10), FinancialCalendars.d(2021, 8, 11), FinancialCalendars.d(2021, 8, 9)), 2016L, 2999L), new YearRangeHoliday(new ShiftedHoliday(new MonthDayHoliday(Month.SEPTEMBER, 15), ShiftingStrategy.SUNDAY_TO_MONDAY), 1966L, 2002L), new BridgedHoliday(new YearRangeHoliday(new DayOfWeekInMonthHoliday(3, DayOfWeek.MONDAY, Month.SEPTEMBER), ValueRange.of(2003L, 2999L)), new ShiftedHoliday(new MovedHoliday(MonthDay.of(Month.SEPTEMBER, 23), MonthDay.of(Month.SEPTEMBER, 22), 2012, 2016, 2020, 2024, 2028), ShiftingStrategy.SUNDAY_TO_MONDAY)), new MovedHoliday(new DayOfWeekInMonthHoliday(2, DayOfWeek.MONDAY, Month.OCTOBER), FinancialCalendars.d(2020, 10, 12), FinancialCalendars.d(2020, 7, 24), FinancialCalendars.d(2021, 10, 11), FinancialCalendars.d(2021, 7, 23)), new ShiftedHoliday(new MonthDayHoliday(Month.NOVEMBER, 3), ShiftingStrategy.SUNDAY_TO_MONDAY), new ShiftedHoliday(new MonthDayHoliday(Month.NOVEMBER, 23), ShiftingStrategy.SUNDAY_TO_MONDAY), new ShiftedHoliday(new MonthDayHoliday(Month.DECEMBER, 31), ShiftingStrategy.SUNDAY_TO_MONDAY), new YearRangeHoliday(new ShiftedHoliday(new MonthDayHoliday(Month.DECEMBER, 23), ShiftingStrategy.SUNDAY_TO_MONDAY), 1990L, 2018L), new FixedHoliday(FinancialCalendars.d(2019, 4, 30), FinancialCalendars.d(2019, 5, 1), FinancialCalendars.d(2019, 5, 2), FinancialCalendars.d(2019, 10, 22)), new YearRangeHoliday(new ShiftedHoliday(new MonthDayHoliday(Month.FEBRUARY, 23), ShiftingStrategy.SUNDAY_TO_MONDAY), 2020L, 2999L)));

    private final ConfigurableCalendar calendar;

    private static LocalDate d(int year, int month, int day) {
        return LocalDate.of(year, month, day);
    }

    private FinancialCalendars(ConfigurableCalendar calendar) {
        this.calendar = calendar;
    }

    @Override
    public boolean isHoliday(LocalDate date) {
        return this.calendar.isHoliday(date);
    }

    @Override
    public Set<Holiday> getHolidaysFor(LocalDate date) {
        return this.calendar.getHolidaysFor(date);
    }

    @Override
    public boolean isBusinessDay(LocalDate date) {
        return this.calendar.isBusinessDay(date);
    }

    @Override
    public LocalDate previous(LocalDate date) {
        return this.calendar.previous(date);
    }

    @Override
    public LocalDate next(LocalDate date) {
        return this.calendar.next(date);
    }

    @Override
    public List<LocalDate> holidaysWithin(LocalDate from, LocalDate to) {
        return this.calendar.holidaysWithin(from, to);
    }

    @Override
    public List<LocalDate> businessDaysWithin(LocalDate from, LocalDate to) {
        return this.calendar.businessDaysWithin(from, to);
    }
}

