/*
 * Decompiled with CFR 0.152.
 */
package fr.marcwrobel.jbanking.iban;

import fr.marcwrobel.jbanking.IsoCountry;
import fr.marcwrobel.jbanking.swift.SwiftPattern;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

enum BbanStructure {
    AD(IsoCountry.AD, "4!n4!n12!c", new IsoCountry[0]),
    AL(IsoCountry.AL, "8!n16!c", new IsoCountry[0]),
    AT(IsoCountry.AT, "5!n11!n", new IsoCountry[0]),
    AZ(IsoCountry.AZ, "4!a20!c", new IsoCountry[0]),
    BH(IsoCountry.BH, "4!a14!c", new IsoCountry[0]),
    BY(IsoCountry.BY, "4!c4!n16!c", new IsoCountry[0]),
    BE(IsoCountry.BE, "3!n7!n2!n", new IsoCountry[0]),
    BA(IsoCountry.BA, "3!n3!n8!n2!n", new IsoCountry[0]),
    BR(IsoCountry.BR, "8!n5!n10!n1!a1!c", new IsoCountry[0]),
    VG(IsoCountry.VG, "4!a16!n", new IsoCountry[0]),
    BG(IsoCountry.BG, "4!a4!n2!n8!c", new IsoCountry[0]),
    CR(IsoCountry.CR, "4!n14!n", new IsoCountry[0]),
    HR(IsoCountry.HR, "7!n10!n", new IsoCountry[0]),
    CY(IsoCountry.CY, "3!n5!n16!c", new IsoCountry[0]),
    CZ(IsoCountry.CZ, "4!n6!n10!n", new IsoCountry[0]),
    DK(IsoCountry.DK, "4!n9!n1!n", new IsoCountry[0]),
    SV(IsoCountry.SV, "4!a20!n", new IsoCountry[0]),
    FO(IsoCountry.FO, "4!n9!n1!n", new IsoCountry[0]),
    GL(IsoCountry.GL, "4!n9!n1!n", new IsoCountry[0]),
    DO(IsoCountry.DO, "4!c20!n", new IsoCountry[0]),
    EE(IsoCountry.EE, "2!n2!n11!n1!n", new IsoCountry[0]),
    EG(IsoCountry.EG, "4!n4!n17!n", new IsoCountry[0]),
    FI(IsoCountry.FI, "3!n11!n", IsoCountry.AX),
    FR(IsoCountry.FR, "5!n5!n11!c2!n", IsoCountry.GF, IsoCountry.GP, IsoCountry.MQ, IsoCountry.RE, IsoCountry.PF, IsoCountry.TF, IsoCountry.YT, IsoCountry.NC, IsoCountry.BL, IsoCountry.MF, IsoCountry.PM, IsoCountry.WF),
    GE(IsoCountry.GE, "2!a16!n", new IsoCountry[0]),
    DE(IsoCountry.DE, "8!n10!n", new IsoCountry[0]),
    GI(IsoCountry.GI, "4!a15!c", new IsoCountry[0]),
    GR(IsoCountry.GR, "3!n4!n16!c", new IsoCountry[0]),
    GT(IsoCountry.GT, "4!c20!c", new IsoCountry[0]),
    HU(IsoCountry.HU, "3!n4!n1!n15!n1!n", new IsoCountry[0]),
    IS(IsoCountry.IS, "4!n2!n6!n10!n", new IsoCountry[0]),
    IE(IsoCountry.IE, "4!a6!n8!n", new IsoCountry[0]),
    IL(IsoCountry.IL, "3!n3!n13!n", new IsoCountry[0]),
    IQ(IsoCountry.IQ, "4!a3!n12!n", new IsoCountry[0]),
    IT(IsoCountry.IT, "1!a5!n5!n12!c", new IsoCountry[0]),
    JO(IsoCountry.JO, "4!a4!n18!c", new IsoCountry[0]),
    KZ(IsoCountry.KZ, "3!n13!c", new IsoCountry[0]),
    XK(IsoCountry.XK, "4!n10!n2!n", new IsoCountry[0]),
    KW(IsoCountry.KW, "4!a22!c", new IsoCountry[0]),
    LV(IsoCountry.LV, "4!a13!c", new IsoCountry[0]),
    LB(IsoCountry.LB, "4!n20!c", new IsoCountry[0]),
    LI(IsoCountry.LI, "5!n12!c", new IsoCountry[0]),
    LT(IsoCountry.LT, "5!n11!n", new IsoCountry[0]),
    LU(IsoCountry.LU, "3!n13!c", new IsoCountry[0]),
    LY(IsoCountry.LY, "3!n3!n15!n", new IsoCountry[0]),
    MK(IsoCountry.MK, "3!n10!c2!n", new IsoCountry[0]),
    MT(IsoCountry.MT, "4!a5!n18!c", new IsoCountry[0]),
    MR(IsoCountry.MR, "5!n5!n11!n2!n", new IsoCountry[0]),
    MU(IsoCountry.MU, "4!a2!n2!n12!n3!n3!a", new IsoCountry[0]),
    MD(IsoCountry.MD, "2!c18!c", new IsoCountry[0]),
    MC(IsoCountry.MC, "5!n5!n11!c2!n", new IsoCountry[0]),
    ME(IsoCountry.ME, "3!n13!n2!n", new IsoCountry[0]),
    NL(IsoCountry.NL, "4!a10!n", new IsoCountry[0]),
    NO(IsoCountry.NO, "4!n6!n1!n", new IsoCountry[0]),
    PK(IsoCountry.PK, "4!a16!c", new IsoCountry[0]),
    PS(IsoCountry.PS, "4!a21!c", new IsoCountry[0]),
    PL(IsoCountry.PL, "8!n16!n", new IsoCountry[0]),
    PT(IsoCountry.PT, "4!n4!n11!n2!n", new IsoCountry[0]),
    QA(IsoCountry.QA, "4!a21!c", new IsoCountry[0]),
    RO(IsoCountry.RO, "4!a16!c", new IsoCountry[0]),
    LC(IsoCountry.LC, "4!a24!c", new IsoCountry[0]),
    SM(IsoCountry.SM, "1!a5!n5!n12!c", new IsoCountry[0]),
    ST(IsoCountry.ST, "8!n11!n2!n", new IsoCountry[0]),
    SA(IsoCountry.SA, "2!n18!c", new IsoCountry[0]),
    RS(IsoCountry.RS, "3!n13!n2!n", new IsoCountry[0]),
    SC(IsoCountry.SC, "4!a2!n2!n16!n3!a", new IsoCountry[0]),
    SK(IsoCountry.SK, "4!n6!n10!n", new IsoCountry[0]),
    SI(IsoCountry.SI, "5!n8!n2!n", new IsoCountry[0]),
    ES(IsoCountry.ES, "4!n4!n1!n1!n10!n", new IsoCountry[0]),
    SE(IsoCountry.SE, "3!n16!n1!n", new IsoCountry[0]),
    CH(IsoCountry.CH, "5!n12!c", new IsoCountry[0]),
    TL(IsoCountry.TL, "3!n14!n2!n", new IsoCountry[0]),
    TN(IsoCountry.TN, "2!n3!n13!n2!n", new IsoCountry[0]),
    TR(IsoCountry.TR, "5!n1!n16!c", new IsoCountry[0]),
    UA(IsoCountry.UA, "6!n19!c", new IsoCountry[0]),
    AE(IsoCountry.AE, "3!n16!n", new IsoCountry[0]),
    GB(IsoCountry.GB, "4!a6!n8!n", IsoCountry.IM, IsoCountry.JE, IsoCountry.GG),
    VA(IsoCountry.VA, "3!n15!n", new IsoCountry[0]);

    private static final Map<IsoCountry, BbanStructure> byCountry;
    private final IsoCountry country;
    private final SwiftPattern bbanPattern;
    private final Set<IsoCountry> subdivisions;

    private BbanStructure(IsoCountry country, String bbanSwiftExpression, IsoCountry ... subdivisions) {
        this.country = country;
        this.bbanPattern = SwiftPattern.compile(bbanSwiftExpression);
        this.subdivisions = Collections.unmodifiableSet(subdivisions.length > 0 ? EnumSet.copyOf(Arrays.asList(subdivisions)) : EnumSet.noneOf(IsoCountry.class));
    }

    public static Optional<BbanStructure> forCountry(IsoCountry country) {
        return Optional.ofNullable(byCountry.get((Object)country));
    }

    public boolean isBbanValid(String bban) {
        if (bban == null) {
            throw new IllegalArgumentException("the bban argument cannot be null");
        }
        return this.bbanPattern.matcher(bban).matches();
    }

    public IsoCountry getCountry() {
        return this.country;
    }

    public SwiftPattern getBbanPattern() {
        return this.bbanPattern;
    }

    public Set<IsoCountry> getSubdivisions() {
        return this.subdivisions;
    }

    static {
        byCountry = new EnumMap<IsoCountry, BbanStructure>(IsoCountry.class);
        for (BbanStructure structure : BbanStructure.values()) {
            byCountry.put(structure.getCountry(), structure);
            for (IsoCountry subDivision : structure.getSubdivisions()) {
                byCountry.put(subDivision, structure);
            }
        }
    }
}

