/*
 * Decompiled with CFR 0.152.
 */
package fr.marcwrobel.jbanking.iban;

import fr.marcwrobel.jbanking.IsoCountry;
import fr.marcwrobel.jbanking.iban.BbanStructure;

public final class IbanFormatException
extends RuntimeException {
    private static final long serialVersionUID = 0L;
    private final String inputString;

    private IbanFormatException(String input, String message) {
        super(message);
        this.inputString = input;
    }

    static IbanFormatException forNotProperlyFormattedInput(String input) {
        return new IbanFormatException(input, String.format("'%s' format is not appropriate for an IBAN", input));
    }

    static IbanFormatException forIncorrectCheckDigits(String input) {
        return new IbanFormatException(input, String.format("'%s' check digits are incorrect", input));
    }

    static IbanFormatException forUnknownCountry(String input) {
        return new IbanFormatException(input, String.format("'%s' country code is not an ISO 3166-1-alpha-2 code", input));
    }

    static IbanFormatException forNotSupportedCountry(String input, IsoCountry country) {
        return new IbanFormatException(input, String.format("'%s' country does not support IBAN", new Object[]{country}));
    }

    static IbanFormatException forInvalidBbanStructure(String input, BbanStructure bbanStructure) {
        return new IbanFormatException(input, String.format("'%s' BBAN structure is not valid against BBAN structure used in %s", new Object[]{input, bbanStructure.getCountry()}));
    }

    public String getInputString() {
        return this.inputString;
    }
}

