/*
 * Decompiled with CFR 0.152.
 */
package fr.marcwrobel.jbanking;

import fr.marcwrobel.jbanking.IsoCountry;
import fr.marcwrobel.jbanking.internal.LastVerification;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

@LastVerification(value="2022-04-20")
public enum IsoCurrency {
    XUA(965, null, Category.OTHER, new IsoCountry[0]),
    AFN(971, (Integer)2, IsoCountry.AF),
    DZD(12, (Integer)2, IsoCountry.DZ),
    ARS(32, (Integer)2, IsoCountry.AR),
    AMD(51, (Integer)2, IsoCountry.AM),
    AWG(533, (Integer)2, IsoCountry.AW),
    AUD(36, (Integer)2, IsoCountry.HM, IsoCountry.TV, IsoCountry.KI, IsoCountry.AU, IsoCountry.NF, IsoCountry.NR, IsoCountry.CX, IsoCountry.CC),
    AZN(944, (Integer)2, IsoCountry.AZ),
    BSD(44, (Integer)2, IsoCountry.BS),
    BHD(48, (Integer)3, IsoCountry.BH),
    THB(764, (Integer)2, IsoCountry.TH),
    PAB(590, (Integer)2, IsoCountry.PA),
    BBD(52, (Integer)2, IsoCountry.BB),
    BYN(933, (Integer)2, IsoCountry.BY),
    BZD(84, (Integer)2, IsoCountry.BZ),
    BMD(60, (Integer)2, IsoCountry.BM),
    VED(926, (Integer)2, IsoCountry.VE),
    VES(928, (Integer)2, IsoCountry.VE),
    BOB(68, (Integer)2, IsoCountry.BO),
    BRL(986, (Integer)2, IsoCountry.BR),
    BND(96, (Integer)2, IsoCountry.BN),
    BGN(975, (Integer)2, IsoCountry.BG),
    BIF(108, (Integer)0, IsoCountry.BI),
    CAD(124, (Integer)2, IsoCountry.CA),
    CVE(132, (Integer)2, IsoCountry.CV),
    KYD(136, (Integer)2, IsoCountry.KY),
    XOF(952, (Integer)0, IsoCountry.ML, IsoCountry.NE, IsoCountry.BJ, IsoCountry.TG, IsoCountry.BF, IsoCountry.SN, IsoCountry.CI, IsoCountry.GW),
    XAF(950, (Integer)0, IsoCountry.TD, IsoCountry.GA, IsoCountry.GQ, IsoCountry.CM, IsoCountry.CF, IsoCountry.CG),
    XPF(953, (Integer)0, IsoCountry.PF, IsoCountry.WF, IsoCountry.NC),
    CLP(152, (Integer)0, IsoCountry.CL),
    COP(170, (Integer)2, IsoCountry.CO),
    KMF(174, (Integer)0, IsoCountry.KM),
    CDF(976, (Integer)2, IsoCountry.CD),
    BAM(977, (Integer)2, IsoCountry.BA),
    NIO(558, (Integer)2, IsoCountry.NI),
    CRC(188, (Integer)2, IsoCountry.CR),
    HRK(191, (Integer)2, IsoCountry.HR),
    CUP(192, (Integer)2, IsoCountry.CU),
    CZK(203, (Integer)2, IsoCountry.CZ),
    GMD(270, (Integer)2, IsoCountry.GM),
    DKK(208, (Integer)2, IsoCountry.DK, IsoCountry.FO, IsoCountry.GL),
    MKD(807, (Integer)2, IsoCountry.MK),
    DJF(262, (Integer)0, IsoCountry.DJ),
    STN(930, (Integer)2, IsoCountry.ST),
    DOP(214, (Integer)2, IsoCountry.DO),
    VND(704, (Integer)0, IsoCountry.VN),
    XCD(951, (Integer)2, IsoCountry.DM, IsoCountry.VC, IsoCountry.MS, IsoCountry.AG, IsoCountry.LC, IsoCountry.AI, IsoCountry.KN, IsoCountry.GD),
    EGP(818, (Integer)2, IsoCountry.EG),
    SVC(222, (Integer)2, IsoCountry.SV),
    XBB(956, null, Category.BOND, new IsoCountry[0]),
    ETB(230, (Integer)2, IsoCountry.ET),
    XBD(958, null, Category.BOND, new IsoCountry[0]),
    XBC(957, null, Category.BOND, new IsoCountry[0]),
    XBA(955, null, Category.BOND, new IsoCountry[0]),
    EUR(978, (Integer)2, IsoCountry.PT, IsoCountry.RE, IsoCountry.LU, IsoCountry.IT, IsoCountry.SK, IsoCountry.MF, IsoCountry.AD, IsoCountry.YT, IsoCountry.BL, IsoCountry.AX, IsoCountry.GP, IsoCountry.GF, IsoCountry.PM, IsoCountry.DE, IsoCountry.BE, IsoCountry.ES, IsoCountry.SM, IsoCountry.FI, IsoCountry.MT, IsoCountry.VA, IsoCountry.MC, IsoCountry.GR, IsoCountry.MQ, IsoCountry.TF, IsoCountry.EE, IsoCountry.IE, IsoCountry.NL, IsoCountry.ME, IsoCountry.SI, IsoCountry.FR, IsoCountry.AT, IsoCountry.CY, IsoCountry.XK, IsoCountry.LV, IsoCountry.LT),
    FKP(238, (Integer)2, IsoCountry.FK),
    FJD(242, (Integer)2, IsoCountry.FJ),
    HUF(348, (Integer)2, IsoCountry.HU),
    GHS(936, (Integer)2, IsoCountry.GH),
    GIP(292, (Integer)2, IsoCountry.GI),
    XAU(959, null, Category.METAL, new IsoCountry[0]),
    HTG(332, (Integer)2, IsoCountry.HT),
    PYG(600, (Integer)0, IsoCountry.PY),
    GNF(324, (Integer)0, IsoCountry.GN),
    GYD(328, (Integer)2, IsoCountry.GY),
    HKD(344, (Integer)2, IsoCountry.HK),
    UAH(980, (Integer)2, IsoCountry.UA),
    ISK(352, (Integer)0, IsoCountry.IS),
    INR(356, (Integer)2, IsoCountry.IN, IsoCountry.BT),
    IRR(364, (Integer)2, IsoCountry.IR),
    IQD(368, (Integer)3, IsoCountry.IQ),
    JMD(388, (Integer)2, IsoCountry.JM),
    JOD(400, (Integer)3, IsoCountry.JO),
    KES(404, (Integer)2, IsoCountry.KE),
    PGK(598, (Integer)2, IsoCountry.PG),
    LAK(418, (Integer)2, IsoCountry.LA),
    KWD(414, (Integer)3, IsoCountry.KW),
    MWK(454, (Integer)2, IsoCountry.MW),
    AOA(973, (Integer)2, IsoCountry.AO),
    MMK(104, (Integer)2, IsoCountry.MM),
    GEL(981, (Integer)2, IsoCountry.GE),
    LBP(422, (Integer)2, IsoCountry.LB),
    ALL(8, (Integer)2, IsoCountry.AL),
    HNL(340, (Integer)2, IsoCountry.HN),
    SLE(925, (Integer)2, IsoCountry.SL),
    SLL(694, (Integer)2, IsoCountry.SL),
    LRD(430, (Integer)2, IsoCountry.LR),
    LYD(434, (Integer)3, IsoCountry.LY),
    SZL(748, (Integer)2, IsoCountry.SZ),
    LSL(426, (Integer)2, IsoCountry.LS),
    MGA(969, (Integer)2, IsoCountry.MG),
    MYR(458, (Integer)2, IsoCountry.MY),
    MUR(480, (Integer)2, IsoCountry.MU),
    MXN(484, (Integer)2, IsoCountry.MX),
    MXV(979, (Integer)2, Category.FUND, IsoCountry.MX),
    MDL(498, (Integer)2, IsoCountry.MD),
    MAD(504, (Integer)2, IsoCountry.EH, IsoCountry.MA),
    MZN(943, (Integer)2, IsoCountry.MZ),
    BOV(984, (Integer)2, Category.FUND, IsoCountry.BO),
    NGN(566, (Integer)2, IsoCountry.NG),
    ERN(232, (Integer)2, IsoCountry.ER),
    NAD(516, (Integer)2, IsoCountry.NA),
    NPR(524, (Integer)2, IsoCountry.NP),
    ANG(532, (Integer)2, IsoCountry.SX, IsoCountry.CW),
    ILS(376, (Integer)2, IsoCountry.IL),
    RON(946, (Integer)2, IsoCountry.RO),
    TWD(901, (Integer)2, IsoCountry.TW),
    NZD(554, (Integer)2, IsoCountry.TK, IsoCountry.NZ, IsoCountry.CK, IsoCountry.NU, IsoCountry.PN),
    BTN(64, (Integer)2, IsoCountry.BT),
    KPW(408, (Integer)2, IsoCountry.KP),
    NOK(578, (Integer)2, IsoCountry.NO, IsoCountry.SJ, IsoCountry.BV),
    PEN(604, (Integer)2, IsoCountry.PE),
    XXX(999, null, Category.OTHER, new IsoCountry[0]),
    MRU(929, (Integer)2, IsoCountry.MR),
    PKR(586, (Integer)2, IsoCountry.PK),
    XPD(964, null, Category.METAL, new IsoCountry[0]),
    MOP(446, (Integer)2, IsoCountry.MO),
    TOP(776, (Integer)2, IsoCountry.TO),
    CUC(931, (Integer)2, IsoCountry.CU),
    UYU(858, (Integer)2, IsoCountry.UY),
    PHP(608, (Integer)2, IsoCountry.PH),
    XPT(962, null, Category.METAL, new IsoCountry[0]),
    GBP(826, (Integer)2, IsoCountry.GB, IsoCountry.IM, IsoCountry.JE, IsoCountry.GG),
    BWP(72, (Integer)2, IsoCountry.BW),
    QAR(634, (Integer)2, IsoCountry.QA),
    GTQ(320, (Integer)2, IsoCountry.GT),
    ZAR(710, (Integer)2, IsoCountry.NA, IsoCountry.LS, IsoCountry.ZA),
    OMR(512, (Integer)3, IsoCountry.OM),
    KHR(116, (Integer)2, IsoCountry.KH),
    MVR(462, (Integer)2, IsoCountry.MV),
    IDR(360, (Integer)2, IsoCountry.ID),
    RUB(643, (Integer)2, IsoCountry.RU),
    RWF(646, (Integer)0, IsoCountry.RW),
    SHP(654, (Integer)2, IsoCountry.SH),
    SAR(682, (Integer)2, IsoCountry.SA),
    XDR(960, null, Category.OTHER, new IsoCountry[0]),
    RSD(941, (Integer)2, IsoCountry.RS),
    SCR(690, (Integer)2, IsoCountry.SC),
    XAG(961, null, Category.METAL, new IsoCountry[0]),
    SGD(702, (Integer)2, IsoCountry.SG),
    SBD(90, (Integer)2, IsoCountry.SB),
    KGS(417, (Integer)2, IsoCountry.KG),
    SOS(706, (Integer)2, IsoCountry.SO),
    TJS(972, (Integer)2, IsoCountry.TJ),
    SSP(728, (Integer)2, IsoCountry.SS),
    LKR(144, (Integer)2, IsoCountry.LK),
    XSU(994, null, Category.OTHER, new IsoCountry[0]),
    SDG(938, (Integer)2, IsoCountry.SD),
    SRD(968, (Integer)2, IsoCountry.SR),
    SEK(752, (Integer)2, IsoCountry.SE),
    CHF(756, (Integer)2, IsoCountry.LI, IsoCountry.CH),
    SYP(760, (Integer)2, IsoCountry.SY),
    BDT(50, (Integer)2, IsoCountry.BD),
    WST(882, (Integer)2, IsoCountry.WS),
    TZS(834, (Integer)2, IsoCountry.TZ),
    KZT(398, (Integer)2, IsoCountry.KZ),
    TTD(780, (Integer)2, IsoCountry.TT),
    MNT(496, (Integer)2, IsoCountry.MN),
    TND(788, (Integer)3, IsoCountry.TN),
    TRY(949, (Integer)2, IsoCountry.TR),
    TMT(934, (Integer)2, IsoCountry.TM),
    XTS(963, null, Category.OTHER, new IsoCountry[0]),
    AED(784, (Integer)2, IsoCountry.AE),
    UGX(800, (Integer)0, IsoCountry.UG),
    COU(970, (Integer)2, Category.FUND, IsoCountry.CO),
    CLF(990, (Integer)4, Category.FUND, IsoCountry.CL),
    UYI(940, (Integer)0, Category.FUND, IsoCountry.UY),
    USD(840, (Integer)2, IsoCountry.VG, IsoCountry.TL, IsoCountry.MP, IsoCountry.FM, IsoCountry.PW, IsoCountry.GU, IsoCountry.HT, IsoCountry.EC, IsoCountry.UM, IsoCountry.IO, IsoCountry.VI, IsoCountry.BQ, IsoCountry.SV, IsoCountry.US, IsoCountry.PA, IsoCountry.MH, IsoCountry.PR, IsoCountry.AS, IsoCountry.TC),
    USN(997, (Integer)2, Category.FUND, IsoCountry.US),
    USS(998, (Integer)2, Category.FUND, IsoCountry.US),
    UYW(927, (Integer)4, Category.FUND, IsoCountry.UY),
    UZS(860, (Integer)2, IsoCountry.UZ),
    VUV(548, (Integer)0, IsoCountry.VU),
    CHE(947, (Integer)2, Category.FUND, IsoCountry.CH),
    CHW(948, (Integer)2, Category.FUND, IsoCountry.CH),
    KRW(410, (Integer)0, IsoCountry.KR),
    YER(886, (Integer)2, IsoCountry.YE),
    JPY(392, (Integer)0, IsoCountry.JP),
    CNY(156, (Integer)2, IsoCountry.CN),
    ZMW(967, (Integer)2, IsoCountry.ZM),
    ZWL(932, (Integer)2, IsoCountry.ZW),
    PLN(985, (Integer)2, IsoCountry.PL);

    private static final Map<String, IsoCurrency> byAlphaCode;
    private static final Map<Integer, IsoCurrency> byNumericCode;
    private final int numericCode;
    private final Integer minorUnit;
    private final Category category;
    private final Set<IsoCountry> countries;

    private IsoCurrency(int numericCode, Integer minorUnit, Category category, IsoCountry ... countries) {
        this.numericCode = numericCode;
        this.minorUnit = minorUnit;
        this.category = Objects.requireNonNull(category);
        this.countries = Collections.unmodifiableSet(countries.length > 0 ? EnumSet.copyOf(Arrays.asList(countries)) : EnumSet.noneOf(IsoCountry.class));
    }

    private IsoCurrency(int numericCode, Integer minorUnit, IsoCountry ... countries) {
        this(numericCode, minorUnit, Category.NATIONAL, countries);
    }

    public String getAlphabeticCode() {
        return this.name();
    }

    public int getNumericCode() {
        return this.numericCode;
    }

    public Integer getMinorUnit() {
        return this.minorUnit;
    }

    public Category getCategory() {
        return this.category;
    }

    public Set<IsoCountry> getCountries() {
        return this.countries;
    }

    public static Optional<IsoCurrency> fromAlphabeticCode(String code) {
        String upperCasedCode = code == null ? null : code.toUpperCase();
        return Optional.ofNullable(byAlphaCode.get(upperCasedCode));
    }

    public static Optional<IsoCurrency> fromNumericCode(int code) {
        return Optional.ofNullable(byNumericCode.get(code));
    }

    public static Set<IsoCurrency> allOf(Category category) {
        Objects.requireNonNull(category);
        EnumSet<IsoCurrency> currencies = EnumSet.noneOf(IsoCurrency.class);
        for (IsoCurrency currency : IsoCurrency.values()) {
            if (currency.category != category) continue;
            currencies.add(currency);
        }
        return currencies;
    }

    static {
        byAlphaCode = new HashMap<String, IsoCurrency>();
        byNumericCode = new HashMap<Integer, IsoCurrency>();
        for (IsoCurrency currency : IsoCurrency.values()) {
            byAlphaCode.put(currency.getAlphabeticCode(), currency);
            byNumericCode.put(currency.getNumericCode(), currency);
        }
    }

    public static enum Category {
        BOND,
        FUND,
        METAL,
        NATIONAL,
        OTHER;

    }
}

