/*
 * Decompiled with CFR 0.152.
 */
package fr.marcwrobel.jbanking.calendar;

import java.time.DayOfWeek;
import java.time.LocalDate;

public enum ShiftingStrategy {
    CLOSEST_WEEKDAY{

        @Override
        public LocalDate shift(LocalDate date) {
            LocalDate d = date;
            DayOfWeek dayOfWeek = date.getDayOfWeek();
            if (dayOfWeek == DayOfWeek.SATURDAY) {
                d = date.minusDays(1L);
            } else if (dayOfWeek == DayOfWeek.SUNDAY) {
                d = date.plusDays(1L);
            }
            return d;
        }

        @Override
        public LocalDate[] unshift(LocalDate date) {
            DayOfWeek dayOfWeek = date.getDayOfWeek();
            if (dayOfWeek == DayOfWeek.MONDAY) {
                return new LocalDate[]{date, date.minusDays(1L)};
            }
            if (dayOfWeek == DayOfWeek.FRIDAY) {
                return new LocalDate[]{date, date.plusDays(1L)};
            }
            return new LocalDate[]{date};
        }
    }
    ,
    PLUS_TWO_DAYS{

        @Override
        public LocalDate shift(LocalDate date) {
            DayOfWeek dayOfWeek = date.getDayOfWeek();
            return dayOfWeek == DayOfWeek.SATURDAY || dayOfWeek == DayOfWeek.SUNDAY ? date.plusDays(2L) : date;
        }

        @Override
        public LocalDate[] unshift(LocalDate date) {
            LocalDate[] localDateArray;
            DayOfWeek dayOfWeek = date.getDayOfWeek();
            if (dayOfWeek == DayOfWeek.MONDAY || dayOfWeek == DayOfWeek.TUESDAY) {
                LocalDate[] localDateArray2 = new LocalDate[2];
                localDateArray2[0] = date;
                localDateArray = localDateArray2;
                localDateArray2[1] = date.minusDays(2L);
            } else {
                LocalDate[] localDateArray3 = new LocalDate[1];
                localDateArray = localDateArray3;
                localDateArray3[0] = date;
            }
            return localDateArray;
        }
    }
    ,
    SUNDAY_TO_MONDAY{

        @Override
        public LocalDate shift(LocalDate date) {
            return date.getDayOfWeek() == DayOfWeek.SUNDAY ? date.plusDays(1L) : date;
        }

        @Override
        public LocalDate[] unshift(LocalDate date) {
            LocalDate[] localDateArray;
            if (date.getDayOfWeek() == DayOfWeek.MONDAY) {
                LocalDate[] localDateArray2 = new LocalDate[2];
                localDateArray2[0] = date;
                localDateArray = localDateArray2;
                localDateArray2[1] = date.minusDays(1L);
            } else {
                LocalDate[] localDateArray3 = new LocalDate[1];
                localDateArray = localDateArray3;
                localDateArray3[0] = date;
            }
            return localDateArray;
        }
    }
    ,
    SUNDAY_TO_TUESDAY{

        @Override
        public LocalDate shift(LocalDate date) {
            return date.getDayOfWeek() == DayOfWeek.SUNDAY ? date.plusDays(2L) : date;
        }

        @Override
        public LocalDate[] unshift(LocalDate date) {
            LocalDate[] localDateArray;
            if (date.getDayOfWeek() == DayOfWeek.TUESDAY) {
                LocalDate[] localDateArray2 = new LocalDate[2];
                localDateArray2[0] = date;
                localDateArray = localDateArray2;
                localDateArray2[1] = date.minusDays(2L);
            } else {
                LocalDate[] localDateArray3 = new LocalDate[1];
                localDateArray = localDateArray3;
                localDateArray3[0] = date;
            }
            return localDateArray;
        }
    }
    ,
    SUNDAY_TO_WEDNESDAY{

        @Override
        public LocalDate shift(LocalDate date) {
            return date.getDayOfWeek() == DayOfWeek.SUNDAY ? date.plusDays(3L) : date;
        }

        @Override
        public LocalDate[] unshift(LocalDate date) {
            LocalDate[] localDateArray;
            if (date.getDayOfWeek() == DayOfWeek.WEDNESDAY) {
                LocalDate[] localDateArray2 = new LocalDate[2];
                localDateArray2[0] = date;
                localDateArray = localDateArray2;
                localDateArray2[1] = date.minusDays(3L);
            } else {
                LocalDate[] localDateArray3 = new LocalDate[1];
                localDateArray = localDateArray3;
                localDateArray3[0] = date;
            }
            return localDateArray;
        }
    }
    ,
    WEEKEND_TO_MONDAY{

        @Override
        public LocalDate shift(LocalDate date) {
            LocalDate d = date;
            DayOfWeek dayOfWeek = date.getDayOfWeek();
            if (dayOfWeek == DayOfWeek.SATURDAY) {
                d = date.plusDays(2L);
            } else if (dayOfWeek == DayOfWeek.SUNDAY) {
                d = date.plusDays(1L);
            }
            return d;
        }

        @Override
        public LocalDate[] unshift(LocalDate date) {
            LocalDate[] localDateArray;
            if (date.getDayOfWeek() == DayOfWeek.MONDAY) {
                LocalDate[] localDateArray2 = new LocalDate[3];
                localDateArray2[0] = date;
                localDateArray2[1] = date.minusDays(1L);
                localDateArray = localDateArray2;
                localDateArray2[2] = date.minusDays(2L);
            } else {
                LocalDate[] localDateArray3 = new LocalDate[1];
                localDateArray = localDateArray3;
                localDateArray3[0] = date;
            }
            return localDateArray;
        }
    };


    public abstract LocalDate shift(LocalDate var1);

    public abstract LocalDate[] unshift(LocalDate var1);
}

