/*
 * Decompiled with CFR 0.152.
 */
package fr.marcwrobel.jbanking.iban;

public enum IbanCheckDigit {
    INSTANCE;

    private static final int BBAN_INDEX = 4;
    private static final long CHECK_DIGITS_MAX = 999999999L;
    private static final long CHECK_DIGITS_MODULUS = 97L;
    private static final int CHECK_DIGITS_REMAINDER = 1;

    public boolean validate(String iban) {
        this.validateString(iban);
        this.validateCheckDigit(iban);
        return this.modulus(iban) == 1;
    }

    private void validateCheckDigit(String iban) {
        char first = iban.charAt(2);
        char second = iban.charAt(3);
        if (first == '0' && (second == '0' || second == '1') || first == '9' && second == '9') {
            throw new IllegalArgumentException("the check digit cannot be one of 00, 01 or 99");
        }
    }

    public String calculate(String iban) {
        this.validateString(iban);
        int modulusResult = this.modulus(iban);
        int charValue = 98 - modulusResult;
        String checkDigit = Integer.toString(charValue);
        return charValue > 9 ? checkDigit : "0" + checkDigit;
    }

    private void validateString(String iban) {
        if (iban == null) {
            throw new IllegalArgumentException("the iban argument cannot be null");
        }
        if (iban.length() <= 4) {
            throw new IllegalArgumentException("the iban argument size must be greater than 4");
        }
    }

    private int modulus(String iban) {
        String reformattedIban = iban.substring(4) + iban.substring(0, 4);
        long total = 0L;
        for (int i = 0; i < reformattedIban.length(); ++i) {
            int charValue = Character.getNumericValue(reformattedIban.charAt(i));
            total = (charValue > 9 ? total * 100L : total * 10L) + (long)charValue;
            if (total <= 999999999L) continue;
            total %= 97L;
        }
        return (int)(total % 97L);
    }
}

