/*
 * Decompiled with CFR 0.152.
 */
package fr.marcwrobel.jbanking.calendar;

import fr.marcwrobel.jbanking.calendar.Holiday;
import java.time.LocalDate;
import java.time.Month;
import java.time.MonthDay;
import java.util.Objects;

public final class MonthDayHoliday
implements Holiday {
    private final MonthDay monthDay;

    public MonthDayHoliday(MonthDay monthDay) {
        this.monthDay = Objects.requireNonNull(monthDay);
    }

    public MonthDayHoliday(Month month, int dayOfMonth) {
        this.monthDay = MonthDay.of(month, dayOfMonth);
    }

    @Override
    public boolean check(LocalDate date) {
        return this.monthDay.equals(MonthDay.from(date));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MonthDayHoliday that = (MonthDayHoliday)o;
        return this.monthDay.equals(that.monthDay);
    }

    public int hashCode() {
        return Objects.hash(this.monthDay);
    }

    public String toString() {
        return "MonthDayHoliday{monthDay=" + this.monthDay + '}';
    }
}

