/*
 * Decompiled with CFR 0.152.
 */
package fr.marcwrobel.jbanking;

import fr.marcwrobel.jbanking.IsoCountry;
import fr.marcwrobel.jbanking.internal.LastVerification;
import fr.marcwrobel.jbanking.internal.Normalizer;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

@LastVerification(value="2023-01-07")
public enum IsoCurrency {
    AED(784, (Integer)2, IsoCountry.AE),
    AFN(971, (Integer)2, IsoCountry.AF),
    ALL(8, (Integer)2, IsoCountry.AL),
    AMD(51, (Integer)2, IsoCountry.AM),
    ANG(532, (Integer)2, IsoCountry.SX, IsoCountry.CW),
    AOA(973, (Integer)2, IsoCountry.AO),
    ARS(32, (Integer)2, IsoCountry.AR),
    AUD(36, (Integer)2, IsoCountry.HM, IsoCountry.TV, IsoCountry.KI, IsoCountry.AU, IsoCountry.NF, IsoCountry.NR, IsoCountry.CX, IsoCountry.CC),
    AWG(533, (Integer)2, IsoCountry.AW),
    AZN(944, (Integer)2, IsoCountry.AZ),
    BAM(977, (Integer)2, IsoCountry.BA),
    BBD(52, (Integer)2, IsoCountry.BB),
    BDT(50, (Integer)2, IsoCountry.BD),
    BGN(975, (Integer)2, IsoCountry.BG),
    BHD(48, (Integer)3, IsoCountry.BH),
    BIF(108, (Integer)0, IsoCountry.BI),
    BMD(60, (Integer)2, IsoCountry.BM),
    BND(96, (Integer)2, IsoCountry.BN),
    BOB(68, (Integer)2, IsoCountry.BO),
    BOV(984, (Integer)2, Category.FUND, IsoCountry.BO),
    BRL(986, (Integer)2, IsoCountry.BR),
    BSD(44, (Integer)2, IsoCountry.BS),
    BTN(64, (Integer)2, IsoCountry.BT),
    BWP(72, (Integer)2, IsoCountry.BW),
    BYN(933, (Integer)2, IsoCountry.BY),
    BZD(84, (Integer)2, IsoCountry.BZ),
    CAD(124, (Integer)2, IsoCountry.CA),
    CDF(976, (Integer)2, IsoCountry.CD),
    CHE(947, (Integer)2, Category.FUND, IsoCountry.CH),
    CHF(756, (Integer)2, IsoCountry.LI, IsoCountry.CH),
    CHW(948, (Integer)2, Category.FUND, IsoCountry.CH),
    CLF(990, (Integer)4, Category.FUND, IsoCountry.CL),
    CLP(152, (Integer)0, IsoCountry.CL),
    CNY(156, (Integer)2, IsoCountry.CN),
    COP(170, (Integer)2, IsoCountry.CO),
    COU(970, (Integer)2, Category.FUND, IsoCountry.CO),
    CRC(188, (Integer)2, IsoCountry.CR),
    CUC(931, (Integer)2, IsoCountry.CU),
    CUP(192, (Integer)2, IsoCountry.CU),
    CVE(132, (Integer)2, IsoCountry.CV),
    CZK(203, (Integer)2, IsoCountry.CZ),
    DJF(262, (Integer)0, IsoCountry.DJ),
    DKK(208, (Integer)2, IsoCountry.DK, IsoCountry.FO, IsoCountry.GL),
    DOP(214, (Integer)2, IsoCountry.DO),
    DZD(12, (Integer)2, IsoCountry.DZ),
    EGP(818, (Integer)2, IsoCountry.EG),
    ERN(232, (Integer)2, IsoCountry.ER),
    ETB(230, (Integer)2, IsoCountry.ET),
    EUR(978, (Integer)2, IsoCountry.PT, IsoCountry.RE, IsoCountry.LU, IsoCountry.IT, IsoCountry.SK, IsoCountry.MF, IsoCountry.AD, IsoCountry.YT, IsoCountry.BL, IsoCountry.AX, IsoCountry.GP, IsoCountry.GF, IsoCountry.PM, IsoCountry.DE, IsoCountry.BE, IsoCountry.ES, IsoCountry.SM, IsoCountry.FI, IsoCountry.MT, IsoCountry.VA, IsoCountry.MC, IsoCountry.GR, IsoCountry.MQ, IsoCountry.TF, IsoCountry.EE, IsoCountry.IE, IsoCountry.NL, IsoCountry.ME, IsoCountry.SI, IsoCountry.FR, IsoCountry.AT, IsoCountry.CY, IsoCountry.XK, IsoCountry.LV, IsoCountry.LT, IsoCountry.HR),
    FJD(242, (Integer)2, IsoCountry.FJ),
    FKP(238, (Integer)2, IsoCountry.FK),
    GBP(826, (Integer)2, IsoCountry.GB, IsoCountry.IM, IsoCountry.JE, IsoCountry.GG),
    GEL(981, (Integer)2, IsoCountry.GE),
    GHS(936, (Integer)2, IsoCountry.GH),
    GIP(292, (Integer)2, IsoCountry.GI),
    GMD(270, (Integer)2, IsoCountry.GM),
    GNF(324, (Integer)0, IsoCountry.GN),
    GTQ(320, (Integer)2, IsoCountry.GT),
    GYD(328, (Integer)2, IsoCountry.GY),
    HKD(344, (Integer)2, IsoCountry.HK),
    HNL(340, (Integer)2, IsoCountry.HN),
    HRK(191, (Integer)2, new IsoCountry[0]),
    HTG(332, (Integer)2, IsoCountry.HT),
    HUF(348, (Integer)2, IsoCountry.HU),
    IDR(360, (Integer)2, IsoCountry.ID),
    ILS(376, (Integer)2, IsoCountry.IL),
    INR(356, (Integer)2, IsoCountry.IN, IsoCountry.BT),
    IQD(368, (Integer)3, IsoCountry.IQ),
    IRR(364, (Integer)2, IsoCountry.IR),
    ISK(352, (Integer)0, IsoCountry.IS),
    JMD(388, (Integer)2, IsoCountry.JM),
    JOD(400, (Integer)3, IsoCountry.JO),
    JPY(392, (Integer)0, IsoCountry.JP),
    KES(404, (Integer)2, IsoCountry.KE),
    KGS(417, (Integer)2, IsoCountry.KG),
    KHR(116, (Integer)2, IsoCountry.KH),
    KMF(174, (Integer)0, IsoCountry.KM),
    KPW(408, (Integer)2, IsoCountry.KP),
    KRW(410, (Integer)0, IsoCountry.KR),
    KWD(414, (Integer)3, IsoCountry.KW),
    KYD(136, (Integer)2, IsoCountry.KY),
    KZT(398, (Integer)2, IsoCountry.KZ),
    LAK(418, (Integer)2, IsoCountry.LA),
    LBP(422, (Integer)2, IsoCountry.LB),
    LKR(144, (Integer)2, IsoCountry.LK),
    LRD(430, (Integer)2, IsoCountry.LR),
    LSL(426, (Integer)2, IsoCountry.LS),
    LYD(434, (Integer)3, IsoCountry.LY),
    MAD(504, (Integer)2, IsoCountry.EH, IsoCountry.MA),
    MDL(498, (Integer)2, IsoCountry.MD),
    MGA(969, (Integer)2, IsoCountry.MG),
    MKD(807, (Integer)2, IsoCountry.MK),
    MMK(104, (Integer)2, IsoCountry.MM),
    MNT(496, (Integer)2, IsoCountry.MN),
    MOP(446, (Integer)2, IsoCountry.MO),
    MRU(929, (Integer)2, IsoCountry.MR),
    MUR(480, (Integer)2, IsoCountry.MU),
    MVR(462, (Integer)2, IsoCountry.MV),
    MWK(454, (Integer)2, IsoCountry.MW),
    MXN(484, (Integer)2, IsoCountry.MX),
    MXV(979, (Integer)2, Category.FUND, IsoCountry.MX),
    MYR(458, (Integer)2, IsoCountry.MY),
    MZN(943, (Integer)2, IsoCountry.MZ),
    NAD(516, (Integer)2, IsoCountry.NA),
    NGN(566, (Integer)2, IsoCountry.NG),
    NIO(558, (Integer)2, IsoCountry.NI),
    NOK(578, (Integer)2, IsoCountry.NO, IsoCountry.SJ, IsoCountry.BV),
    NPR(524, (Integer)2, IsoCountry.NP),
    NZD(554, (Integer)2, IsoCountry.TK, IsoCountry.NZ, IsoCountry.CK, IsoCountry.NU, IsoCountry.PN),
    OMR(512, (Integer)3, IsoCountry.OM),
    PAB(590, (Integer)2, IsoCountry.PA),
    PEN(604, (Integer)2, IsoCountry.PE),
    PGK(598, (Integer)2, IsoCountry.PG),
    PHP(608, (Integer)2, IsoCountry.PH),
    PKR(586, (Integer)2, IsoCountry.PK),
    PLN(985, (Integer)2, IsoCountry.PL),
    PYG(600, (Integer)0, IsoCountry.PY),
    QAR(634, (Integer)2, IsoCountry.QA),
    RON(946, (Integer)2, IsoCountry.RO),
    RSD(941, (Integer)2, IsoCountry.RS),
    RUB(643, (Integer)2, IsoCountry.RU),
    RWF(646, (Integer)0, IsoCountry.RW),
    SAR(682, (Integer)2, IsoCountry.SA),
    SBD(90, (Integer)2, IsoCountry.SB),
    SCR(690, (Integer)2, IsoCountry.SC),
    SDG(938, (Integer)2, IsoCountry.SD),
    SEK(752, (Integer)2, IsoCountry.SE),
    SGD(702, (Integer)2, IsoCountry.SG),
    SHP(654, (Integer)2, IsoCountry.SH),
    SLE(925, (Integer)2, IsoCountry.SL),
    SLL(694, (Integer)2, IsoCountry.SL),
    SOS(706, (Integer)2, IsoCountry.SO),
    SRD(968, (Integer)2, IsoCountry.SR),
    SSP(728, (Integer)2, IsoCountry.SS),
    STN(930, (Integer)2, IsoCountry.ST),
    SVC(222, (Integer)2, IsoCountry.SV),
    SYP(760, (Integer)2, IsoCountry.SY),
    SZL(748, (Integer)2, IsoCountry.SZ),
    THB(764, (Integer)2, IsoCountry.TH),
    TJS(972, (Integer)2, IsoCountry.TJ),
    TMT(934, (Integer)2, IsoCountry.TM),
    TND(788, (Integer)3, IsoCountry.TN),
    TOP(776, (Integer)2, IsoCountry.TO),
    TRY(949, (Integer)2, IsoCountry.TR),
    TTD(780, (Integer)2, IsoCountry.TT),
    TWD(901, (Integer)2, IsoCountry.TW),
    TZS(834, (Integer)2, IsoCountry.TZ),
    UAH(980, (Integer)2, IsoCountry.UA),
    UGX(800, (Integer)0, IsoCountry.UG),
    USD(840, (Integer)2, IsoCountry.VG, IsoCountry.TL, IsoCountry.MP, IsoCountry.FM, IsoCountry.PW, IsoCountry.GU, IsoCountry.HT, IsoCountry.EC, IsoCountry.UM, IsoCountry.IO, IsoCountry.VI, IsoCountry.BQ, IsoCountry.SV, IsoCountry.US, IsoCountry.PA, IsoCountry.MH, IsoCountry.PR, IsoCountry.AS, IsoCountry.TC),
    USN(997, (Integer)2, Category.FUND, IsoCountry.US),
    USS(998, (Integer)2, Category.FUND, IsoCountry.US),
    UYI(940, (Integer)0, Category.FUND, IsoCountry.UY),
    UYU(858, (Integer)2, IsoCountry.UY),
    UYW(927, (Integer)4, Category.FUND, IsoCountry.UY),
    UZS(860, (Integer)2, IsoCountry.UZ),
    VED(926, (Integer)2, IsoCountry.VE),
    VES(928, (Integer)2, IsoCountry.VE),
    VND(704, (Integer)0, IsoCountry.VN),
    VUV(548, (Integer)0, IsoCountry.VU),
    WST(882, (Integer)2, IsoCountry.WS),
    XAF(950, (Integer)0, IsoCountry.TD, IsoCountry.GA, IsoCountry.GQ, IsoCountry.CM, IsoCountry.CF, IsoCountry.CG),
    XAG(961, null, Category.METAL, new IsoCountry[0]),
    XAU(959, null, Category.METAL, new IsoCountry[0]),
    XBA(955, null, Category.BOND, new IsoCountry[0]),
    XBB(956, null, Category.BOND, new IsoCountry[0]),
    XBC(957, null, Category.BOND, new IsoCountry[0]),
    XBD(958, null, Category.BOND, new IsoCountry[0]),
    XCD(951, (Integer)2, IsoCountry.DM, IsoCountry.VC, IsoCountry.MS, IsoCountry.AG, IsoCountry.LC, IsoCountry.AI, IsoCountry.KN, IsoCountry.GD),
    XDR(960, null, Category.OTHER, new IsoCountry[0]),
    XOF(952, (Integer)0, IsoCountry.ML, IsoCountry.NE, IsoCountry.BJ, IsoCountry.TG, IsoCountry.BF, IsoCountry.SN, IsoCountry.CI, IsoCountry.GW),
    XPD(964, null, Category.METAL, new IsoCountry[0]),
    XPF(953, (Integer)0, IsoCountry.PF, IsoCountry.WF, IsoCountry.NC),
    XPT(962, null, Category.METAL, new IsoCountry[0]),
    XSU(994, null, Category.OTHER, new IsoCountry[0]),
    XTS(963, null, Category.OTHER, new IsoCountry[0]),
    XUA(965, null, Category.OTHER, new IsoCountry[0]),
    XXX(999, null, Category.OTHER, new IsoCountry[0]),
    YER(886, (Integer)2, IsoCountry.YE),
    ZAR(710, (Integer)2, IsoCountry.NA, IsoCountry.LS, IsoCountry.ZA),
    ZMW(967, (Integer)2, IsoCountry.ZM),
    ZWL(932, (Integer)2, IsoCountry.ZW);

    private static final Map<String, IsoCurrency> byAlphaCode;
    private static final Map<Integer, IsoCurrency> byNumericCode;
    private final int numericCode;
    private final Integer minorUnit;
    private final Category category;
    private final Set<IsoCountry> countries;

    private IsoCurrency(int numericCode, Integer minorUnit, Category category, IsoCountry ... countries) {
        this.numericCode = numericCode;
        this.minorUnit = minorUnit;
        this.category = Objects.requireNonNull(category);
        this.countries = Collections.unmodifiableSet(countries.length > 0 ? EnumSet.copyOf(Arrays.asList(countries)) : EnumSet.noneOf(IsoCountry.class));
    }

    private IsoCurrency(int numericCode, Integer minorUnit, IsoCountry ... countries) {
        this(numericCode, minorUnit, Category.NATIONAL, countries);
    }

    public String getAlphabeticCode() {
        return this.name();
    }

    public int getNumericCode() {
        return this.numericCode;
    }

    public Integer getMinorUnit() {
        return this.minorUnit;
    }

    public Category getCategory() {
        return this.category;
    }

    public Set<IsoCountry> getCountries() {
        return this.countries;
    }

    public static Optional<IsoCurrency> fromAlphabeticCode(String code) {
        return Optional.ofNullable(byAlphaCode.get(Normalizer.trimUpperCase(code)));
    }

    public static Optional<IsoCurrency> fromNumericCode(int code) {
        return Optional.ofNullable(byNumericCode.get(code));
    }

    public static Set<IsoCurrency> allOf(Category category) {
        Objects.requireNonNull(category);
        EnumSet<IsoCurrency> currencies = EnumSet.noneOf(IsoCurrency.class);
        for (IsoCurrency currency : IsoCurrency.values()) {
            if (currency.category != category) continue;
            currencies.add(currency);
        }
        return currencies;
    }

    static {
        byAlphaCode = new HashMap<String, IsoCurrency>();
        byNumericCode = new HashMap<Integer, IsoCurrency>();
        for (IsoCurrency currency : IsoCurrency.values()) {
            byAlphaCode.put(currency.getAlphabeticCode(), currency);
            byNumericCode.put(currency.getNumericCode(), currency);
        }
    }

    public static enum Category {
        BOND,
        FUND,
        METAL,
        NATIONAL,
        OTHER;

    }
}

