/*
 * Decompiled with CFR 0.152.
 */
package fr.marcwrobel.jbanking.iban;

import fr.marcwrobel.jbanking.IsoCountry;
import fr.marcwrobel.jbanking.iban.IbanPattern;
import fr.marcwrobel.jbanking.internal.LastVerification;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

@LastVerification(value="2023-01-07")
public enum BbanStructure {
    AD(IsoCountry.AD, "4!n4!n12!c", 0, 4, 4, 8, null, null, 8, 20, new IsoCountry[0]),
    AE(IsoCountry.AE, "3!n16!n", 0, 3, null, null, null, null, 3, 19, new IsoCountry[0]),
    AL(IsoCountry.AL, "8!n16!c", 0, 3, 3, 7, 7, 8, 8, 24, new IsoCountry[0]),
    AT(IsoCountry.AT, "5!n11!n", 0, 5, null, null, null, null, 5, 16, new IsoCountry[0]),
    AZ(IsoCountry.AZ, "4!a20!c", 0, 4, null, null, null, null, 4, 24, new IsoCountry[0]),
    BA(IsoCountry.BA, "3!n3!n8!n2!n", 0, 3, 3, 6, 14, 16, 6, 14, new IsoCountry[0]),
    BE(IsoCountry.BE, "3!n7!n2!n", 0, 3, null, null, 10, 12, 3, 10, new IsoCountry[0]),
    BG(IsoCountry.BG, "4!a4!n2!n8!c", 0, 4, 4, 8, null, null, 10, 18, new IsoCountry[0]),
    BH(IsoCountry.BH, "4!a14!c", 0, 4, null, null, null, null, 4, 18, new IsoCountry[0]),
    BI(IsoCountry.BI, "5!n5!n11!n2!n", 0, 5, 5, 10, null, null, 10, 23, new IsoCountry[0]),
    BR(IsoCountry.BR, "8!n5!n10!n1!a1!c", 0, 8, 8, 13, null, null, 13, 23, new IsoCountry[0]),
    BY(IsoCountry.BY, "4!c4!n16!c", 0, 4, null, null, null, null, 8, 24, new IsoCountry[0]),
    CH(IsoCountry.CH, "5!n12!c", 0, 5, null, null, null, null, 5, 17, new IsoCountry[0]),
    CR(IsoCountry.CR, "4!n14!n", 1, 4, null, null, null, null, 4, 18, new IsoCountry[0]),
    CY(IsoCountry.CY, "3!n5!n16!c", 0, 3, 3, 8, null, null, 8, 24, new IsoCountry[0]),
    CZ(IsoCountry.CZ, "4!n6!n10!n", 0, 4, null, null, null, null, 4, 20, new IsoCountry[0]),
    DE(IsoCountry.DE, "8!n10!n", 0, 8, null, null, null, null, 8, 18, new IsoCountry[0]),
    DJ(IsoCountry.DJ, "5!n5!n11!n2!n", 0, 5, 5, 10, null, null, 10, 23, new IsoCountry[0]),
    DK(IsoCountry.DK, "4!n9!n1!n", 0, 4, null, null, null, null, 4, 14, new IsoCountry[0]),
    DO(IsoCountry.DO, "4!c20!n", 0, 4, null, null, null, null, 4, 24, new IsoCountry[0]),
    EE(IsoCountry.EE, "2!n2!n11!n1!n", 0, 2, null, null, null, null, 2, 16, new IsoCountry[0]),
    EG(IsoCountry.EG, "4!n4!n17!n", 0, 4, 4, 8, null, null, 8, 25, new IsoCountry[0]),
    ES(IsoCountry.ES, "4!n4!n1!n1!n10!n", 0, 4, 4, 8, 8, 10, 10, 20, new IsoCountry[0]),
    FI(IsoCountry.FI, "3!n11!n", 0, 3, null, null, null, null, 3, 14, IsoCountry.AX),
    FO(IsoCountry.FO, "4!n9!n1!n", 0, 4, null, null, null, null, 4, 14, new IsoCountry[0]),
    FR(IsoCountry.FR, "5!n5!n11!c2!n", 0, 5, 5, 10, 21, 23, 10, 21, IsoCountry.GF, IsoCountry.GP, IsoCountry.MQ, IsoCountry.RE, IsoCountry.PF, IsoCountry.TF, IsoCountry.YT, IsoCountry.NC, IsoCountry.BL, IsoCountry.MF, IsoCountry.PM, IsoCountry.WF),
    GB(IsoCountry.GB, "4!a6!n8!n", 0, 4, 4, 10, null, null, 10, 18, IsoCountry.IM, IsoCountry.JE, IsoCountry.GG),
    GE(IsoCountry.GE, "2!a16!n", 0, 2, null, null, null, null, 2, 18, new IsoCountry[0]),
    GI(IsoCountry.GI, "4!a15!c", 0, 4, null, null, null, null, 4, 19, new IsoCountry[0]),
    GL(IsoCountry.GL, "4!n9!n1!n", 0, 4, null, null, null, null, 4, 14, new IsoCountry[0]),
    GR(IsoCountry.GR, "3!n4!n16!c", 0, 3, 3, 7, null, null, 7, 23, new IsoCountry[0]),
    GT(IsoCountry.GT, "4!c20!c", 0, 4, null, null, null, null, 8, 24, new IsoCountry[0]),
    HR(IsoCountry.HR, "7!n10!n", 0, 7, null, null, null, null, 7, 17, new IsoCountry[0]),
    HU(IsoCountry.HU, "3!n4!n1!n15!n1!n", 0, 3, 3, 7, 23, 24, 7, 23, new IsoCountry[0]),
    IE(IsoCountry.IE, "4!a6!n8!n", 0, 4, 4, 10, null, null, 10, 18, new IsoCountry[0]),
    IL(IsoCountry.IL, "3!n3!n13!n", 0, 3, 3, 6, null, null, 6, 19, new IsoCountry[0]),
    IQ(IsoCountry.IQ, "4!a3!n12!n", 0, 4, 4, 7, null, null, 7, 19, new IsoCountry[0]),
    IS(IsoCountry.IS, "4!n2!n6!n10!n", 0, 2, 2, 4, null, null, 6, 12, new IsoCountry[0]),
    IT(IsoCountry.IT, "1!a5!n5!n12!c", 1, 6, 6, 11, 0, 1, 11, 23, new IsoCountry[0]),
    JO(IsoCountry.JO, "4!a4!n18!c", 0, 4, 4, 8, null, null, 8, 26, new IsoCountry[0]),
    KW(IsoCountry.KW, "4!a22!c", 0, 4, null, null, null, null, 4, 26, new IsoCountry[0]),
    KZ(IsoCountry.KZ, "3!n13!c", 0, 3, null, null, null, null, 3, 16, new IsoCountry[0]),
    LB(IsoCountry.LB, "4!n20!c", 0, 4, null, null, null, null, 4, 24, new IsoCountry[0]),
    LC(IsoCountry.LC, "4!a24!c", 0, 4, null, null, null, null, 4, 28, new IsoCountry[0]),
    LI(IsoCountry.LI, "5!n12!c", 0, 5, null, null, null, null, 5, 17, new IsoCountry[0]),
    LT(IsoCountry.LT, "5!n11!n", 0, 5, null, null, null, null, 5, 16, new IsoCountry[0]),
    LU(IsoCountry.LU, "3!n13!c", 0, 3, null, null, null, null, 3, 16, new IsoCountry[0]),
    LV(IsoCountry.LV, "4!a13!c", 0, 4, null, null, null, null, 4, 17, new IsoCountry[0]),
    LY(IsoCountry.LY, "3!n3!n15!n", 0, 3, 3, 6, null, null, 6, 21, new IsoCountry[0]),
    MC(IsoCountry.MC, "5!n5!n11!c2!n", 0, 5, 5, 10, 21, 23, 10, 21, new IsoCountry[0]),
    MD(IsoCountry.MD, "2!c18!c", 0, 2, null, null, null, null, 2, 20, new IsoCountry[0]),
    ME(IsoCountry.ME, "3!n13!n2!n", 0, 3, null, null, 16, 18, 3, 16, new IsoCountry[0]),
    MK(IsoCountry.MK, "3!n10!c2!n", 0, 3, null, null, 13, 15, 3, 13, new IsoCountry[0]),
    MR(IsoCountry.MR, "5!n5!n11!n2!n", 0, 5, 5, 10, 21, 23, 10, 21, new IsoCountry[0]),
    MT(IsoCountry.MT, "4!a5!n18!c", 0, 4, 4, 9, null, null, 9, 27, new IsoCountry[0]),
    MU(IsoCountry.MU, "4!a2!n2!n12!n3!n3!a", 0, 6, 6, 8, null, null, 8, 20, new IsoCountry[0]),
    NL(IsoCountry.NL, "4!a10!n", 0, 4, null, null, null, null, 4, 14, new IsoCountry[0]),
    NO(IsoCountry.NO, "4!n6!n1!n", 0, 4, null, null, 10, 11, 4, 10, new IsoCountry[0]),
    PK(IsoCountry.PK, "4!a16!c", 0, 4, null, null, null, null, 4, 20, new IsoCountry[0]),
    PL(IsoCountry.PL, "8!n16!n", 0, 3, 3, 7, 7, 8, 8, 24, new IsoCountry[0]),
    PS(IsoCountry.PS, "4!a21!c", 0, 4, null, null, null, null, 4, 25, new IsoCountry[0]),
    PT(IsoCountry.PT, "4!n4!n11!n2!n", 0, 4, 4, 8, 19, 21, 8, 19, new IsoCountry[0]),
    QA(IsoCountry.QA, "4!a21!c", 0, 4, null, null, null, null, 4, 25, new IsoCountry[0]),
    RO(IsoCountry.RO, "4!a16!c", 0, 4, null, null, null, null, 4, 20, new IsoCountry[0]),
    RS(IsoCountry.RS, "3!n13!n2!n", 0, 3, null, null, 16, 18, 3, 16, new IsoCountry[0]),
    RU(IsoCountry.RU, "9!n5!n15!c", 0, 9, 9, 14, null, null, 14, 29, new IsoCountry[0]),
    SA(IsoCountry.SA, "2!n18!c", 0, 2, null, null, null, null, 2, 20, new IsoCountry[0]),
    SC(IsoCountry.SC, "4!a2!n2!n16!n3!a", 0, 6, 6, 8, null, null, 8, 24, new IsoCountry[0]),
    SD(IsoCountry.SD, "2!n12!n", 0, 2, null, null, null, null, 2, 14, new IsoCountry[0]),
    SE(IsoCountry.SE, "3!n16!n1!n", 0, 3, null, null, 19, 20, 3, 19, new IsoCountry[0]),
    SI(IsoCountry.SI, "5!n8!n2!n", 0, 2, 2, 5, 13, 15, 5, 13, new IsoCountry[0]),
    SK(IsoCountry.SK, "4!n6!n10!n", 0, 4, null, null, null, null, 4, 20, new IsoCountry[0]),
    SM(IsoCountry.SM, "1!a5!n5!n12!c", 1, 6, 6, 11, 0, 1, 11, 23, new IsoCountry[0]),
    ST(IsoCountry.ST, "8!n11!n2!n", 0, 4, 4, 8, null, null, 8, 21, new IsoCountry[0]),
    SV(IsoCountry.SV, "4!a20!n", 0, 4, null, null, null, null, 4, 24, new IsoCountry[0]),
    TL(IsoCountry.TL, "3!n14!n2!n", 0, 3, null, null, 17, 19, 3, 17, new IsoCountry[0]),
    TN(IsoCountry.TN, "2!n3!n13!n2!n", 0, 2, 2, 5, 18, 20, 5, 18, new IsoCountry[0]),
    TR(IsoCountry.TR, "5!n1!n16!c", 0, 5, null, null, null, null, 6, 22, new IsoCountry[0]),
    UA(IsoCountry.UA, "6!n19!c", 0, 6, null, null, null, null, 6, 25, new IsoCountry[0]),
    VA(IsoCountry.VA, "3!n15!n", 0, 3, null, null, null, null, 3, 18, new IsoCountry[0]),
    VG(IsoCountry.VG, "4!a16!n", 0, 4, null, null, null, null, 4, 20, new IsoCountry[0]),
    XK(IsoCountry.XK, "4!n10!n2!n", 0, 2, 2, 4, 14, 16, 4, 14, new IsoCountry[0]);

    private static final Map<IsoCountry, BbanStructure> byCountry;
    private final IbanPattern bbanPattern;
    private final IsoCountry country;
    private final Set<IsoCountry> subdivisions;
    private final int bankIdentifierStartIndexInclusive;
    private final int bankIdentifierEndIndexExclusive;
    private final Integer branchIdentifierStartIndexInclusive;
    private final Integer branchIdentifierEndIndexExclusive;
    private final Integer nationalCheckDigitStartIndexInclusive;
    private final Integer nationalCheckDigitEndIndexExclusive;
    private final int accountNumberStartIndexInclusive;
    private final int accountNumberEndIndexExclusive;

    private BbanStructure(IsoCountry country, String bbanSwiftExpression, int bankIdentifierStartIndexInclusive, int bankIdentifierEndIndexExclusive, Integer branchIdentifierStartIndexInclusive, Integer branchIdentifierEndIndexExclusive, Integer nationalCheckDigitStartIndexInclusive, Integer nationalCheckDigitEndIndexExclusive, int accountNumberStartIndexInclusive, int accountNumberEndIndexExclusive, IsoCountry ... subdivisions) {
        this.bbanPattern = IbanPattern.compile(bbanSwiftExpression);
        this.country = country;
        this.subdivisions = Collections.unmodifiableSet(subdivisions.length > 0 ? EnumSet.copyOf(Arrays.asList(subdivisions)) : EnumSet.noneOf(IsoCountry.class));
        this.bankIdentifierStartIndexInclusive = bankIdentifierStartIndexInclusive;
        this.bankIdentifierEndIndexExclusive = bankIdentifierEndIndexExclusive;
        this.branchIdentifierStartIndexInclusive = branchIdentifierStartIndexInclusive;
        this.branchIdentifierEndIndexExclusive = branchIdentifierEndIndexExclusive;
        this.nationalCheckDigitStartIndexInclusive = nationalCheckDigitStartIndexInclusive;
        this.nationalCheckDigitEndIndexExclusive = nationalCheckDigitEndIndexExclusive;
        this.accountNumberStartIndexInclusive = accountNumberStartIndexInclusive;
        this.accountNumberEndIndexExclusive = accountNumberEndIndexExclusive;
    }

    public static Optional<BbanStructure> forCountry(IsoCountry country) {
        return Optional.ofNullable(byCountry.get((Object)country));
    }

    IsoCountry getCountry() {
        return this.country;
    }

    Set<IsoCountry> getSubdivisions() {
        return this.subdivisions;
    }

    int getBankIdentifierStartIndexInclusive() {
        return this.bankIdentifierStartIndexInclusive;
    }

    int getBankIdentifierEndIndexExclusive() {
        return this.bankIdentifierEndIndexExclusive;
    }

    Optional<Integer> getBranchIdentifierStartIndexInclusive() {
        return Optional.ofNullable(this.branchIdentifierStartIndexInclusive);
    }

    Optional<Integer> getBranchIdentifierEndIndexExclusive() {
        return Optional.ofNullable(this.branchIdentifierEndIndexExclusive);
    }

    Optional<Integer> getNationalCheckDigitStartIndexInclusive() {
        return Optional.ofNullable(this.nationalCheckDigitStartIndexInclusive);
    }

    Optional<Integer> getNationalCheckDigitEndIndexExclusive() {
        return Optional.ofNullable(this.nationalCheckDigitEndIndexExclusive);
    }

    int getAccountNumberStartIndexInclusive() {
        return this.accountNumberStartIndexInclusive;
    }

    int getAccountNumberEndIndexExclusive() {
        return this.accountNumberEndIndexExclusive;
    }

    IbanPattern getBbanPattern() {
        return this.bbanPattern;
    }

    boolean isBbanValid(String bban) {
        if (bban == null) {
            throw new IllegalArgumentException("the bban argument cannot be null");
        }
        return this.bbanPattern.matches(bban);
    }

    static {
        byCountry = new EnumMap<IsoCountry, BbanStructure>(IsoCountry.class);
        for (BbanStructure structure : BbanStructure.values()) {
            byCountry.put(structure.getCountry(), structure);
            for (IsoCountry subDivision : structure.getSubdivisions()) {
                byCountry.put(subDivision, structure);
            }
        }
    }
}

