/*
 * Decompiled with CFR 0.152.
 */
package fr.marcwrobel.jbanking.iban;

import fr.marcwrobel.jbanking.swift.SwiftPatternCharacterRepresentation;
import java.util.Objects;

class IbanPatternGroup {
    final int from;
    final int length;
    final SwiftPatternCharacterRepresentation characters;

    IbanPatternGroup(SwiftPatternCharacterRepresentation characters, int from, int length) {
        this.characters = Objects.requireNonNull(characters);
        this.from = from;
        this.length = length;
    }

    boolean matches(String s) {
        for (int i = this.from; i < this.from + this.length; ++i) {
            if (this.characters.has(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public boolean canBeMergedTo(IbanPatternGroup group) {
        return this.characters == group.characters && this.from + this.length == group.from;
    }

    public IbanPatternGroup merge(IbanPatternGroup group) {
        return new IbanPatternGroup(this.characters, this.from, this.length + group.length);
    }
}

