/*
 * Decompiled with CFR 0.152.
 */
package fr.marcwrobel.jbanking.bic;

import fr.marcwrobel.jbanking.IsoCountry;
import fr.marcwrobel.jbanking.bic.BicFormatException;
import fr.marcwrobel.jbanking.internal.AsciiCharacters;
import fr.marcwrobel.jbanking.internal.Normalizer;
import java.io.Serializable;
import java.util.Optional;

public final class Bic
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String REGEX = "\\s*[a-zA-Z]{4}[a-zA-Z]{2}[a-zA-Z0-9]{2}([a-zA-Z0-9]{3})?\\s*";
    public static final String PRIMARY_OFFICE_BRANCH_CODE = "XXX";
    public static final char TEST_BIC_INDICATOR = '0';
    public static final int BIC8_LENGTH = 8;
    public static final int BIC11_LENGTH = 11;
    public static final int INSTITUTION_CODE_INDEX = 0;
    public static final int INSTITUTION_CODE_LENGTH = 4;
    public static final int COUNTRY_CODE_INDEX = 4;
    public static final int COUNTRY_CODE_LENGTH = 2;
    public static final int LOCATION_CODE_INDEX = 6;
    public static final int LOCATION_CODE_LENGTH = 2;
    public static final int BRANCH_CODE_INDEX = 8;
    public static final int BRANCH_CODE_LENGTH = 3;
    private final String value;

    public Bic(String s) {
        if (s == null) {
            throw new IllegalArgumentException("s cannot be null");
        }
        String normalized = Normalizer.trimUpperCase(s);
        if (!Bic.isWellFormatted(normalized)) {
            throw BicFormatException.forNotProperlyFormattedInput(s);
        }
        if (!Bic.findCountryFor(normalized).isPresent()) {
            throw BicFormatException.forUnknownCountryCode(s);
        }
        if (normalized.length() == 8) {
            normalized = normalized + PRIMARY_OFFICE_BRANCH_CODE;
        }
        this.value = normalized;
    }

    public static boolean isValid(String s) {
        String normalizedValue = Normalizer.trimUpperCase(s);
        return normalizedValue != null && Bic.isWellFormatted(normalizedValue) && Bic.findCountryFor(normalizedValue).isPresent();
    }

    private static boolean isWellFormatted(String bic) {
        int i;
        int length = bic.length();
        if (length != 8 && length != 11) {
            return false;
        }
        for (i = 0; i < 6; ++i) {
            if (AsciiCharacters.isAlphabetic(bic.charAt(i))) continue;
            return false;
        }
        for (i = 6; i < length; ++i) {
            if (AsciiCharacters.isAlphanumeric(bic.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static Optional<IsoCountry> findCountryFor(String bic) {
        return IsoCountry.fromAlpha2Code(bic.substring(4, 6));
    }

    public String getInstitutionCode() {
        return this.value.substring(0, 4);
    }

    public String getCountryCode() {
        return this.getCountry().getAlpha2Code();
    }

    public IsoCountry getCountry() {
        return Bic.findCountryFor(this.value).orElseThrow(() -> new IllegalStateException("a valid Bic should have a country code"));
    }

    public String getLocationCode() {
        return this.value.substring(6, 8);
    }

    public String getBranchCode() {
        return this.value.substring(8, 11);
    }

    public boolean isTestBic() {
        return this.value.charAt(7) == '0';
    }

    public boolean isLiveBic() {
        return !this.isTestBic();
    }

    public Bic asTestBic() {
        if (this.isTestBic()) {
            return this;
        }
        StringBuilder testBicBuilder = new StringBuilder(this.value);
        testBicBuilder.setCharAt(7, '0');
        return new Bic(testBicBuilder.toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.value.equals(((Bic)o).value);
    }

    public int hashCode() {
        return 31 * this.value.hashCode();
    }

    public String toString() {
        return this.value;
    }
}

