/*
 * Decompiled with CFR 0.152.
 */
package fr.marcwrobel.jbanking.bic;

import fr.marcwrobel.jbanking.IsoCountry;
import fr.marcwrobel.jbanking.IsoCurrency;
import fr.marcwrobel.jbanking.bic.Bic;
import fr.marcwrobel.jbanking.swift.SwiftPatternCharacterRepresentation;
import java.util.Arrays;
import java.util.Objects;
import java.util.Random;

public class RandomBic {
    private static final String LETTERS = SwiftPatternCharacterRepresentation.UPPER_CASE_LETTERS.alphabet();
    private static final String LETTERS_AND_DIGITS = LETTERS + SwiftPatternCharacterRepresentation.DIGITS.alphabet();
    private final Random random;

    public RandomBic(Random random) {
        this.random = Objects.requireNonNull(random);
    }

    public RandomBic() {
        this(new Random());
    }

    public Bic next() {
        return this.next(IsoCountry.values());
    }

    public Bic next(IsoCountry ... countries) {
        IsoCountry country = countries[this.random.nextInt(countries.length)];
        return this.generate(country);
    }

    public Bic next(String ... isoCountryAlpha2Codes) {
        String countryCode = isoCountryAlpha2Codes[this.random.nextInt(isoCountryAlpha2Codes.length)];
        IsoCountry country = IsoCountry.fromAlpha2Code(countryCode).orElseThrow(() -> new IllegalArgumentException(String.format("no corresponding country could be found for alpha-2 code '%s'", countryCode)));
        return this.generate(country);
    }

    public Bic next(IsoCurrency ... currencies) {
        IsoCountry[] countries = (IsoCountry[])Arrays.stream(currencies).flatMap(currency -> currency.getCountries().stream()).sorted().toArray(IsoCountry[]::new);
        return this.next(countries);
    }

    private Bic generate(IsoCountry country) {
        int i;
        StringBuilder bic = new StringBuilder(11);
        for (i = 0; i < 4; ++i) {
            bic.append(LETTERS.charAt(this.random.nextInt(LETTERS.length())));
        }
        bic.append(country.getAlpha2Code());
        for (i = 0; i < 5; ++i) {
            bic.append(LETTERS_AND_DIGITS.charAt(this.random.nextInt(LETTERS_AND_DIGITS.length())));
        }
        return new Bic(bic.toString());
    }
}

