/*
 * Decompiled with CFR 0.152.
 */
package fr.marcwrobel.jbanking.calendar;

import fr.marcwrobel.jbanking.calendar.DayOfWeekInMonthHoliday;
import fr.marcwrobel.jbanking.calendar.Holiday;
import fr.marcwrobel.jbanking.calendar.MonthDayHoliday;
import fr.marcwrobel.jbanking.calendar.RelativeHoliday;
import fr.marcwrobel.jbanking.calendar.WesternEaster;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.Month;
import java.time.MonthDay;

enum Holidays implements Holiday
{
    ALL_SAINTS_DAY(new MonthDayHoliday(MonthDay.of(Month.NOVEMBER, 1))),
    ARMISTICE_DAY(new MonthDayHoliday(MonthDay.of(Month.NOVEMBER, 11))),
    ASCENSION_DAY(new RelativeHoliday(WesternEaster.INSTANCE, 39)),
    ASSUMPTION_OF_MARY(new MonthDayHoliday(MonthDay.of(Month.AUGUST, 15))),
    BOXING_DAY(new MonthDayHoliday(MonthDay.of(Month.DECEMBER, 26))),
    CHRISTMAS_DAY(new MonthDayHoliday(MonthDay.of(Month.DECEMBER, 25))),
    CHRISTMAS_EVE(new MonthDayHoliday(MonthDay.of(Month.DECEMBER, 24))),
    EASTER_MONDAY(new RelativeHoliday(WesternEaster.INSTANCE, 1)),
    EUROPE_DAY(new MonthDayHoliday(MonthDay.of(Month.MAY, 9))),
    FEAST_OF_CORPUS_CHRISTI(new RelativeHoliday(WesternEaster.INSTANCE, 60)),
    GOOD_FRIDAY(new RelativeHoliday(WesternEaster.INSTANCE, -2)),
    INTERNATIONAL_WORKERS_DAY(new MonthDayHoliday(MonthDay.of(Month.MAY, 1))),
    MAY_DAY(new DayOfWeekInMonthHoliday(1, DayOfWeek.MONDAY, Month.MAY)),
    NEW_YEAR_DAY(new MonthDayHoliday(MonthDay.of(Month.JANUARY, 1))),
    NEW_YEAR_EVE(new MonthDayHoliday(MonthDay.of(Month.DECEMBER, 31))),
    PENTECOST_MONDAY(new RelativeHoliday(WesternEaster.INSTANCE, 50)),
    SAINT_STEPHENS_DAY(new MonthDayHoliday(MonthDay.of(Month.DECEMBER, 26))),
    VICTORY_IN_EUROPE_DAY(new MonthDayHoliday(MonthDay.of(Month.MAY, 8)));

    private final Holiday holiday;

    private Holidays(Holiday holiday) {
        this.holiday = holiday;
    }

    @Override
    public boolean check(LocalDate date) {
        return this.holiday.check(date);
    }
}

