/*
 * Decompiled with CFR 0.152.
 */
package fr.marcwrobel.jbanking.iban;

import fr.marcwrobel.jbanking.IsoCountry;
import fr.marcwrobel.jbanking.checkdigit.IbanCheckDigit;
import fr.marcwrobel.jbanking.iban.BbanStructure;
import fr.marcwrobel.jbanking.iban.IbanFormatException;
import fr.marcwrobel.jbanking.internal.Normalizer;
import java.io.Serializable;
import java.util.Optional;

public final class Iban
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String REGEX = "\\s*[a-zA-Z]{2}[0-9]{2}[a-zA-Z0-9]+\\s*";
    private static final int MIN_LENGTH = 5;
    private static final int COUNTRY_CODE_INDEX = 0;
    private static final int COUNTRY_CODE_LENGTH = 2;
    private static final int CHECK_DIGITS_INDEX = 2;
    private static final int CHECK_DIGITS_LENGTH = 2;
    private static final int BBAN_INDEX = 4;
    private static final int GROUP_SIZE_FOR_PRINTABLE_IBAN = 4;
    private final String value;
    private final BbanStructure structure;

    public Iban(IsoCountry country, String bban) {
        if (country == null) {
            throw new IllegalArgumentException("country cannot be null");
        }
        if (bban == null) {
            throw new IllegalArgumentException("bban cannot be null");
        }
        String normalizedBban = Normalizer.trimUpperCase(bban);
        String normalized = country.getAlpha2Code() + "00" + normalizedBban;
        this.structure = BbanStructure.forCountry(country).orElseThrow(() -> IbanFormatException.forNotSupportedCountry(bban, country));
        if (!this.structure.isBbanValid(normalizedBban)) {
            throw IbanFormatException.forInvalidBbanStructure(bban, this.structure);
        }
        String checkDigit = IbanCheckDigit.INSTANCE.calculate(normalized);
        this.value = country.getAlpha2Code() + checkDigit + normalizedBban;
    }

    public Iban(String s) {
        if (s == null) {
            throw new IllegalArgumentException("s cannot be null");
        }
        String normalized = Normalizer.trimUpperCase(s);
        if (normalized.length() < 5) {
            throw IbanFormatException.forInvalidLength(s);
        }
        IsoCountry country = Iban.findCountryFor(normalized).orElseThrow(() -> IbanFormatException.forUnknownCountry(s));
        this.structure = BbanStructure.forCountry(country).orElseThrow(() -> IbanFormatException.forNotSupportedCountry(s, country));
        if (!this.structure.isBbanValid(normalized.substring(4))) {
            throw IbanFormatException.forInvalidBbanStructure(s, this.structure);
        }
        if (!IbanCheckDigit.INSTANCE.validate(normalized)) {
            throw IbanFormatException.forIncorrectCheckDigits(s);
        }
        this.value = normalized;
    }

    public static boolean isValid(String s) {
        if (s == null) {
            return false;
        }
        String normalized = Normalizer.trimUpperCase(s);
        if (normalized.length() < 5) {
            return false;
        }
        Optional<IsoCountry> country = Iban.findCountryFor(normalized);
        if (!country.isPresent()) {
            return false;
        }
        Optional<BbanStructure> oStructure = BbanStructure.forCountry(country.get());
        if (!oStructure.isPresent()) {
            return false;
        }
        BbanStructure structure = oStructure.get();
        if (!structure.isBbanValid(normalized.substring(4))) {
            return false;
        }
        return IbanCheckDigit.INSTANCE.validate(normalized);
    }

    private static Optional<IsoCountry> findCountryFor(String iban) {
        return IsoCountry.fromAlpha2Code(iban.substring(0, 2));
    }

    public String getCountryCode() {
        return this.getCountry().getAlpha2Code();
    }

    public IsoCountry getCountry() {
        return this.structure.getCountry();
    }

    public String getCheckDigit() {
        return this.value.substring(2, 4);
    }

    public String getBban() {
        return this.value.substring(4);
    }

    public String getBankIdentifier() {
        int from = this.structure.getBankIdentifierStartIndexInclusive();
        int to = this.structure.getBankIdentifierEndIndexExclusive();
        return this.value.substring(4 + from, 4 + to);
    }

    public Optional<String> getBranchIdentifier() {
        Optional<Integer> from = this.structure.getBranchIdentifierStartIndexInclusive();
        Optional<Integer> to = this.structure.getBranchIdentifierEndIndexExclusive();
        if (from.isPresent() && to.isPresent()) {
            return Optional.of(this.value.substring(4 + from.get(), 4 + to.get()));
        }
        return Optional.empty();
    }

    public Optional<String> getNationalCheckDigit() {
        Optional<Integer> from = this.structure.getNationalCheckDigitStartIndexInclusive();
        Optional<Integer> to = this.structure.getNationalCheckDigitEndIndexExclusive();
        if (from.isPresent() && to.isPresent()) {
            return Optional.of(this.value.substring(4 + from.get(), 4 + to.get()));
        }
        return Optional.empty();
    }

    public String getAccountNumber() {
        int from = this.structure.getAccountNumberStartIndexInclusive();
        int to = this.structure.getAccountNumberEndIndexExclusive();
        return this.value.substring(4 + from, 4 + to);
    }

    public String toPrintableString() {
        StringBuilder printable = new StringBuilder(this.value);
        int length = this.value.length();
        for (int i = 0; i < length / 4; ++i) {
            printable.insert((i + 1) * 4 + i, ' ');
        }
        return printable.toString();
    }

    public String toString() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Iban other = (Iban)o;
        return this.value.equals(other.value);
    }

    public int hashCode() {
        return 29 * this.value.hashCode();
    }
}

