/*
 * Decompiled with CFR 0.152.
 */
package fr.marcwrobel.jbanking.iban;

import fr.marcwrobel.jbanking.iban.IbanPatternGroup;
import fr.marcwrobel.jbanking.swift.SwiftPatternCharacterRepresentation;
import fr.marcwrobel.jbanking.swift.SwiftPatternSyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class IbanPattern {
    private static final String GROUP_REGEX = "\\d{1,3}!?[ance]";
    private static final Pattern SWIFT_FORMAT_PATTERN = Pattern.compile("^(\\d{1,3}!?[ance]){1,1000}$");
    private static final Pattern SWIFT_FORMAT_GROUPS_PATTERN = Pattern.compile("\\d{1,3}!?[ance]");
    final String expression;
    final List<IbanPatternGroup> groups;
    final int length;

    private IbanPattern(String expression, List<IbanPatternGroup> groups) {
        this.expression = expression;
        this.groups = groups;
        int expectedLength = 0;
        for (IbanPatternGroup group : groups) {
            expectedLength += group.length;
        }
        this.length = expectedLength;
    }

    public static IbanPattern compile(String expression) {
        if (expression == null) {
            throw new IllegalArgumentException("the given expression cannot be null");
        }
        if (!SWIFT_FORMAT_PATTERN.matcher(expression).matches()) {
            throw new SwiftPatternSyntaxException(expression, "expression must match " + SWIFT_FORMAT_PATTERN);
        }
        return new IbanPattern(expression, IbanPattern.toGroups(expression));
    }

    private static List<IbanPatternGroup> toGroups(String expression) {
        Matcher matcher = SWIFT_FORMAT_GROUPS_PATTERN.matcher(expression);
        ArrayList<IbanPatternGroup> groups = new ArrayList<IbanPatternGroup>();
        int from = 0;
        IbanPatternGroup previousGroup = null;
        while (matcher.find()) {
            IbanPatternGroup group = IbanPattern.transform(expression, matcher.group(), from);
            from += group.length;
            if (previousGroup != null && previousGroup.canBeMergedTo(group)) {
                groups.remove(previousGroup);
                group = previousGroup.merge(group);
            }
            groups.add(group);
            previousGroup = group;
        }
        return Collections.unmodifiableList(groups);
    }

    private static IbanPatternGroup transform(String expression, String groupExpression, int from) {
        int maxOccurrences;
        boolean strict;
        int length = groupExpression.length();
        char qualifier = groupExpression.charAt(length - 1);
        Optional<SwiftPatternCharacterRepresentation> cRepresentation = SwiftPatternCharacterRepresentation.from(qualifier);
        if (!cRepresentation.isPresent()) {
            throw new SwiftPatternSyntaxException(expression, "illegal qualifier '" + qualifier + "' in group '" + groupExpression + "'");
        }
        boolean bl = strict = groupExpression.charAt(length - 2) == '!';
        if (!strict) {
            throw new SwiftPatternSyntaxException(expression, "non-fixed length group '" + groupExpression + "' is not supported");
        }
        try {
            maxOccurrences = Integer.parseInt(groupExpression.substring(0, length - 2));
        }
        catch (NumberFormatException e) {
            throw new SwiftPatternSyntaxException(expression, "could not extract length from '" + groupExpression + "'");
        }
        return new IbanPatternGroup(cRepresentation.get(), from, maxOccurrences);
    }

    boolean matches(String s) {
        if (s.length() != this.length) {
            return false;
        }
        for (IbanPatternGroup group : this.groups) {
            if (group.matches(s)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IbanPattern that = (IbanPattern)o;
        return this.expression.equals(that.expression);
    }

    public int hashCode() {
        return 13 + this.expression.hashCode();
    }

    public String toString() {
        return this.expression;
    }
}

