/*
 * Decompiled with CFR 0.152.
 */
package fr.marcwrobel.jbanking.iban;

import fr.marcwrobel.jbanking.IsoCountry;
import fr.marcwrobel.jbanking.IsoCurrency;
import fr.marcwrobel.jbanking.iban.BbanStructure;
import fr.marcwrobel.jbanking.iban.Iban;
import fr.marcwrobel.jbanking.iban.IbanPattern;
import fr.marcwrobel.jbanking.iban.IbanPatternGroup;
import java.util.Arrays;
import java.util.Objects;
import java.util.Random;

public final class RandomIban {
    private final Random random;

    public RandomIban(Random random) {
        this.random = Objects.requireNonNull(random);
    }

    public RandomIban() {
        this(new Random());
    }

    public Iban next() {
        return this.next(BbanStructure.values());
    }

    public Iban next(BbanStructure ... structures) {
        BbanStructure structure = structures[this.random.nextInt(structures.length)];
        return this.generate(structure);
    }

    public Iban next(IsoCountry ... countries) {
        IsoCountry country = countries[this.random.nextInt(countries.length)];
        BbanStructure structure = BbanStructure.forCountry(country).orElseThrow(() -> new IllegalArgumentException(String.format("no corresponding structure could be found for country '%s'", new Object[]{country})));
        return this.generate(structure);
    }

    public Iban next(String ... isoCountryAlpha2Codes) {
        String countryCode = isoCountryAlpha2Codes[this.random.nextInt(isoCountryAlpha2Codes.length)];
        IsoCountry country = IsoCountry.fromAlpha2Code(countryCode).orElseThrow(() -> new IllegalArgumentException(String.format("no corresponding country could be found for alpha-2 code '%s'", countryCode)));
        BbanStructure structure = BbanStructure.forCountry(country).orElseThrow(() -> new IllegalArgumentException(String.format("no corresponding structure could be found for country '%s'", new Object[]{country})));
        return this.generate(structure);
    }

    public Iban next(IsoCurrency ... currencies) {
        IsoCountry[] countries = (IsoCountry[])Arrays.stream(currencies).flatMap(currency -> currency.getCountries().stream()).filter(country -> BbanStructure.forCountry(country).isPresent()).sorted().toArray(IsoCountry[]::new);
        return this.next(countries);
    }

    private Iban generate(BbanStructure structure) {
        IbanPattern pattern = structure.getBbanPattern();
        StringBuilder bban = new StringBuilder(pattern.length);
        for (IbanPatternGroup group : pattern.groups) {
            for (int i = 0; i < group.length; ++i) {
                String alphabet = group.characters.alphabet();
                bban.append(alphabet.charAt(this.random.nextInt(alphabet.length())));
            }
        }
        return new Iban(structure.getCountry(), bban.toString());
    }
}

